/**
 * Modification Name: Advanced Registration Check
 *
 * Version: 1.0
 *
 * Author: GuldantheWarlock (GuldantheWarlock@xmbgarage.com)
 *
 * Description:
 * This modification will put checks on the registration form to inform the user if the username and email are available
 * and if the username contains any invalid characters
 *
 * Supported Version: XMB 1.9.5 SP1
 *
 * License Note: This modification is released under the GPL License v3. A copy is provided with this software package.
 *
 * Author Note:
 * You downloaded this modification from XMBGarage.com, the #1 source for XMB related downloads.
 * Please visit http://www.xmbgarage.com/ for support.
 *
 * Please backup your files before installing this modification.
 * Neither XMB Garage nor the author can be held responsible if your board stops functioning properly due to you installing this modification.
 */

var Reg = {
    RESULT_OK: '<span style="font-size: 11px;"><span style="color: green;font-weight: bold;">&#10004;</span></span>',
    RESULT_BAD: '<span style="font-size: 11px;"><span style="color: red;font-weight: bold;">&#10008;</span>__MSG__</span>',

    Lang: {},
    xmlhttp: null,

    el: function(id) {
        return document.getElementById(id);
    },
    
    showMsg: function(id, type, msg) {
        Reg.el(id).innerHTML = type.replace('__MSG__', '&nbsp;'+((msg) ? Reg.Lang[msg] : ''));
    },

    hideMsg: function(id) {
        Reg.el(id).innerHTML = '';
    },

    checkUsername: function(val) {
        Reg.xmlhttp.open('GET', './member.php?action=regcheck&do=username&input='+encodeURIComponent(val)+'&dummy='+(new Date()).getTime(), true);

        Reg.xmlhttp.onreadystatechange = function() {
            if (Reg.xmlhttp.readyState == 4 && Reg.xmlhttp.status == 200) {
                switch(Reg.xmlhttp.responseText) {
                    case 'available':
                        Reg.showMsg('username-status', Reg.RESULT_OK);
                        break;
                    case 'taken':
                        Reg.showMsg('username-status', Reg.RESULT_BAD, 'username_taken');
                        break;
                    case 'bad-chars':
                        Reg.showMsg('username-status', Reg.RESULT_BAD, 'invalid_chars');
                        break;
                    case 'too-short':
                        Reg.showMsg('username-status', Reg.RESULT_BAD, 'username_short');
                        break;
                    case 'too-long':
                        Reg.showMsg('username-status', Reg.RESULT_BAD, 'username_long');
                        break;
                    case 'no-input':
                        Reg.hideMsg('username-status');
                        break;
                }
                return true;
            }
        };
        Reg.xmlhttp.send(null);
    },
    
    checkEmail: function(val) {
        Reg.xmlhttp.open('GET', './member.php?action=regcheck&do=email&input='+encodeURIComponent(val)+'&dummy='+(new Date()).getTime(), true);

        Reg.xmlhttp.onreadystatechange = function() {
            if (Reg.xmlhttp.readyState == 4 && Reg.xmlhttp.status == 200) {
                switch(Reg.xmlhttp.responseText) {
                    case 'valid':
                        Reg.showMsg('email-status', Reg.RESULT_OK);
                        break;
                    case 'invalid-email':
                        Reg.showMsg('email-status', Reg.RESULT_BAD, 'email_invalid');
                        break;
                    case 'in-use':
                        Reg.showMsg('email-status', Reg.RESULT_BAD, 'email_taken');
                        break;
                    case 'no-input':
                        Reg.hideMsg('email-status');
                        break;
                }
                return true;
            }
        };
        Reg.xmlhttp.send(null);
    },

    checkPasswords: function() {
        var val = document.forms['reg'].elements['password'].value,
           val2 = document.forms['reg'].elements['password2'].value;

        Reg.xmlhttp.open('GET', './member.php?action=regcheck&do=password&input='+encodeURIComponent(val)+'&input2='+encodeURIComponent(val2)+'&dummy='+(new Date()).getTime(), true);
        Reg.xmlhttp.onreadystatechange = function() {
            if (Reg.xmlhttp.readyState == 4 && Reg.xmlhttp.status == 200) {
                switch(Reg.xmlhttp.responseText) {
                    case 'match':
                        Reg.showMsg('password-status', Reg.RESULT_OK);
                        Reg.showMsg('password2-status', Reg.RESULT_OK);
                        break;
                    case 'no-match':
                        Reg.showMsg('password-status', Reg.RESULT_BAD);
                        Reg.showMsg('password2-status', Reg.RESULT_BAD, 'pwnomatch');
                        break;
                    case 'no-input':
                        Reg.hideMsg('password-status');
                        Reg.hideMsg('password2-status');
                        break;
                }
                return true;
            }
        };
        Reg.xmlhttp.send(null);
    },
    init: function() {
        try {
            Reg.xmlhttp = new XMLHttpRequest();
        } catch(e) {
            Reg.xmlhttp = new ActiveXObject('Msxml2.XMLHTTP');
        }
    }
};

if (window.attachEvent) {
    window.attachEvent('onload', Reg.init);
} else {
    window.addEventListener('load', Reg.init, true);
}