<?php
/**
 * Title: Calendar System
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'calendar.php');

require 'header.php';

loadtemplates(
'functions_smilieinsert',
'functions_smilieinsert_smilie',
'functions_bbcode',
'functions_bbcodeinsert',
'cal_admin',
'cal_holiday',
'cal_new_event',
'cal_edit_event',
'cal_add_event',
'cal_add_holiday',
'cal_edit_holiday',
'cal_event_edit',
'cal_eventlist',
'misc_feature_notavailable'
);

smcwcache();

eval('$css = "'.template('css').'";');

if ($SETTINGS['calendar_status'] == 'off') {
    eval('echo "'.template('header').'";');
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

switch($action) {
    case 'settings':
        nav('<a href="calendar.php">'.$lang['textcalendar'].'</a>');
        nav($lang['calendar_settings']);
        break;
    case 'admin':
        nav('<a href="calendar.php">'.$lang['textcalendar'].'</a>');
        nav($lang['calendar_admin']);
        break;
    default:
        nav($lang['textcalendar']);
        break;
}

eval('$bbcodescript = "'.template('functions_bbcode').'";');

eval('echo "'.template('header').'";');

$monthNames = array('offset', $lang['textjan'], $lang['textfeb'], $lang['textmar'], $lang['textapr'], $lang['textmay'], $lang['textjun'], $lang['textjul'], $lang['textaug'], $lang['textsep'], $lang['textoct'], $lang['textnov'], $lang['textdec']);
$dayNames = array('offset', $lang['textsun'], $lang['textmon'], $lang['texttue'], $lang['textwed'], $lang['textthu'], $lang['textfri'], $lang['textsat']);

if (!isset($month)) {
    $month = gmdate("n");
}

if (!isset($day)) {
    $day = gmdate("d");
}

if (!isset($year)) {
    $year = gmdate("Y");
}

if ($month < 1 || $month > 12) {
    $month = gmdate("n");
}

if ($day < 1 || $day > 31) {
    $day = gmdate("d");
}

$query = $db->query("SELECT * FROM ".X_PREFIX."calendar");
$cal_set = $db->fetch_array($query);
$db->free_result($query);

$cal_showbdays = $cal_set['showbdays'];
$cal_showholidays = $cal_set['showholidays'];
$cal_showevents = $cal_set['showevents'];
$cal_display = $cal_set['display'];
$cal_postevents = $cal_set['postevents'];
$cal_membersonly = $cal_set['membersonly'];

if ($cal_set['themes'] == $lang['texton']) {
    $cal_bdaycolor = isset(${$cal_set['bdaycolor']}) ? "${$cal_set['bdaycolor']}" : '';
    $cal_holidaycolor = isset(${$cal_set['holidaycolor']}) ? "${$cal_set['holidaycolor']}" : '';
    $cal_eventcolor = isset(${$cal_set['eventcolor']}) ? "${$cal_set['eventcolor']}" : '';
} else {
    $cal_bdaycolor = $cal_set['bdaycolor'];
    $cal_holidaycolor = $cal_set['holidaycolor'];
    $cal_eventcolor = $cal_set['eventcolor'];
}

$cal_dayeffect = $cal_set['dayeffect'];
$cal_bdayimage = $cal_set['bdayimage'];

$useend = '';
$eventform = '';
$listed_icons = 0;
$icons = '<input type="radio" name="posticon" value="" '.$cheHTML.' /> <img src="'.$THEME['imgdir'].'/default_icon.gif" alt="[*]" />';
if (isset($newevent) || isset($editevent)) {
    $querysmilie = $db->query("SELECT url, code FROM ".X_PREFIX."smilies WHERE type='picon'");
    while($smilie = $db->fetch_array($querysmilie)) {
        $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" /><img src="'.$THEME['smdir'].'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
        $listed_icons += 1;
        if ($listed_icons == 9) {
            $icons .= '<br />';
            $listed_icons = 0;
        }
    }
    $db->free_result($querysmilie);

    $bbcodeinsert = bbcodeinsert();
    $smilieinsert = smilieinsert();
}

if ($action && !X_GUEST) {
    if ($action == 'settings' && (X_ADMIN)) {
        if (!isset($submitsettings)) {
            if ($cal_set['themes'] == $lang['texton']) {
                $themecolors = "<option value=''>$lang[calendar_color]</option>\n";
                $themecolors .= "<option style='color:$link' value='link'>$lang[textlink]</option>\n";
                $themecolors .= "<option style='color:$bordercolor' value='bordercolor'>$lang[textborder]</option>\n";
                $themecolors .= "<option style='color:$headertext' value='headertext'>$lang[textheadertext]</option>\n";
                $themecolors .= "<option style='color:$tabletext' value='tabletext'>$lang[texttabletext]</option>\n";
                $themecolors .= "<option style='color:$text' value='text'>$lang[texttext]</option>\n";
                $themecolors .= "<option style='color:$cattext' value='cattext'>$lang[textcattextcolor]</option>\n";

                $bcolor = "<select name='bdaycolor' size='1'>\n";
                if ($cal_set['bdaycolor'] != '') {
                    $bcolor .= str_replace("<option style='color:$cal_bdaycolor' value='$cal_set[bdaycolor]'>", "<option selected style='color:$cal_bdaycolor' value='$cal_set[bdaycolor]'>", $themecolors);
                } else {
                    $bcolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }

                $bcolor .= "</select>\n";
                $hcolor = "<select name='holidaycolor' size='1'>\n";
                if ($cal_set['holidaycolor'] != '') {
                    $hcolor .= str_replace("<option style='color:$cal_holidaycolor' value='$cal_set[holidaycolor]'>", "<option selected style='color:$cal_holidaycolor' value='$cal_set[holidaycolor]'>", $themecolors);
                } else {
                    $hcolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }

                $hcolor .= "</select>\n";
                $ecolor = "<select name='eventcolor' size='1'>\n";
                if ($cal_set['eventcolor'] != '') {
                    $ecolor .= str_replace("<option style='color:$cal_eventcolor' value='$cal_set[eventcolor]'>", "<option selected style='color:$cal_eventcolor' value='$cal_set[eventcolor]'>", $themecolors);
                } else {
                    $ecolor .= str_replace("<option value=''>$lang[calendar_color]</option>", "<option selected value=''>$lang[calendar_color]</option>", $themecolors);
                }
                $ecolor .= "</select>\n";
            } else {
                $bcolor  = "<input type='text' name='bdaycolor' size='10' value='$cal_bdaycolor'>\n";
                $hcolor  = "<input type='text' name='holidaycolor' size='10' value='$cal_holidaycolor'>\n";
                $ecolor  = "<input type='text' name='eventcolor' size='10' value='$cal_eventcolor'>\n";
            }

            $use_theme = "<select name='themes' size='1'>\n";
            $use_theme .= "<option value='$lang[texton]'";
            if ($cal_set['themes'] == $lang['texton']) {
                $use_theme .= " selected='selected' ";
            }

            $use_theme .= ">$lang[texton]</option>\n";
            $use_theme .= "<option value='$lang[textoff]'";
            if ($cal_set['themes'] == $lang['textoff']) {
                $use_theme .= " selected='selected' ";
            }

            $use_theme .= ">$lang[textoff]</option>\n";
            $use_theme .= "</select>\n";

            $day_effect = "<select name='dayeffect' size='1'>\n";
            $day_effect .= "<option value='none'";
            if ($cal_dayeffect == 'none') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textnone]</option>\n";
            $day_effect .= "<option value='raised'";
            if ($cal_dayeffect == 'raised') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textraised]</option>\n";
            $day_effect .= "<option value='sunken'";
            if ($cal_dayeffect == 'sunken') {
                $day_effect .= " selected='selected' ";
            }

            $day_effect .= ">$lang[textsunken]</option>\n";
            $day_effect .= "</select>\n";

            $showbdays = "<select name='showbdays' size='1'>\n";
            $showbdays .= "<option value='off'";
            if ($cal_showbdays == 'off') {
                $showbdays .= " selected='selected' ";
            }

            $showbdays .= ">$lang[textoff]</option>\n";
            $showbdays .= "<option value='on'";
            if ($cal_showbdays == 'on') {
                $showbdays .= " selected='selected' ";
            }

            $showbdays .= ">$lang[texton]</option>\n";
            $showbdays .= "</select>\n";

            $showholidays = "<select name='showholidays' size='1'>\n";
            $showholidays .= "<option value='off'";
            if ($cal_showholidays == 'off') {
                $showholidays .= " selected='selected' ";
            }

            $showholidays .= ">$lang[textoff]</option>\n";
            $showholidays .= "<option value='on'";
            if ($cal_showholidays == 'on') {
                $showholidays.= " selected='selected' ";
            }

            $showholidays .= ">$lang[texton]</option>\n";
            $showholidays .= "</select>\n";

            $showevents = "<select name='showevents' size='1'>\n";
            $showevents .= "<option value='off'";
            if ($cal_showevents == 'off') {
                $showevents.= " selected='selected' ";
            }

            $showevents .= ">$lang[textoff]</option>\n";
            $showevents .= "<option value='list'";
            if ($cal_showevents == 'list') {
                $showevents .= " selected='selected' ";
            }

            $showevents .= ">$lang[textlist]</option>\n";
            $showevents .= "<option value='count'";
            if ($cal_showevents == 'count') {
                $showevents.= " selected='selected' ";
            }

            $showevents .= ">$lang[textcount]</option>\n";
            $showevents .= "</select>\n";

            $cdisplay = "<select name='display' size='1'>\n";
            $cdisplay .= "<option value='month'";
            if ($cal_display == 'month') {
                $cdisplay .= " selected='selected' ";
            }

            $cdisplay .= ">$lang[calendar_display_month]</option>\n";
            $cdisplay .= "<option value='list'";
            if ($cal_display == 'list') {
                $cdisplay .= " selected='selected' ";
            }

            $cdisplay .= ">$lang[textlist]</option>\n";
            $cdisplay .= "</select>\n";

            $postevents = "<select name='postevents' size='1'>\n";
            $postevents .= "<option value='Super Administrator|Administrator'";
            if ($cal_postevents == "Super Administrator|Administrator") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textpermission2]</option>\n";
            $postevents .= "<option value='Super Administrator|Administrator|Super Moderator|Moderator'";
            if ($cal_postevents == "Super Administrator|Administrator|Super Moderator|Moderator") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textpermission3]</option>\n";
            $postevents .= "<option value='Super Administrator|Administrator|Super Moderator|Moderator|VIP Member|Member'";
            if ($cal_postevents == "Super Administrator|Administrator|Super Moderator|Moderator|VIP Member|Member") {
                $postevents .= " selected='selected' ";
            }

            $postevents .= ">$lang[textallmembers]</option>\n";
            $postevents .= "</select>\n";

            $cmembersonly = "<select name='membersonly' size='1'>\n";
            $cmembersonly .= "<option value='0'";
            if ($cal_membersonly == 0) {
                $cmembersonly .= " selected='selected' ";
            }

            $cmembersonly .= ">$lang[texteveryone]</option>\n";
            $cmembersonly .= "<option value='1'";
            if ($cal_membersonly == 1) {
                $cmembersonly .= " selected='selected' ";
            }

            $cmembersonly .= ">$lang[textmembers]</option>\n";
            $cmembersonly.= "</select>\n";
            eval('echo stripslashes("'.template('cal_admin').'");');
        } else {
            $db->query("UPDATE ".X_PREFIX."calendar SET showbdays='$showbdays', showholidays='$showholidays', showevents='$showevents', display='$display', postevents='$postevents', membersonly='$membersonly', bdaycolor='$bdaycolor', holidaycolor='$holidaycolor', eventcolor='$eventcolor', dayeffect='$dayeffect', bdayimage='$bdayimage', themes='$themes'");
            message($lang['calendar_updated'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
        }
    }

    if ($action == 'admin') {
        if (isset($editholidaysubmit) && (X_ADMIN)) {
            $holidaydesc = addslashes($holidaydesc);
            $db->query("UPDATE ".X_PREFIX."holidays SET description='$holidaydesc', country='$holidaycountry' WHERE id=$holidayid");
            message($lang['holidaysupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
        }

        if (isset($newholiday) && (X_ADMIN)) {
            $newholidaydesc = addslashes($newholidaydesc);
            $db->query("INSERT INTO ".X_PREFIX."holidays VALUES ('', '$newholidaydesc', '$monthNames[$month] $day', '$newholidaycountry')");
            message($lang['holidaysupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
        } else if (isset($editholiday) && (X_ADMIN)) {
            if ($holidayid == 'default') {
                $editholiday = '';
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."holidays WHERE id='$holidayid'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                $holidaydesc = stripslashes($result['description']);
                eval('echo stripslashes("'.template('cal_holiday').'");');
            }
        } else if (isset($deleteholiday) && (X_ADMIN)) {
            if ($holidayid != 'default') {
                $db->query("DELETE FROM ".X_PREFIX."holidays WHERE id='$holidayid'");
                message($lang['holidaysupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
            }
        }

        if (isset($editeventsubmit)) {
            if ($message != '' && $eventsubject != '') {
                $eventsubject = str_replace("<", "&lt;", $eventsubject);
                $eventsubject = str_replace(">", "&gt;", $eventsubject);
                $message = stripslashes($message);
                $message = addslashes($message);
                $eventsubject = addslashes($eventsubject);

                if (isset($membersonly)) {
                    $membersonly = 1;
                } else {
                    $membersonly = 0;
                }

                $posticon = (isset($posticon) && $posticon != '') ? $posticon : '';

                $submittime = $onlinetime;
                $mid = 0;
                if (X_MEMBER) {
                    $query = $db->query("SELECT uid AS 'memberid' FROM ".X_PREFIX."members WHERE username='$xmbuser'");
                    $result = $db->fetch_array($query);
                    $db->free_result($query);
                    $mid = (int)$result['memberid'];
                }

                if ($eventid == 'new') {
                    $db->query("INSERT INTO ".X_PREFIX."events (`id`, `mid`, `author`, `eventday`, `dateposted`, `dateupdated`, `subject`, `body`, `membersonly`, `updatedby`, `icon`) VALUES ('', '$mid', '$xmbuser', '$monthNames[$month] $day, $year', '$submittime', '$submittime', '$eventsubject', '$message', '$membersonly', '', '$posticon')");
                    message($lang['eventsupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
                } else {
                    $db->query("UPDATE ".X_PREFIX."events SET subject='$eventsubject', body='$message', dateupdated='$submittime', membersonly='$membersonly', updatedby='$xmbuser', icon='$posticon' WHERE id=$eventid ");
                    message($lang['eventsupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
                }
            } else {
                message('Please enter both an event subject and an event message.', false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
            }
        }

        if (isset($newevent)) {
            $neweventsubject = stripslashes($neweventsubject);
            eval('echo stripslashes("'.template('cal_new_event').'");');
        } else if (isset($editevent)) {
            if ($eventid == 'default') {
                $editevent = '';
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE id='$eventid'");
                $result = $db->fetch_array($query);
                $db->free_result($query);

                if (X_ADMIN || $xmbuser == $result['author']) {
                    $eventsubject = stripslashes($result['subject']);
                    $message = stripslashes($result['body']);
                    $icon = $result['icon'];

                    $membersonly = '';
                    if ($result['membersonly'] == 1) {
                        $membersonly = " checked='checked' ";
                    }

                    if ($icon != '') {
                        $icons = str_replace($icon."\"", $icon."\" checked='checked'", $icons);
                    }
                    eval('echo stripslashes("'.template('cal_edit_event').'");');
                }
            }
        } else if (isset($deleteevent)) {
            if ($eventid != 'default') {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE id='$eventid'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                if (X_ADMIN || $xmbuser == $result['author']) {
                    $db->query("DELETE FROM ".X_PREFIX."events WHERE id='$eventid'");
                    message($lang['eventsupdate'], false, '', '', 'calendar.php?month='.$month.'&day='.$day.'&year='.$year, true, false, true);
                }
            }
        }

        if (!isset($newevent) && !isset($editholiday) && !isset($editevent)) {
            $cal_edit_holiday = '';
            if (X_ADMIN) {
                $query = $db->query("SELECT COUNT(*) AS Num FROM ".X_PREFIX."holidays WHERE monthday='$monthNames[$month] $day' ORDER BY description");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                if ($result['Num'] > 0) {
                    $holid1 = "<select name='holidayid'><option value='default'>$lang[selectholiday]</option>\n";
                    $query = $db->query("SELECT * FROM ".X_PREFIX."holidays WHERE monthday='$monthNames[$month] $day' ORDER BY description");
                    while($holiday = $db->fetch_array($query)) {
                        $description = stripslashes($holiday['description']);
                        $holid1 .= "<option value='$holiday[id]'>$description";
                        if ($holiday['country']) {
                            $holid1 .= " ($holiday[country])";
                        }
                        $holid1 .= "</option>\n";
                    }
                    $holid1 .= "</select>&nbsp;&nbsp;\n";
                    $db->free_result($query);
                    eval('$cal_edit_holiday = "'.template('cal_edit_holiday').'";');
                }
                eval('$cal_add_holiday = "'.template('cal_add_holiday').'";');
            }

            $mid = 0;
            if (X_MEMBER) {
                $query = $db->query("SELECT uid AS 'memberid' FROM ".X_PREFIX."members WHERE username='$xmbuser'");
                $result = $db->fetch_array($query);
                $db->free_result($query);
                $mid = (int)$result['memberid'];
            }

            if (X_ADMIN) {
                $query = $db->query("SELECT COUNT(*) AS Num FROM ".X_PREFIX."events WHERE eventday='$monthNames[$month] $day, $year'");
            } else {
                $query = $db->query("SELECT COUNT(*) AS Num FROM ".X_PREFIX."events WHERE eventday='$monthNames[$month] $day, $year' AND mid='$mid'");
            }
            $result = $db->fetch_array($query);
            $db->free_result($query);

            $cal_event_edit = '';
            if ($result['Num'] > 0) {
                $eventi = "<select name='eventid'><option value='default'>$lang[selectevent]</option>\n";
                if (X_ADMIN) {
                    $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday='$monthNames[$month] $day, $year' ORDER BY subject");
                } else {
                    $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday='$monthNames[$month] $day, $year' AND mid='$mid' ORDER BY subject");
                }
                while($event = $db->fetch_array($query)) {
                    $subject = stripslashes($event['subject']);
                    $eventi .= "<option value='$event[id]'>$subject";
                    $eventi .= "</option>\n";
                }
                $eventi .= "</select>&nbsp;&nbsp;\n";
                $db->free_result($query);
                eval('$cal_event_edit = "'.template('cal_event_edit').'";');
            }
            eval('echo stripslashes("'.template('cal_add_event').'");');
        }
    }
}

if ($action == 'list') {
    $getevents = '';
    if (X_GUEST) {
        if ($cal_membersonly == 0) {
            if (!$eventid) {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND membersonly='0' ORDER by subject");
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND membersonly='0' AND id='$eventid'");
            }
            $getevents = 'true';
        }
    } else {
        if (!$eventid) {
            $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$monthNames[$month] $day, $year' ORDER BY subject");
        } else {
            $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$monthNames[$month] $day, $year' AND id='$eventid'");
            $getevents = 'true';
        }
    }

    if ($getevents != '') {
        $eventlist = '';
        while($event = $db->fetch_array($query)) {
            $author = $event['author'];
            $event['subject'] = stripslashes($event['subject']);
            $icon = $event['icon'];

            $eventlist .= "<tr>\n";
            $eventlist .= "<td class='header'>\n";

            if ($icon != '') {
                $eventlist .= "<img src='$THEME[smdir]/$icon' border='0' style='vertical-align:middle' alt='$THEME[smdir]/$icon' /> ";
            }

            $eventlist .= " $lang[textpostby] $author: $event[subject]</td>\n";
            $eventlist .= "</tr>\n";
            $eventlist .= "<tr>\n";
            $eventlist .= "<td bgcolor='$altbg1' class='tablerow' align='left'>\n";

            $eventlist .= postify(stripslashes($event['body']), 'no', 'no', 'yes', 'no', 'yes', 'yes', 'yes');
            $eventlist .= "<br /><br /><hr />\n";

            $postdate = gmdate($dateformat, $event['dateposted'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
            $posttime = gmdate($timecode, $event['dateposted'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
            $eventlist .= "$lang[event_poston]&nbsp;$postdate $lang[textat] $posttime $lang[textby] $author<br />\n";

            if ($event['dateposted'] < $event['dateupdated']) {
                $updatedate = gmdate($dateformat, $event['dateupdated'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
                $updatetime = gmdate($timecode, $event['dateupdated'] + ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600));
                $eventlist .= "$lang[event_lastupdated]&nbsp;$updatedate $lang[textat] $updatetime $lang[textby] $event[updatedby]<br />\n";
            }
            $eventlist .= "</td></tr>\n";
            $eventlist .= "<tr><td bgcolor='$altbg2' class='tablerow' align='center'>\n";
            if (X_STAFF || $xmbuser == $author) {
                $eventlist .= "<input class='submit' type='button' value='$lang[calendar_editevent]' onclick=\"location.href='calendar.php?action=admin&amp;editevent=edit&amp;eventid=$event[id]'\" style=\"cursor: pointer; cursor: hand;\">\n";
                $eventlist .= "&nbsp;<input class='submit' type='button' value='$lang[calendar_deleteevent]' onclick=\"location.href='calendar.php?action=admin&amp;deleteevent=delete&amp;eventid=$event[id]'\" style=\"cursor: pointer; cursor: hand;\">\n";
            }
        }
        $db->free_result($query);
        eval('echo stripslashes("'.template('cal_eventlist').'");');
    }
}

if (!isset($action)) {
    $tmOffset = ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600);
    $monthYear = gmmktime(0, 0, 0, $month, 1, $year) - $tmOffset;
    $daysInMonth = gmdate("t", $monthYear + $tmOffset);
    $firstDay = gmdate("w", $monthYear + $tmOffset) + 1;
    $dayOfMonth = 1;
    $curDay = 1;
    $colWidth = floor(100/7);
    $todayDay = gmdate("d", $onlinetime + $tmOffset);
    $todayMonth = gmdate("n", $onlinetime + $tmOffset);
    $todayYear = gmdate("Y", $onlinetime + $tmOffset);
    $curMonth = $monthNames[$month];
    $bdayMonth = gmdate("m", $monthYear);

    $holidays = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
    $bdays = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
    $events = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

    if ($cal_display == 'month') {
        if ($cal_dayeffect == 'sunken'){
            $daystyle = "style='border-style: inset; border-color: $THEME[bordercolor]; border-width: 2px;'";
        } else if ($cal_dayeffect == 'raised') {
            $daystyle = "style='border-style: outset; border-color: $THEME[bordercolor]; border-width: 2px;'";
        } else {
            $daystyle = '';
        }

        if ($cal_showbdays == 'on') {
            $query = $db->query("SELECT username, bday FROM ".X_PREFIX."members WHERE bday LIKE '%-$bdayMonth-%' ORDER BY username");
            while($member = $db->fetch_array($query)) {
                $bday = explode('-', $member['bday']);
                $bdayDay = (int) trim($bday[2]);
                $bdayYear = trim($bday[0]);
                $bdayAge = $year - $bdayYear;

                $memlink = '';
                if ($cal_bdayimage != '') {
                    $memlink = "<img src='./images/$cal_bdayimage' border='0' alt='$lang[texthappybday] $member[username]!' title='$lang[texthappybday] $member[username]!' />&nbsp;";
                }

                $memlink .= "<a href='member.php?action=viewpro&amp;member=".rawurlencode($member['username'])."' style='color:$cal_bdaycolor'>$member[username]</a> ($bdayAge)";

                if ($bdays[$bdayDay] == '') {
                    $bdays[$bdayDay] = $memlink;
                } else {
                    $bdays[$bdayDay] .= "<br />$memlink";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showholidays == 'on') {
            $query = $db->query("SELECT * FROM ".X_PREFIX."holidays WHERE monthday LIKE '$curMonth%'");
            while($holiday = $db->fetch_array($query)) {
                $hday = explode(' ', $holiday['monthday']);
                $holidayDay = trim(str_replace(',', '', $hday[1]));
                $holidaytext = stripslashes($holiday['description']);
                if ($holiday['country']) {
                    $holidaytext .= " ($holiday[country])";
                }

                if ($holidays[$holidayDay] == '') {
                    $holidays[$holidayDay] = "<font color='$cal_holidaycolor'>$holidaytext</font>";
                } else {
                    $holidays[$holidayDay] .= "<font color='$cal_holidaycolor'>, $holidaytext</font>";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showevents != 'off') {
            $getevents = '';
            if (X_GUEST) {
                if ($cal_membersonly == 0) {
                    $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$curMonth%$year' AND membersonly='0'");
                    $getevents = "true";
                }
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$curMonth%$year'");
                $getevents = 'true';
            }

            if ($getevents != '') {
                while($event = $db->fetch_array($query)) {
                    $ev = explode(' ', $event['eventday']);
                    $e = trim(str_replace(',', '', $ev[1]));

                    if ($cal_showevents == 'count') {
                        $events[$e]++;
                    } else {
                        if ($events[$e] == "0") {
                            $events[$e] = '';
                            if ($event['icon'] != '') {
                                $events[$e] .= "<img src='$THEME[smdir]/$event[icon]' border='0' style='vertical-align:middle' alt='' />&nbsp;";
                            }
                            $events[$e] .= "<a href='calendar.php?action=list&month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                            $events[$e] .= stripslashes($event['subject']);
                            $events[$e] .= "</a>";
                        } else {
                            $events[$e] .= "<br /><br />";
                            if ($event['icon'] != '') {
                                $events[$e] .= "<img src='$THEME[smdir]/$event[icon]' border='0' style='vertical-align:middle' alt='' />&nbsp;";
                            }
                            $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                            $events[$e] .= stripslashes($event['subject']);
                            $events[$e] .= "</a>";
                        }
                    }
                }
                $db->free_result($query);
            }
        }

        $calendar  = "<table cellspacing='0' cellpadding='0' border='0' width='$THEME[tablewidth]' align='center'>\n";
        $calendar .= "<tr><td bgcolor='$THEME[bordercolor]'>\n";
        $calendar .= "<table border='0' cellspacing='$THEME[borderwidth]' cellpadding='$THEME[tablespace]' width='100%' align='center'> \n";
        $calendar .= "<tr><td colspan='7' align='center' class='header'>$monthNames[$month] $year</td></tr>\n";

        $calendar .= " <tr class='ctrcategory'>\n";
        for($i = 1; $i <= 7; $i++) {
            $calendar .= "<td width='$colWidth%'><font color='$THEME[cattext]'><strong>$dayNames[$i]</strong></font></td>\n";
        }
        $calendar .= "</tr>\n";

        for($i = 1; $i < $firstDay; $i++) {
            if ($i == 1) {
                $calendar .= "<tr>\n";
            }
            $calendar .= "<td bgcolor='$THEME[altbg2]'>&nbsp;</td>\n";
            $curDay++;
        }

        $adminDate = '';
        $poststatus = explode('|', $cal_postevents);
        $index = 0;
        while($poststatus[$index] && !isset($canuserpost)) {
            if ($self['status'] == $poststatus[$index]) $canuserpost = 'yes';
            $index++;
        }

        for($i = 1; $i <= $daysInMonth; $i++) {
            if ($curDay == 1) {
                $calendar .= "<tr>\n";
            }

            $mouseover = " onmouseover='this.style.backgroundColor=\"$THEME[altbg2]\";' onmouseout='this.style.backgroundColor=\"$THEME[altbg1]\";'";

            if ($canuserpost == 'yes') {
                $adminDate = " onclick=\"location.href='calendar.php?action=admin&amp;month=$month&amp;day=$i&amp;year=$year'\" ";
            }

            $eventcount = 0;
            if ($cal_showevents == 'count') {
                if ($events[$i] == 1) {
                    $eventlink = "<a href='calendar.php?action=list&amp;month=$month&amp;day=$i&amp;year=$year' style='color:$cal_eventcolor'>1 $lang[textevent]</a>";
                } else if ($events[$i] > 1) {
                    $eventlink = "<a href='calendar.php?action=list&amp;month=$month&amp;day=$i&amp;year=$year' style='color:$cal_eventcolor'>$events[$i] $lang[textevents]</a>";
                } else      {
                    $eventlink = '';
                }
            } else if ($cal_showevents == 'list') {
                if ($events[$i] != "0") {
                    $eventlink = "$events[$i]";
                    $eventcount = count(explode("<br />", $eventlink));
                } else {
                    $eventlink = '';
                }
            } else {
                $eventlink = '';
            }

            if ($year == $todayYear && $month == $todayMonth && $i == $todayDay) {
                $calendar .= "<td bgcolor='$THEME[altbg2]' class='tablerow' valign='top' $adminDate $daystyle>\n";
                $calendar .= "<div align='right'><strong>[$i]</strong></div><br />\n";
            } else {
                $calendar .= "<td bgcolor='$THEME[altbg1]' class='tablerow' valign='top' $adminDate $mouseover>\n";
                $calendar .= "<div align='right'><strong>$i</strong></div><br />\n";
            }

            $items = 0;
            if ($holidays[$i] != '') {
                $calendar .= "$holidays[$i]<br />\n";
                $items++;
            }

            if ($eventlink != '') {
                $calendar .= "$eventlink<br />\n";
                $items++;
            }

            if ($bdays[$i] != '') {
                $calendar .= "$bdays[$i]<br />\n";
                $items++;
            }

            for($lines = $items + $eventcount; $lines < 4; $lines++) {
                $calendar .= "<br />";
            }

            $calendar .= "</td>\n";
            if ($curDay == 7) {
                $calendar .= "</tr>\n";
                $curDay = 1;
            } else {
                $curDay++;
            }
        }

        if ($curDay > 1) {
            for($i = $curDay; $i <= 7; $i++) {
                $calendar .= "<td bgcolor='$THEME[altbg2]'>&nbsp;</td>\n";
                if ($i == 7) {
                    $calendar .= "</tr>\n";
                }
            }
        }
        $calendar .= " </tr>\n";
        $calendar .= "</table>\n";
        $calendar .= " </td></tr></table>\n";
    } else {
        if ($cal_showbdays == 'on') {
            $query = $db->query("SELECT username, bday FROM ".X_PREFIX."members WHERE bday LIKE '$curMonth%' ORDER BY username");
            while($member = $db->fetch_array($query)) {
                $bday = explode(' ', $member['bday']);
                $bdayDay = trim(str_replace(',', '', $bday[1]));
                $bdayYear = trim($bday[2]);
                $bdayAge  = $year - $bdayYear;
                $memlink = '';
                if ($cal_bdayimage != '' && file_exists('images/'.$cal_bdayimage) && $bdays[$bdayDay] == '') {
                    $memlink = "<img src='images/$cal_bdayimage' border='0' alt='$lang[texthappybday] $member[username]!' />&nbsp;";
                }
                $memlink .= "<a href='member.php?action=viewpro&amp;member=".rawurlencode($member['username'])."' style='color:$cal_bdaycolor'>$member[username]</a> ($bdayAge)";
                if ($bdays[$bdayDay] == '') {
                    $bdays[$bdayDay] = "<strong>$lang[textbdays]:</strong><br />&nbsp;&nbsp;&nbsp;$memlink";
                } else  {
                    $bdays[$bdayDay] .= "<br />$memlink";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showholidays == 'on') {
            $query = $db->query("SELECT * FROM ".X_PREFIX."holidays WHERE monthday LIKE '$curMonth%'");
            while($holiday = $db->fetch_array($query)) {
                $hday = explode(" ", $holiday['monthday']);
                $holidayDay = trim(str_replace(',', '', $hday[1]));
                $holidaytext = stripslashes($holiday['description']);
                if ($holiday['country']) {
                    $holidaytext .= " ($holiday[country])";
                }

                if ($holidays[$holidayDay] == '') {
                    $holidays[$holidayDay] = "<strong>$lang[calendar_holidays]:</strong><br />&nbsp;&nbsp;&nbsp;<font color='$cal_holidaycolor'>$holidaytext</font>";
                } else {
                    $holidays[$holidayDay] .= "<font color='$cal_holidaycolor'>, $holidaytext</font>";
                }
            }
            $db->free_result($query);
        }

        if ($cal_showevents != 'off') {
            $getevents = '';
            if (X_GUEST) {
                if ($cal_membersonly == 0) {
                    $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday like '$curMonth%$year' AND membersonly='0'");
                    $getevents = 'true';
                }
            } else {
                $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE eventday LIKE '$curMonth%$year'");
                $getevents = 'true';
            }

            if ($getevents != '') {
                while($event = $db->fetch_array($query)) {
                    $ev = explode(' ', $event['eventday']);
                    $e = trim(str_replace(',', '', $ev[1]));
                    if ($events[$e] == "0") {
                        $events[$e] = "<strong>$lang[textevents]:</strong><br />\n";
                        $events[$e] .= "&nbsp;&nbsp;&nbsp;";
                        if ($event['icon'] != '') {
                            $events[$e] .= "<img src='$THEME[smdir]/$event[icon]' border='0' style='vertical-align:middle' alt='' />&nbsp;";
                        }
                        $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                        $events[$e] .= stripslashes($event['subject']);
                        $events[$e] .= "</a><br />";
                    } else {
                        $events[$e] .= "&nbsp;&nbsp;&nbsp;";
                        if ($event['icon'] != '') {
                            $events[$e] .= "<img src='$THEME[smdir]/$event[icon]' border='0' style='vertical-align:middle' alt='' />&nbsp;";
                        }
                        $events[$e] .= "<a href='calendar.php?action=list&amp;month=$month&amp;day=$e&amp;year=$year&amp;eventid=$event[id]' style='color:$cal_eventcolor'>";
                        $events[$e] .= stripslashes($event['subject']);
                        $events[$e] .= "</a><br />";
                    }
                }
                $db->free_result($query);
            }
        }

        $calendar  = "<table cellspacing='0' cellpadding='0' border='0' width='$THEME[tablewidth]' align='center'>\n";
        $calendar .= "<tr><td bgcolor='$THEME[bordercolor]'>\n";
        $calendar .= "<table border='0' cellspacing='$THEME[borderwidth]' cellpadding='$THEME[tablespace]' width='100%' align='center'> \n";
        $calendar .= "<tr><td colspan='2' align='left' class='header'>$monthNames[$month] $year</td></tr>\n";

        $countdays = 0;
        for($i = 1; $i <= $daysInMonth; $i++) {
            if ($bdays[$i] != '' || $holidays[$i] != '' || $events[$i] != '') {
                $calendar .= "<tr><td bgcolor='$THEME[altbg2]' class='tablerow' align='right' valign='top' width='20px'><strong>$i</strong></td>\n";
                $calendar .= "<td bgcolor='$THEME[altbg2]' class='tablerow' valign='top'>\n";

                if ($holidays[$i] != '') {
                    $calendar .= "$holidays[$i]<br />\n";
                }

                if ($bdays[$i] != '') {
                    $calendar .= "$bdays[$i]<br />\n";
                }

                if ($events[$i] != '') {
                    $calendar .= "$events[$i]\n";
                }
                $calendar .= "</td></tr>\n";
                $countdays++;
            }
        }

        if ($countdays == 0) {
            $calendar .= "<tr><td bgcolor='$THEME[altbg1]' class='tablerow' align='left' valign='top' colspan='2'>$lang[textnoevents]</td></tr>\n";
        }

        $calendar .= "</table>\n";
        $calendar .= " </td></tr></table>\n";
    }

    $navbar  = "<br /><form action='calendar.php' method='post'>\n";
    $navbar .= "<table cellspacing='0' cellpadding='0' border='0' width='$THEME[tablewidth]' align='center'>\n";
    $navbar .= "<tr><td bgcolor='$THEME[bordercolor]'>\n";
    $navbar .= "<table border='0' cellspacing='$THEME[borderwidth]' cellpadding='$THEME[tablespace]' width='100%' align='center'>\n";
    $navbar .= "<tr class='category'><td align='center' colspan='3'>\n";
    $navbar .= "<font color='$THEME[cattext]'><strong>$lang[calendar_navigation]</strong></font>\n";
    $navbar .= "</td></tr>\n";
    $navbar .= "<tr class='tablerow'>\n";

    $lastmonth = $lastyear = 0;

    if ($month == 1) {
        $lastmonth = 12;
        $lastyear = $year - 1;
    } else {
        $lastmonth = $month - 1;
        $lastyear = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$THEME[altbg1]' width='$colWidth%' align='center'>&laquo;&nbsp;<a href='calendar.php?month=$lastmonth&amp;year=$lastyear'>$monthNames[$lastmonth] $lastyear</a></td>\n";

    $navbar .= "<td bgcolor='$THEME[altbg2]' align='center'>\n";
    $navbar .= "<select name='month' size='1'>\n";
    for($i = 1; $i <= 12; $i++) {
        $navbar .= "<option value='$i'";
        if ($month == $i) $navbar .= " selected='selected' ";
        $navbar .= ">$monthNames[$i]</option>\n";
    }

    $navbar .= "</select>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<select name='year' size='1'>\n";
    for($i = $year - 2; $i <= $year + 2; $i++) {
        $navbar .= "<option value='$i'";
        if ($year == $i) {
            $navbar .= " selected='selected' ";
        }
        $navbar .= ">$i</option>\n";
    }
    $navbar .= "</select>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<input class='submit' type='submit' name='submit' value='$lang[calendar_display]' />\n";

    if (X_ADMIN) {
        $navbar .= "<br />$lang[textadminoptions]&nbsp;<strong>[<a href='calendar.php?action=settings'>$lang[calendar_settings]</a>]</strong>\n";
    }

    $navbar .= "</td>\n";

    $nextmonth = 0;
    $nextyear = 0;

    if ($month == 12) {
        $nextmonth = 1;
        $nextyear = $year + 1;
    } else {
        $nextmonth = $month + 1;
        $nextyear = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$THEME[altbg1]' width='$colWidth%' align='center'><a href='calendar.php?month=$nextmonth&amp;year=$nextyear'>$monthNames[$nextmonth] $nextyear</a>&nbsp;&raquo;</td>\n";
    $navbar .= "</tr>\n";
    $navbar .= "</table>\n";
    $navbar .= "</td></tr></table>\n";
    $navbar .= "</form>\n";

    echo $calendar;
    echo $navbar;
}

end_time();
eval('echo "'.template('footer').'";');
?>