<?php
/**
 * Title: Portal System
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'cp_portal.php');

require 'header.php';
require ROOT.'include/admin.inc.php';

$tid = (isset($tid) && is_numeric($tid)) ? (int) $tid : 0;

loadtemplates(
'error_nologinsession',
'padmin_admin_blockadd',
'padmin_admin_blockedit',
'padmin_admin_blockselect',
'padmin_admin_editselect',
'padmin_admin_menu',
'padmin_admin_settings'
);

eval('$css = "'.template('css').'";');

nav('<a href="cp.php">'.$lang['textcp'].'</a>');
nav($lang['portalcp']);

eval('echo "'.template('header').'";');

if (!X_ADMIN) {
    eval('echo "'.template('error_nologinsession').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit();
}

smcwcache();

$auditaction = $_SERVER['REQUEST_URI'];
$aapos = strpos($auditaction, "?");
if ($aapos !== false) {
    $auditaction = substr($auditaction, $aapos + 1);
}
$auditaction = addslashes("$onlineip|#|$auditaction");
audit($xmbuser, $auditaction, 0, 0);

$action = postedVar('action', '', FALSE, FALSE, FALSE, 'g');

$blocks = isset($blocks) ? $blocks : '';

eval('echo "'.template('padmin_admin_menu').'";');

if ($action == 'settings') {
    if (noSubmit('settingsubmit')) {
        $SETTINGS['portaltitle'] = stripslashes($SETTINGS['portaltitle']);
        $SETTINGS['portaldgif'] = stripslashes($SETTINGS['portaldgif']);
        $SETTINGS['portalpostsnull'] = stripslashes($SETTINGS['portalpostsnull']);
        $SETTINGS['portalnewsfid'] = (int) $SETTINGS['portalnewsfid'];
        $SETTINGS['portalnewsdisplays'] = (int) $SETTINGS['portalnewsdisplays'];
        $SETTINGS['portalmposts'] = (int) $SETTINGS['portalmposts'];
        $SETTINGS['portalhotdate'] = (int) $SETTINGS['portalhotdate'];
        $SETTINGS['portalhottopics'] = (int) $SETTINGS['portalhottopics'];
        $SETTINGS['portalnewmembers'] = (int) $SETTINGS['portalnewmembers'];
        $SETTINGS['portalrmods'] = (int) $SETTINGS['portalrmods'];
        $SETTINGS['portaltopmembers'] = (int) $SETTINGS['portaltopmembers'];

        $portalavataron = $portalavataroff = '';
        settingHTML('portalavatar', $portalavataron, $portalavataroff);
        $portalstatuson = $portalstatusoff = '';
        settingHTML('portalstatus', $portalstatuson, $portalstatusoff);
        $portalviewon = $portalviewoff = '';
        settingHTML('portalview', $portalviewon, $portalviewoff);
        eval('echo "'.template('padmin_admin_settings').'";');
    }

    if (onSubmit('settingsubmit')) {
        if (empty($portaltitlenew)) {
            error($lang['portalnotitle'], false, '<br />', '', 'cp_portal.php?action=settings');
        }

        if (empty($portaldgifnew)) {
            error($lang['portalnodgif'], false, '<br />', '', 'cp_portal.php?action=settings');
        }

        $portaltitlenew = addslashes(formVar('portaltitlenew'));
        $portaldgifnew = addslashes(formVar('portaldgifnew'));
        $portalpostsnullnew = addslashes(formVar('portalpostsnullnew'));
        $portalnewsfidnew = formInt('portalnewsfidnew');
        $portalnewsdisplaysnew = formInt('portalnewsdisplaysnew');
        $portalmpostsnew = formInt('portalmpostsnew');
        $portalhotdatenew = formInt('portalhotdatenew');
        $portalhottopicsnew = formInt('portalhottopicsnew');
        $portalnewmembersnew = formInt('portalnewmembersnew');
        $portalrmodsnew = formInt('portalrmodsnew');
        $portaltopmembersnew = formInt('portaltopmembersnew');
        $portalavatarnew = formOnOff('portalavatarnew');
        $portalstatusnew = formOnOff('portalstatusnew');
        $portalviewnew = formOnOff('portalviewnew');

        $db->query("UPDATE ".X_PREFIX."settings SET
            portaltitle='$portaltitlenew',
            portalnewsfid='$portalnewsfidnew',
            portalnewsdisplays='$portalnewsdisplaysnew',
            portalmposts='$portalmpostsnew',
            portalhotdate='$portalhotdatenew',
            portalhottopics='$portalhottopicsnew',
            portaldgif='$portaldgifnew',
            portalnewmembers='$portalnewmembersnew',
            portalrmods='$portalrmodsnew',
            portalavatar='$portalavatarnew',
            portaltopmembers='$portaltopmembersnew',
            portalpostsnull='$portalpostsnullnew',
            portalstatus='$portalstatusnew',
            portalview='$portalviewnew'
        ");
        message($lang['portalsettingsupdated'], false, '<br />', '', 'cp_portal.php?action=settings');
    }
}

if ($action == 'blocks') {
    if ($blocks == 'delete') {
        if (noSubmit('blockdeletesubmit')) {
            $listblocks = array();
            $listblocks[] = '<select name="pid">';
            $listblocks[] = '<option value="">'.$lang['portalselectblock'].':</option>';
            $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates ORDER BY name ASC");
            while($t = $db->fetch_array($sql)) {
                $listblocks[] = '<option value="'.intval($t['id']).'">'.stripslashes($t['name']).'</option>';
            }
            $listblocks[] = '</select>';
            $listblocks = implode("\n", $listblocks);
            $db->free_result($sql);

            $listtemplates = array();
            $listtemplates[] = '<select name="tid">';
            $listtemplates[] = '<option value="">'.$lang['portalselectblock'].':</option>';
            $sql = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name LIKE 'portal_%' ORDER BY name ASC");
            while($p = $db->fetch_array($sql)) {
                $listtemplates[] = '<option value="'.intval($p['id']).'">'.stripslashes($p['name']).'</option>';
            }
            $listtemplates[] = '</select>';
            $listtemplates = implode("\n", $listtemplates);
            $db->free_result($sql);
            eval('echo "'.template('padmin_admin_blockselect').'";');
        }

        if (onSubmit('blockdeletesubmit')) {
            $_POST['pid'] = intval($_POST['pid']);
            $db->query("DELETE FROM ".X_PREFIX."portal_templates WHERE id='$_POST[pid]'");
            $db->query("DELETE FROM ".X_PREFIX."templates WHERE id='$tid'");
            message($lang['portalblockdeleted'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=delete');
        }
    }
}

if ($blocks == 'add') {
    if (noSubmit('addsubmit')) {
        eval('echo "'.template('padmin_admin_blockadd').'";');
    }

    if (onSubmit('addsubmit')) {
        if (empty($_POST['newname'])) {
            error($lang['templateempty'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=add');
        }

        $check = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name='$_POST[newname]'");
        if ($check && $db->num_rows($check) != 0) {
            error($lang['templateexists'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=add');
        }

        $check = $db->query("SELECT * FROM ".X_PREFIX."portal_templates WHERE name='$_POST[newname]'");
        if ($check && $db->num_rows($check) != 0) {
            error($lang['templateexists'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=add');
        }

        $_POST['newname'] = addslashes(trim($_POST['newname']));
        $_POST['newtemplate'] = addslashes(trim($_POST['newtemplate']));
        $newdirection = ($newdirection == 'left') ? 'left' : ($newdirection == 'center' ? 'center' : 'right');
        $newstatus = formOnOff('newstatus');
        $newdisplayorder = (isset($newdisplayorder) && is_numeric($newdisplayorder)) ? (int) $newdisplayorder : 0;
        $db->query("INSERT INTO ".X_PREFIX."templates (id, name, template) VALUES ('', '$_POST[newname]', '$_POST[newtemplate]')");
        $db->query("INSERT INTO ".X_PREFIX."portal_templates (id, name, direction, status, displayorder) VALUES ('', '$_POST[newname]', '$newdirection', '$newstatus',  '$newdisplayorder')");
        message($lang['portalbadded'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=add');
    }
}

if ($blocks == 'edit') {
    if (noSubmit('blockeditsubmit')) {
        $selectblocks = array();
        $selectblocks[] = '<select name="tid">';
        $selectblocks[] = '<option value="">'.$lang['portalselectblock'].':</option>';
        $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates ORDER BY name");
        while($t = $db->fetch_array($sql)) {
            $selectblocks[] = '<option value="'.intval($t['id']).'">'.stripslashes($t['name']).'</option>';
        }
        $selectblocks[] = '</select>';
        $selectblocks = implode("\n", $selectblocks);
        $db->free_result($sql);
        eval('echo "'.template('padmin_admin_editselect').'";');
    }

    if (onSubmit('blockeditselect')) {
        if (empty($_POST['tid'])) {
            error($lang['selecttemplate'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=edit');
        }

        $_POST['tid'] = intval($_POST['tid']);
        $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates WHERE id='$_POST[tid]'");
        while($t = $db->fetch_array($sql)) {
            $t['name'] = stripslashes($t['name']);

            $statuson = $statusoff = '';
            switch($t['status']) {
                case 'on':
                    $statuson = $cheHTML;
                    break;
                default:
                    $statusoff = $cheHTML;
                    break;
            }

            $left = $center = $right = '';
            switch($t['direction']) {
                case 'left':
                    $left = $selHTML;
                    break;
                case 'center':
                    $center = $selHTML;
                    break;
                default:
                    $right = $selHTML;
                    break;
            }

            $t['displayorder'] = (int) $t['displayorder'];

            $sql2 = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name='$t[name]'");
            $tm = $db->fetch_array($sql2);
            $db->free_result($sql2);
            $tm['template'] = stripslashes(htmlspecialchars($tm['template']));
            eval('echo "'.template('padmin_admin_blockedit').'";');
        }
        $db->free_result($sql);
    }

    if (onSubmit('blockeditsubmit')) {
        $_POST['newtemplate'] = addslashes(trim($_POST['newtemplate']));
        $_POST['name'] = addslashes(trim($_POST['name']));
        $newdirection = ($newdirection == 'left') ? 'left' : ($newdirection == 'center' ? 'center' : 'right');
        $newstatus = ($newstatus == 'on') ? 'on' : 'off';
        $newdisplayorder = (isset($newdisplayorder) && is_numeric($newdisplayorder)) ? (int) $newdisplayorder : 0;
        $id = (isset($id) && is_numeric($id)) ? (int) $id : 0;
        $db->query("UPDATE ".X_PREFIX."portal_templates SET direction='$newdirection', status='$newstatus', displayorder='$newdisplayorder' WHERE id='$id'");
        $db->query("UPDATE ".X_PREFIX."templates SET template='$_POST[newtemplate]' WHERE name='$_POST[name]'");
        message($lang['portalbedited'], false, '<br />', '', 'cp_portal.php?action=blocks&blocks=edit');
    }
}

end_time();
eval('echo "'.template('footer').'";');
?>