<?php
/**
 * Title: Download Center
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'files_comments.php');

require 'header.php';
require ROOT.'include/files.inc.php';

loadtemplates(
'files_comments_preview',
'files_comments_new',
'files_comments_edit',
'files_copyright',
'files_confirm',
'files_error',
'functions_smilieinsert',
'functions_smilieinsert_smilie',
'functions_bbcode',
'functions_bbcodeinsert',
'files_report_comment'
);

eval('$css = "'.template('css').'";');

smcwcache();

eval('$bbcodescript = "'.template('functions_bbcode').'";');

switch($action) {
    case 'new':
        $navtext = $lang['postcomment'];
        break;
    case 'edit':
        $navtext = $lang['editcomment'];
        break;
    case 'report':
        $navtext = $lang['reportcomment'];
        break;
}

$fid = (isset($fid) ? (int) $fid : 0);

$navigation = files_navigation($fid, $navtext);

eval('echo "'.template('header').'";');

if (file_exists('install.php') && !@unlink('install.php') || file_exists('files.xmb') && !@unlink('files.xmb')) {
    error('You must remove the install files named "install.php" and "files.xmb" before you may proceed to use the files system!', false);
}

if ($SETTINGS['files_status'] == 'off' && (!X_ADMIN)) {
    files_errormsg($lang['featuredisabled']);
}

if ((!X_MEMBER) && $SETTINGS['files_guests'] != 'on') {
    files_errormsg($lang['featureunavailable']);
}

$posticons = files_posticons();
$bbcodeinsert = files_bbcodeinsert();
$smilieinsert = smilieinsert();

$smiliesoffcheck = '';
$bbcodeoffcheck = '';
$usesigcheck = '';
$icon = '';

if (isset($_POST['commentpreview'])) {
    $currtime = $onlinetime;
    $commentdate = gmdate($dateformat, $currtime + ($timeoffset * 3600) + ($addtime * 3600));
    $commenttime = gmdate($timecode, $currtime + ($timeoffset * 3600) + ($addtime * 3600));
    $posted = $lang['postedby'].' <strong>'.$xmbuser.'</strong> '.$lang['on'].' '.$commentdate.' '.$lang['at'].' '.$commenttime;
    $subject = checkOutput(stripslashes($_POST['subject']), 'no', '', true);
    $message = stripslashes($_POST['message']);

    $icon = '';
    $_POST['usesig'] = (isset($_POST['usesig']) ? 'yes' : 'no');
    $_POST['smiliesoff'] = (isset($_POST['smiliesoff']) ? 'yes' : 'no');
    $_POST['bbcodeoff'] = (isset($_POST['bbcodeoff']) ? 'yes' : 'no');

    $message = stripslashes(postify($message, $_POST['smiliesoff'], $_POST['bbcodeoff'], $category['smilies'], $category['html'], $category['bbcode']));

    if ($_POST['usesig'] == 'yes') {
        $usesigcheck = $cheHTML;
        $showsig = postify($sig, $_POST['smiliesoff'], $$SETTINGS['sigbbcode'], $category['smilies'], $SETTINGS['sightml'], $category['bbcode']);
        $message .= '<hr />'.$showsig;
    }

    if ($_POST['smiliesoff'] == 'yes') {
        $smiliesoffcheck = $cheHTML;
    }

    if ($_POST['bbcodeoff'] == 'yes') {
        $bbcodeoffcheck = $cheHTML;
    }

    if (!empty($_POST['posticon'])) {
        $icon = '<img src="'.$THEME['smdir'].'/'.$_POST['posticon'].'" border="0" align="middle" border="0" /> ';
    }

    if (!X_MEMBER) {
        $author = '<strong>'.$lang['anonymous'].'</strong>';
    } else {
        $author = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($xmbuser).'"><strong>'.$xmbuser.'</strong></a>';
    }
    eval('echo "'.template('files_comments_preview').'";');
}

switch($action) {
    case 'new':
        $whocomment = files_permissions($category['whocomment'], stripslashes($category['commentlist']));

        if (empty($whocomment)) {
            files_errormsg($lang['cannotpostcomments']);
        }

        $whocomment = '';

        if (!isset($_POST['commentsubmit'])) {
            if ($fid == 0 || $fid != $file['id']) {
                files_errormsg($lang['nofileselected']);
            }

            $_POST['subject'] = (isset($_POST['subject']) ? $_POST['subject'] : '');
            $_POST['subject'] = checkOutput(stripslashes($_POST['subject']), 'no', '', true);
            $_POST['message'] = (isset($_POST['message']) ? $_POST['message'] : '');
            $_POST['message'] = stripslashes($_POST['message']);

            $smiliesoffcheck = '';
            $bbcodeoffcheck = '';
            $sigoption = '';

            if (X_MEMBER && !empty($sig)) {
                if (empty($_POST['commentpreview'])) {
                    $usesigcheck = $cheHTML;
                }
                $sigoption = '<br /><input type="checkbox" name="usesig" value="yes" '.$usesigcheck.' /> '.$lang['usesignature'];
            }
            eval('echo "'.template('files_comments_new').'";');
        }

        if (isset($_POST['commentsubmit'])) {
            if (empty($_POST['subject'])) {
                files_errormsg($lang['nocommentsubject']);
            }

            if (empty($_POST['message'])) {
                files_errormsg($lang['nocommentmessage']);
            }

            $_POST['subject'] = addslashes($_POST['subject']);
            $_POST['message'] = addslashes($_POST['message']);

            $_POST['usesig'] = (isset($_POST['usesig']) ? 'yes' : 'no');
            $_POST['smiliesoff'] = (isset($_POST['smiliesoff']) ? 'yes' : 'no');
            $_POST['bbcodeoff'] = (isset($_POST['bbcodeoff']) ? 'yes' : 'no');

            $submittime = $onlinetime;

            $db->query("INSERT INTO ".X_PREFIX."files_comments (fid, author, dateposted, dateupdated, subject, message, icon, usesig, bbcodeoff, smiliesoff) VALUES ('$fid', '$onlineuser', '$submittime', '$submittime', '$_POST[subject]', '$_POST[message]', '$_POST[posticon]', '$_POST[usesig]', '$_POST[bbcodeoff]', '$_POST[smiliesoff]')");

            files_confirmmsg($lang['commentadded'], 'files.php?action=file&id='.$fid);
        }
        break;

    case 'edit':
        $cid = (isset($cid) ? (int) $cid : 0);
        if (!isset($_POST['commentsubmit'])) {
            $query = $db->query("SELECT * FROM ".X_PREFIX."files_comments where cid='$cid'");
            $comment = $db->fetch_array($query);
            $db->free_result($query);

            if (empty($cid) || $cid != (int)$comment['cid']) {
                files_errormsg($lang['nocommentselected']);
            }

            $comment['subject'] = checkOutput(stripslashes($comment['subject']), 'no', '', true);
            $comment['message'] = stripslashes($comment['message']);

            if ($comment['icon'] != '') {
                $posticons = str_replace($comment['icon']."\"", $comment['icon']."\" checked=\"checked\"", $posticons);
            }

            $sigoption = '';

            if (X_MEMBER && !empty($sig)) {
                if (empty($_POST['commentpreview'])) {
                    $usesigcheck = $cheHTML;
                }
                $sigoption = '<br /><input type="checkbox" name="usesig" value="yes" '.$usesigcheck.' /> '.$lang['usesignature'];
            }

            if ($comment['bbcodeoff'] == 'yes') {
                $bbcodeoffcheck = $cheHTML;
            }

            if ($comment['smiliesoff'] == 'yes') {
                $smiliesoffcheck = $cheHTML;
            }
            eval('echo "'.template('files_comments_edit').'";');
        }

        if (isset($_POST['commentsubmit'])) {
            if (empty($_POST['subject'])) {
                files_errormsg($lang['nocommentsubject']);
            }

            if (empty($_POST['message'])) {
                files_errormsg($lang['nocommentmessage']);
            }

            $_POST['subject'] = addslashes($_POST['subject']);
            $_POST['message'] = addslashes($_POST['message']);
            $_POST['usesig'] = (isset($_POST['usesig']) ? 'yes' : 'no');
            $_POST['smiliesoff'] = (isset($_POST['smiliesoff']) ? 'yes' : 'no');
            $_POST['bbcodeoff'] = (isset($_POST['bbcodeoff']) ? 'yes' : 'no');

            $submittime = $onlinetime;

            $_POST['delete'] = (isset($_POST['delete']) ? 'yes' : 'no');
            if ($_POST['delete'] == 'yes') {
                $db->query("DELETE FROM ".X_PREFIX."files_comments WHERE cid='$cid'");
            } else {
                $db->query("UPDATE ".X_PREFIX."files_comments SET subject='$_POST[subject]', message='$_POST[message]', dateupdated='$submittime', updatedby='$self[username]', icon='$_POST[posticon]', usesig='$_POST[usesig]', bbcodeoff='$_POST[bbcodeoff]', smiliesoff='$_POST[smiliesoff]' WHERE cid='$cid'");
            }
            files_confirmmsg($lang['commentupdated'], 'files.php?action=file&id='.$fid);
        }
        break;

    case 'report':
        if ($SETTINGS['files_comment_report'] != 'on') {
            files_errormsg($lang['featuredisabled']);
        }

        if ($fid == 0 || $fid != (int)$file['id']) {
            files_errormsg($lang['selectreportfile']);
        }

        $cid = (isset($cid) ? (int) $cid : 0);
        if ($cid == 0) {
            files_errormsg($lang['selectreportcomment']);
        }

        $whoview = files_permissions($category['whoview'], stripslashes($category['viewlist']));

        if (empty($whoview)) {
            files_errormsg($lang['cannotviewfile']);
        }

        $whoview = '';

        if (!isset($_POST['reportsubmit'])) {
            eval('echo "'.template('files_report_comment').'";');
        }

        if (isset($_POST['reportsubmit'])) {
            if (empty($_POST['reason'])) {
                files_errormsg($lang['noreportreason']);
            }

            $url = $SETTINGS['boardurl'];
            $url .= 'files.php?action=file&id='.$fid.'#cid'.$cid;

            $message = "$lang[reportcommentmessage]\n\n$url\n\n[b]$lang[reason]:[/b] $reason";

            $query = $db->query("SELECT username FROM ".X_PREFIX."members WHERE status = 'Super Administrator' OR status = 'Administrator'");
            while($member = $db->fetch_array($query)) {
                if ($member['username'] != '') {
                    $db->query("INSERT INTO ".X_PREFIX."u2u (u2uid, msgto, msgfrom, type, owner, folder, subject, message, dateline, readstatus, sentstatus) VALUES ('', '$member[username]', '$xmbuser', 'incoming', '$member[username]', 'Inbox', '*** $lang[reportcommentsubject] ***', '$message', '".time()."', 'no', 'yes')");
                }
            }
            $db->free_result($query);

            files_confirmmsg($lang['filereported'], 'files.php?action=file&id='.$fid);
        }
        break;
}

$jumpbox = files_jumpbox();

eval('echo "'.template('files_copyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>