<?php
/**
 * Title: Download Center
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'files_admin.php');

require 'header.php';
require ROOT.'include/files.inc.php';

loadtemplates(
'error_nologinsession',
'files_admin_menu',
'files_admin_categories_add',
'files_admin_categories_select',
'files_admin_categories_edit',
'files_admin_licenses_add',
'files_admin_licenses_select',
'files_admin_licenses_edit',
'files_admin_custom_add',
'files_admin_custom_select',
'files_admin_custom_edit',
'files_admin_files_custom',
'files_admin_files_add',
'files_admin_files_select',
'files_admin_files_custom',
'files_admin_files_edit',
'files_admin_files_approve_files',
'files_admin_files_approve',
'files_admin_settings',
'files_copyright',
'files_confirm',
'files_error'
);

eval('$css = "'.template('css').'";');

nav('<a href="cp.php">'.$lang['textcp'].'</a>');
nav($lang['downloadcenter']);

eval('echo "'.template('header').'";');

if (file_exists('install.php') && !@unlink('install.php') || file_exists('files.xmb') && !@unlink('files.xmb')) {
    error('You must remove the install files named "install.php" and "files.xmb" before you may proceed to use the files system!', false);
}

if (!X_ADMIN) {
    eval('echo "'.template('error_nologinsession').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

smcwcache();

$auditaction = $_SERVER['REQUEST_URI'];
$aapos = strpos($auditaction, "?");
if ($aapos !== false) {
    $auditaction = substr($auditaction, $aapos + 1);
}
$auditaction = addslashes("$onlineip|#|$auditaction");
audit($xmbuser, $auditaction, 0, 0);

$approvequery = $db->query("SELECT COUNT(id) FROM ".X_PREFIX."files WHERE status='pending'");
$approvetotal = $db->result($approvequery, 0);
$db->free_result($approvequery);
$totalpending = '(0)';
if ($approvetotal != 0) {
    $totalpending = "($approvetotal)";
}

eval('echo "'.template('files_admin_menu').'";');

switch($action) {
    case 'category':
        switch($category) {
            case 'add':
                if (!isset($_POST['categorysubmit'])) {
                    $listcats = array();
                    $listcats[] = '<select name="catid">';
                    $listcats[] = '<option value="" '.$selHTML.'>'.$lang['none'].'</option>';
                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE parent='0' ORDER BY name");
                    while($cat = $db->fetch_array($query)) {
                        $cat['name'] = stripslashes($cat['name']);
                        if ($cat['name'] != '') {
                            $listcats[] = '<option value="'.intval($cat['id']).'">'.$cat['name'].'</option>';
                        }
                    }
                    $listcats[] = '</select>';
                    $listcats = implode("\n", $listcats);
                    $db->free_result($query);
                    $viewlist = $downloadlist = $emaillist = $submitlist = $uploadlist = $ratelist = $commentlist = '';
                    eval('echo "'.template('files_admin_categories_add').'";');
                }

                if (isset($_POST['categorysubmit'])) {
                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nocategoryname']);
                    }

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE name='$_POST[name]'");
                    $check = $db->fetch_array($query);
                    $db->free_result($query);

                    if (!empty($check)) {
                        files_errormsg($lang['categoryexists']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['description'] = addslashes($_POST['description']);
                    $_POST['viewlist'] = addslashes($_POST['viewlist']);
                    $_POST['downloadlist'] = addslashes($_POST['downloadlist']);
                    $_POST['emaillist'] = addslashes($_POST['emaillist']);
                    $_POST['submitlist'] = addslashes($_POST['submitlist']);
                    $_POST['uploadlist'] = addslashes($_POST['uploadlist']);
                    $_POST['ratelist'] = addslashes($_POST['ratelist']);
                    $_POST['commentlist'] = addslashes($_POST['commentlist']);

                    $db->query("INSERT INTO ".X_PREFIX."files_categories (name, description, icon, parent, status, html, bbcode, smilies, whoview, whorate, whocomment, whodownload, whosubmit, whoupload, whoemail, submitlist, downloadlist, emaillist, viewlist, uploadlist, ratelist, commentlist) VALUES ('$_POST[name]', '$_POST[description]', '$_POST[icon]', '$_POST[catid]', '$_POST[status]', '$_POST[html]', '$_POST[bbcode]', '$_POST[smilies]', '$_POST[whoview]', '$_POST[whorate]', '$_POST[whocomment]', '$_POST[whodownload]', '$_POST[whosubmit]', '$_POST[whoupload]', '$_POST[whoemail]', '$_POST[submitlist]', '$_POST[downloadlist]', '$_POST[emaillist]', '$_POST[viewlist]', '$_POST[uploadlist]', '$_POST[ratelist]', '$_POST[commentlist]')");
                    $cid = $db->insert_id();

                    $db->query("UPDATE ".X_PREFIX."files_categories SET displayorder='$cid' WHERE id='$cid'");

                    files_confirmmsg($lang['categoryadded'], 'files_admin.php?action=category&category=add');
                }
                break;

            case 'edit':
                $_POST['catid'] = (isset($_POST['catid']) ? (int) $_POST['catid'] : 0);
                if (!isset($_POST['deletesubmit']) && !isset($_POST['editsubmit']) && !isset($_POST['categorysubmit'])) {
                    $lettersort = files_letters('files_admin.php?action=category&category=edit');
                    $listcats = array();
                    $listcats[] = '<select name="catid">';
                    $listcats[] = '<option value="">'.$lang['selectcategory'].':</option>';
                    $listcats[] = '<option value="">--------------------</option>';
                    $addquery = ((!empty($edit) && $edit != 'all') ? "AND name LIKE '$edit%'" : "");
                    $catquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE parent = '0' $addquery ORDER BY name");
                    while($cat = $db->fetch_array($catquery)) {
                        $cat['name'] = stripslashes($cat['name']);
                        $listcats[] = '<option value="'.intval($cat['id']).'">'.$cat['name'].'</option>';
                        $subquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE parent = '$cat[id]' $addquery ORDER BY name");
                        while($sub = $db->fetch_array($subquery)) {
                            $sub['name'] = stripslashes($sub['name']);
                            if ($sub['name'] != '') {
                                $listcats[] = '<option value="'.intval($sub['id']).'">&nbsp;&nbsp;&nbsp;'.$sub['name'].'</option>';
                            }
                        }
                        $db->free_result($subquery);
                    }
                    $listcats[] = '</select>';
                    $listcats = implode("\n", $listcats);
                    $db->free_result($catquery);
                    eval('echo "'.template('files_admin_categories_select').'";');
                }

                if (isset($_POST['deletesubmit'])) {
                    if (empty($_POST['catid']) || $_POST['catid'] == 0) {
                        files_errormsg($lang['selectdeletecategory']);
                    }

                    $db->query("DELETE FROM ".X_PREFIX."files_categories WHERE id='$_POST[catid]'");

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE catid='$_POST[catid]'");
                    $file = $db->fetch_array($query);
                    $db->free_result($query);

                    $db->query("DELETE FROM ".X_PREFIX."files WHERE catid='$_POST[catid]'");
                    $db->query("DELETE FROM ".X_PREFIX."files_votes WHERE file='$file[id]'");
                    $db->query("DELETE FROM ".X_PREFIX."files_custom_data WHERE file='$file[id]'");

                    files_confirmmsg($lang['categorydeleted'], 'files_admin.php?action=category&category=edit');
                }

                if (isset($_POST['editsubmit'])) {
                    if (empty($_POST['catid']) || $_POST['catid'] == 0) {
                        files_errormsg($lang['selecteditcategory']);
                    }

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE id = '$_POST[catid]'");
                    $cat = $db->fetch_array($query);
                    $db->free_result($query);

                    $cat['name'] = stripslashes($cat['name']);
                    $cat['description'] = stripslashes($cat['description']);
                    $cat['viewlist'] = stripslashes($cat['viewlist']);
                    $cat['submitlist'] = stripslashes($cat['submitlist']);
                    $cat['uploadlist'] = stripslashes($cat['uploadlist']);
                    $cat['downloadlist'] = stripslashes($cat['downloadlist']);
                    $cat['emaillist'] = stripslashes($cat['emaillist']);
                    $cat['ratelist'] = stripslashes($cat['ratelist']);
                    $cat['commentlist'] = stripslashes($cat['commentlist']);

                    $status_on = $status_off = '';
                    switch($cat['status']) {
                        case 'on':
                            $status_on = $cheHTML;
                            break;
                        default:
                            $status_off = $cheHTML;
                            break;
                    }

                    $listcats = array();
                    $listcats[] = '<select name="catid">';
                    if ($cat['parent'] == 0) {
                        $listcats[] = '<option value="" '.$selHTML.'>'.$lang['none'].'</option>';
                    }
                    $catquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE parent='0' ORDER BY name");
                    while($cats = $db->fetch_array($catquery)) {
                        $cats['name'] = stripslashes($cats['name']);
                        if ($cat['id'] == $cats['parent']) {
                            if ($cats['name'] != '') {
                                $listcats[] = '<option value="'.intval($cats['id']).'" '.$selHTML.'>'.$cats['name'].'</option>';
                            }
                        } else {
                            if ($cat['id'] != $cats['id']) {
                                $listcats[] = '<option value="'.intval($cats['id']).'">'.$cats['name'].'</option>';
                            }
                        }
                    }
                    $listcats[] = '</select>';
                    $listcats = implode("\n", $listcats);
                    $db->free_result($catquery);

                    $html_on = $html_off = '';
                    switch($cat['html']) {
                        case 'on':
                            $html_on = $cheHTML;
                            break;
                        default:
                            $html_off = $cheHTML;
                            break;
                    }

                    $bbcode_on = $bbcode_off = '';
                    switch($cat['bbcode']) {
                        case 'on':
                            $bbcode_on = $cheHTML;
                            break;
                        default:
                            $bbcode_off = $cheHTML;
                            break;
                    }

                    $smilies_on = $smilies_off = '';
                    switch($cat['smilies']) {
                        case 'on':
                            $smilies_on = $cheHTML;
                            break;
                        default:
                            $smilies_off = $cheHTML;
                            break;
                    }

                    $view_guests = $view_all = $view_staff = '';
                    $view_adminsmods = $view_admins = $view_none = '';
                    switch($cat['whoview']) {
                        case 'guests':
                            $view_guests = $selHTML;
                            break;
                        case 'all':
                            $view_all = $selHTML;
                            break;
                        case 'staff':
                            $view_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $view_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $view_admins = $selHTML;
                            break;
                        default:
                            $view_none = $selHTML;
                            break;
                    }

                    $rate_guests = $rate_all = $rate_staff = '';
                    $rate_adminsmods = $rate_admins = $rate_none = '';
                    switch($cat['whorate']) {
                        case 'guests':
                            $rate_guests = $selHTML;
                            break;
                        case 'all':
                            $rate_all = $selHTML;
                            break;
                        case 'staff':
                            $rate_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $rate_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $rate_admins = $selHTML;
                            break;
                        default:
                            $rate_none = $selHTML;
                            break;
                    }

                    $email_guests = $email_all = $email_staff = '';
                    $email_adminsmods = $email_admins = $email_none = '';
                    switch($cat['whoemail']) {
                        case 'guests':
                            $email_guests = $selHTML;
                            break;
                        case 'all':
                            $email_all = $selHTML;
                            break;
                        case 'staff':
                            $email_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $email_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $email_admins = $selHTML;
                            break;
                        default:
                            $email_none = $selHTML;
                            break;
                    }

                    $download_guests = $download_all = '';
                    $download_staff = $download_adminsmods = '';
                    $download_admins = $download_none = '';
                    switch($cat['whodownload']) {
                        case 'guests':
                            $download_guests = $selHTML;
                            break;
                        case 'all':
                            $download_all = $selHTML;
                            break;
                        case 'staff':
                            $download_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $download_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $download_admins = $selHTML;
                            break;
                        default:
                            $download_none = $selHTML;
                            break;
                    }

                    $submit_guests = $submit_all = $submit_staff = '';
                    $submit_adminsmods = $submit_admins = $submit_none = '';
                    switch($cat['whosubmit']) {
                        case 'guests':
                            $submit_guests = $selHTML;
                            break;
                        case 'all':
                            $submit_all = $selHTML;
                            break;
                        case 'staff':
                            $submit_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $submit_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $submit_admins = $selHTML;
                            break;
                        default:
                            $submit_none = $selHTML;
                            break;
                    }

                    $upload_guests = $upload_all = $upload_staff = '';
                    $upload_adminsmods = $upload_admins = $upload_none = '';
                    switch($cat['whoupload']) {
                        case 'guests':
                            $upload_guests = $selHTML;
                            break;
                        case 'all':
                            $upload_all = $selHTML;
                            break;
                        case 'staff':
                            $upload_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $upload_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $upload_admins = $selHTML;
                            break;
                        default:
                            $upload_none = $selHTML;
                            break;
                    }

                    $comment_guests = $comment_all = $comment_staff = '';
                    $comment_adminsmods = $comment_admins = $comment_none = '';
                    switch($cat['whocomment']) {
                        case 'guests':
                            $comment_guests = $selHTML;
                            break;
                        case 'all':
                            $comment_all = $selHTML;
                            break;
                        case 'staff':
                            $comment_staff = $selHTML;
                            break;
                        case 'adminsmods':
                            $comment_adminsmods = $selHTML;
                            break;
                        case 'admins':
                            $comment_admins = $selHTML;
                            break;
                        default:
                            $comment_none = $selHTML;
                            break;
                    }
                    eval('echo "'.template('files_admin_categories_edit').'";');
                }

                if (isset($_POST['categorysubmit'])) {
                    $cid = (isset($cid) ? (int) $cid : 0);

                    if (empty($cid) || $cid == 0) {
                        files_errormsg($lang['selecteditcategory']);
                    }

                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nocategoryname']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['description'] = addslashes($_POST['description']);
                    $_POST['viewlist'] = addslashes($_POST['viewlist']);
                    $_POST['submitlist'] = addslashes($_POST['submitlist']);
                    $_POST['uploadlist'] = addslashes($_POST['uploadlist']);
                    $_POST['downloadlist'] = addslashes($_POST['downloadlist']);
                    $_POST['emaillist'] = addslashes($_POST['emaillist']);
                    $_POST['ratelist'] = addslashes($_POST['ratelist']);
                    $_POST['commentlist'] = addslashes($_POST['commentlist']);

                    $db->query("UPDATE ".X_PREFIX."files_categories SET
                        name='$_POST[name]',
                        description='$_POST[description]',
                        icon='$_POST[icon]',
                        parent='$_POST[catid]',
                        displayorder='$_POST[order]',
                        status='$_POST[status]',
                        html='$_POST[html]',
                        bbcode='$_POST[bbcode]',
                        smilies='$_POST[smilies]',
                        whoview='$_POST[whoview]',
                        whorate='$_POST[whorate]',
                        whocomment='$_POST[whocomment]',
                        whodownload='$_POST[whodownload]',
                        whosubmit='$_POST[whosubmit]',
                        whoupload='$_POST[whoupload]',
                        whoemail='$_POST[whoemail]',
                        viewlist='$_POST[viewlist]',
                        submitlist='$_POST[submitlist]',
                        uploadlist='$_POST[uploadlist]',
                        downloadlist='$_POST[downloadlist]',
                        emaillist='$_POST[emaillist]',
                        ratelist='$_POST[ratelist]',
                        commentlist='$_POST[commentlist]'
                        WHERE id='$cid'
                    ");

                    files_confirmmsg($lang['categoryupdated'], 'files_admin.php?action=category&category=edit');
                }
                break;
        }
        break;

    case 'license':
        switch($license) {
            case 'add':
                if (!isset($_POST['licensesubmit'])) {
                    eval('echo "'.template('files_admin_licenses_add').'";');
                }

                if (isset($_POST['licensesubmit'])) {
                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nolicensename']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['text'] = addslashes($_POST['text']);

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_licenses WHERE name='$_POST[name]'");
                    $check = $db->fetch_array($query);
                    $db->free_result($query);

                    if (!empty($check)) {
                        files_errormsg($lang['licenseexists']);
                    }

                    if (empty($_POST['text'])) {
                        files_errormsg($lang['nolicensetext']);
                    }

                    $db->query("INSERT INTO ".X_PREFIX."files_licenses (name, text) VALUES ('$_POST[name]', '$_POST[text]')");

                    files_confirmmsg($lang['licenseadded'], 'files_admin.php?action=license&license=add');
                }
                break;

            case 'edit':
                $_POST['licenseid'] = (isset($_POST['licenseid']) ? (int) $_POST['licenseid'] : 0);
                if (!isset($_POST['deletesubmit']) && !isset($_POST['editsubmit']) && !isset($_POST['licensesubmit'])) {
                    $lettersort = files_letters('files_admin.php?action=license&license=edit');
                    $listlicenses = array();
                    $listlicenses[] = '<select name="licenseid">';
                    $listlicenses[] = '<option value="">'.$lang['selectlicense'].':</option>';
                    $listlicenses[] = '<option value="">--------------------</option>';
                    $addquery = ((!empty($edit) && $edit != 'all') ? "WHERE name LIKE '$edit%'" : "");
                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_licenses $addquery ORDER BY name");
                    while($license = $db->fetch_array($query)) {
                        $license['name'] = stripslashes($license['name']);
                        if ($license['name'] != '') {
                            $listlicenses[] = '<option value="'.intval($license['id']).'">'.$license['name'].'</option>';
                        }
                    }
                    $listlicenses[] = '</select>';
                    $listlicenses = implode("\n", $listlicenses);
                    $db->free_result($query);
                    eval('echo "'.template('files_admin_licenses_select').'";');
                }

                if (isset($_POST['deletesubmit'])) {
                    if (empty($_POST['licenseid']) || $_POST['licenseid'] == 0) {
                        files_errormsg($lang['selectdeletelicense']);
                    }

                    $db->query("DELETE FROM ".X_PREFIX."files_licenses WHERE id='$_POST[licenseid]'");
                    files_confirmmsg($lang['licensedeleted'], 'files_admin.php?action=license&license=edit');
                }

                if (isset($_POST['editsubmit'])) {
                    if (empty($_POST['licenseid']) || $_POST['licenseid'] == 0) {
                        files_errormsg($lang['selecteditlicense']);
                    }

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_licenses WHERE id = '$_POST[licenseid]'");
                    $license = $db->fetch_array($query);
                    $db->free_result($query);

                    $license['name'] = stripslashes($license['name']);
                    $license['text'] = stripslashes($license['text']);
                    eval('echo "'.template('files_admin_licenses_edit').'";');
                }

                if (isset($_POST['licensesubmit'])) {
                    $licenseid = (isset($licenseid) ? (int) $licenseid : 0);

                    if (empty($licenseid) || $licenseid == 0) {
                        files_errormsg($lang['selecteditlicense']);
                    }

                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nolicensename']);
                    }

                    if (empty($_POST['text'])) {
                        files_errormsg($lang['nolicensetext']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['text'] = addslashes($_POST['text']);

                    $db->query("UPDATE ".X_PREFIX."files_licenses SET name='$_POST[name]', text='$_POST[text]' WHERE id='$licenseid'");

                    files_confirmmsg($lang['licenseupdated'], 'files_admin.php?action=license&license=edit');
                }
                break;
        }
        break;

    case 'custom':
        switch($custom) {
            case 'add':
                if (!isset($_POST['customsubmit'])) {
                    eval('echo "'.template('files_admin_custom_add').'";');
                }

                if (isset($_POST['customsubmit'])) {
                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nocustomname']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['description'] = addslashes($_POST['description']);

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_custom WHERE name = '$_POST[name]'");
                    $check = $db->fetch_array($query);
                    $db->free_result($query);

                    if (!empty($check)) {
                        files_errormsg($lang['customexists']);
                    }

                    $db->query("INSERT INTO ".X_PREFIX."files_custom (name, description) VALUES ('$_POST[name]', '$_POST[description]')");

                    files_confirmmsg($lang['customadded'], 'files_admin.php?action=custom&custom=add');
                }
                break;

            case 'edit':
                $_POST['customid'] = (isset($_POST['customid']) ? (int) $_POST['customid'] : 0);
                if (!isset($_POST['deletesubmit']) && !isset($_POST['editsubmit']) && !isset($_POST['customsubmit'])) {
                    $lettersort = files_letters('files_admin.php?action=custom&custom=edit');
                    $listfields = array();
                    $listfields[] = '<select name="customid">';
                    $listfields[] = '<option value="">'.$lang['selectcustom'].':</option>';
                    $listfields[] = '<option value="">--------------------</option>';
                    $addquery = ((!empty($edit) && $edit != 'all') ? "WHERE name LIKE '$edit%'" : "");
                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_custom $addquery ORDER BY name");
                    while($custom = $db->fetch_array($query)) {
                        $custom['name'] = stripslashes($custom['name']);
                        if ($custom['name'] != '') {
                            $listfields[] = '<option value="'.intval($custom['id']).'">'.$custom['name'].'</option>';
                        }
                    }
                    $listfields[] = '</select>';
                    $listfields = implode("\n", $listfields);
                    $db->free_result($query);
                    eval('echo "'.template('files_admin_custom_select').'";');
                }

                if (isset($_POST['deletesubmit'])) {
                    if (empty($_POST['customid']) || $_POST['customid'] == 0) {
                        files_errormsg($lang['selectdeletecustom']);
                    }

                    $db->query("DELETE FROM ".X_PREFIX."files_custom WHERE id='$_POST[customid]'");

                    files_confirmmsg($lang['customdeleted'], 'files_admin.php?action=custom&custom=edit');
                }

                if (isset($_POST['editsubmit'])) {
                    if (empty($_POST['customid']) || $_POST['customid'] == 0) {
                        files_errormsg($lang['selecteditcustom']);
                    }

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files_custom WHERE id='$_POST[customid]'");
                    $custom = $db->fetch_array($query);
                    $db->free_result($query);

                    $custom['name'] = stripslashes($custom['name']);
                    $custom['description'] = stripslashes($custom['description']);
                    eval('echo "'.template('files_admin_custom_edit').'";');
                }

                if (isset($_POST['customsubmit'])) {
                    $customid = (isset($customid) ? (int) $customid : 0);

                    if (empty($customid) || $customid == 0) {
                        files_errormsg($lang['selecteditcustom']);
                    }

                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nocustomname']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);
                    $_POST['description'] = addslashes($_POST['description']);

                    $db->query("UPDATE ".X_PREFIX."files_custom SET name='$_POST[name]', description='$_POST[description]' WHERE id='$customid'");

                    files_confirmmsg($lang['customupdated'], 'files_admin.php?action=custom&custom=edit');
                }
                break;
        }
        break;

    case 'file':
        switch($file) {
            case 'add':
                if (!isset($_POST['filesubmit'])) {
                    $dlurl = '';
                    $downloadlist = '';
                    $customfields = '';
                    $filesize = '';
                    $filetype = '';
                    $customdata['data'] = '';
                    $icons = files_posticons();
                    $listcats = array();
                    $listcats[] = '<select name="category">';
                    $catquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='0' ORDER BY name");
                    $cattotal = $db->num_rows($catquery);
                    if ($cattotal == 0) {
                        files_errormsg($lang['addcategoryfirst']);
                    }
                    while($cat = $db->fetch_array($catquery)) {
                        $cat['name'] = stripslashes($cat['name']);
                        $listcats[] = '<option value="'.intval($cat['id']).'">'.$cat['name'].'</option>';
                        $subquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='$cat[id]' ORDER BY name");
                        while($sub = $db->fetch_array($subquery)) {
                            $sub['name'] = stripslashes($sub['name']);
                            if ($sub['name'] != '') {
                                $listcats[] = '<option value="'.intval($sub['id']).'">&nbsp;&nbsp;&nbsp;'.$sub['name'].'</option>';
                            }
                        }
                    }
                    $listcats[] = '</select>';
                    $listcats = implode("\n", $listcats);
                    $db->free_result($catquery);

                    $listlicenses = array();
                    $listlicenses[] = '<select name="license">';
                    $listlicenses[] = '<option value="0">'.$lang['none'].'</option>';
                    $licquery = $db->query("SELECT * FROM ".X_PREFIX."files_licenses ORDER BY name");
                    while($license = $db->fetch_array($licquery)) {
                        $license['name'] = stripslashes($license['name']);
                        if ($license['name'] != '') {
                            $listlicenses[] = '<option value="'.intval($license['id']).'">'.$license['name'].'</option>';
                        }
                    }
                    $listlicenses[] = '</select>';
                    $listlicenses = implode("\n", $listlicenses);
                    $db->free_result($licquery);

                    $icons = str_replace('<input type="radio" name="posticon" value="" />', '<input type="radio" name="posticon" value="" '.$cheHTML.' />', $icons);

                    $customquery = $db->query("SELECT * FROM ".X_PREFIX."files_custom ORDER BY name");
                    while($custom = $db->fetch_array($customquery)) {
                        $custom['name'] = stripslashes($custom['name']);
                        $custom['description'] = stripslashes($custom['description']);
                        eval('$customfields .= "'.template('files_admin_files_custom').'";');
                    }
                    $db->free_result($customquery);
                    eval('echo "'.template('files_admin_files_add').'";');
                }

                if (isset($_POST['filesubmit'])) {
                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nofilename']);
                    }

                    $_POST['name'] = addslashes($_POST['name']);

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE name='$_POST[name]'");
                    $check = $db->fetch_array($query);
                    $db->free_result($query);

                    if (!empty($check)) {
                        files_errormsg($lang['fileexists']);
                    }

                    if (isset($_POST['dlurl']) && $_POST['dlurl'] != '') {
                        if ($_POST['filesize'] == '' && $_POST['filetype'] == '') {
                            $fileurl = str_replace(' ', '%20', $_POST['dlurl']);
                            if ('./' == substr($fileurl, 0, 2)) {
                                $fileurl = str_replace('./', $SETTINGS['boardurl'], $fileurl);
                            }
                            $ourhead = '';
                            $url = parse_url($fileurl);
                            $host = $url['host'];
                            $path = $url['path'];
                            $fp = @fsockopen($host, 80, $errno, $errstr, 20);
                            if ($fp) {
                                fputs($fp, "HEAD $fileurl HTTP/1.1\r\n");
                                fputs($fp, "HOST: dummy\r\n");
                                fputs($fp, "Connection: close\r\n\r\n");
                                while(!feof($fp)) {
                                    $ourhead = sprintf("%s%s", $ourhead, fgets($fp,128));
                                }
                                $size = explode("Content-Length: ", $ourhead);
                                $_POST['filesize'] = isset($size[1]) ? (int) $size[1] : '';
                                $extension_head = explode("Content-Type: ", $ourhead);
                                $extension = $extension_head[1];
                                if (strpos($extension,';')) {
                                    $extension = substr($extension, 0, strpos($extension,';'));
                                }
                                $_POST['filetype'] = $extension;
                            }
                        }
                        @fclose($fp);
                    }

                    $_POST['filesize']      = addslashes($_POST['filesize']);
                    $_POST['filetype']      = addslashes($_POST['filetype']);
                    $_POST['name']          = checkInput($_POST['name'],                  'no', 'no', '', false);
                    $_POST['shortdesc']     = checkInput(addslashes($_POST['shortdesc']), 'no', 'no', '', false);
                    $_POST['longdesc']      = checkInput(addslashes($_POST['longdesc']),  'no', 'no', '', false);
                    $_POST['creator']       = checkInput(addslashes($_POST['creator']),   'no', 'no', '', false);
                    $_POST['version']       = checkInput(addslashes($_POST['version']),   'no', 'no', '', false);
                    $_POST['screenshot']    = files_url_chk($_POST['screenshot']);
                    $_POST['documentation'] = files_url_chk($_POST['documentation']);
                    $_POST['mirror']        = files_url_chk($_POST['mirror']);
                    $_POST['dlurl']         = addslashes($_POST['dlurl']);
                    $_POST['posticon']      = addslashes($_POST['posticon']);
                    $_POST['category']      = (int)$_POST['category'];
                    $_POST['license']       = (int)$_POST['license'];
                    $_POST['pin']           = ($_POST['pin'] == 'yes' ? 'yes' : 'no');
                    $_POST['downloadlist']  = addslashes($_POST['downloadlist']);
                    $_POST['fee']           = floatval($_POST['fee']);

                    $time = $onlinetime;

                    $db->query("INSERT INTO ".X_PREFIX."files (name, description, creator, version, longdesc, ssurl, dlurl, mirror, time, catid, posticon, license, pin, docsurl, status, filesize, filetype, fee, downloadlist) VALUES ('$_POST[name]', '$_POST[shortdesc]', '$_POST[creator]', '$_POST[version]', '$_POST[longdesc]', '$_POST[screenshot]', '$_POST[dlurl]', '$_POST[mirror]', '$time', '$_POST[category]', '$_POST[posticon]', '$_POST[license]', '$_POST[pin]', '$_POST[documentation]', 'approved', '$_POST[filesize]', '$_POST[filetype]', '$_POST[fee]', '$_POST[downloadlist]')");
                    $fid = $db->insert_id();

                    if (!empty($_POST['custom'])) {
                        foreach($_POST['custom'] as $key => $result) {
                            $result = trim(stripslashes($result));
                            if (!empty($result)) {
                                $db->query("INSERT INTO ".X_PREFIX."files_custom_data (file, custom, data) VALUES ('$fid', '$key', '".checkInput(addslashes($result), 'no', 'no', '', false)."')");
                            }
                        }
                    }

                    files_confirmmsg($lang['fileadded'], 'files_admin.php?action=file&file=add');
                }
                break;

            case 'edit':
                $_POST['fileid'] = (isset($_POST['fileid']) ? (int) $_POST['fileid'] : 0);
                if (!isset($_POST['deletesubmit']) && !isset($_POST['editsubmit']) && !isset($_POST['filesubmit']) && !isset($id)) {
                    $lettersort = files_letters('files_admin.php?action=file&file=edit');
                    $listfiles = array();
                    $listfiles[] = '<select name="fileid">';
                    $listfiles[] = '<option value="">'.$lang['selectfile'].':</option>';
                    $listfiles[] = '<option value="">--------------------</option>';
                    $addquery = ((!empty($edit) && $edit != 'all') ? "WHERE name LIKE '$edit%'" : "");
                    $query = $db->query("SELECT * FROM ".X_PREFIX."files $addquery ORDER BY name");
                    while($file = $db->fetch_array($query)) {
                        $file['name'] = stripslashes($file['name']);
                        if ($file['name'] != '') {
                            $listfiles[] = '<option value="'.intval($file['id']).'">'.$file['name'].'</option>';
                        }
                    }
                    $listfiles[] = '</select>';
                    $listfiles = implode("\n", $listfiles);
                    $db->free_result($query);
                    eval('echo "'.template('files_admin_files_select').'";');
                }

                if (isset($_POST['deletesubmit'])) {
                    if ($_POST['fileid'] == 0) {
                        files_errormsg($lang['selectdeletefile']);
                    }

                    @unlink('./'.$SETTINGS['files_foldername'].'/'.$file['name']);

                    $db->query("DELETE FROM ".X_PREFIX."files WHERE id='$_POST[fileid]'");
                    $db->query("DELETE FROM ".X_PREFIX."files_votes WHERE file='$_POST[fileid]'");
                    $db->query("DELETE FROM ".X_PREFIX."files_custom_data WHERE file='$_POST[fileid]'");

                    files_confirmmsg($lang['filedeleted'], 'files_admin.php?action=file&file=edit');
                }

                if (isset($_POST['editsubmit']) || isset($id)) {
                    $id = (isset($id) ? (int) $id : $_POST['fileid']);

                    if ($id == 0) {
                        files_errormsg($lang['selecteditfile']);
                    }

                    $customfields = '';

                    $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE id='$id'");
                    $file = $db->fetch_array($query);
                    $db->free_result($query);

                    $file['name']         = stripslashes($file['name']);
                    $file['description']  = stripslashes($file['description']);
                    $file['creator']      = stripslashes($file['creator']);
                    $file['longdesc']     = stripslashes($file['longdesc']);
                    $file['downloadlist'] = stripslashes($file['downloadlist']);
                    $file['version']      = stripslashes($file['version']);
                    $file['docsurl']      = stripslashes($file['docsurl']);
                    $file['ssurl']        = stripslashes($file['ssurl']);
                    $file['dlurl']        = stripslashes($file['dlurl']);
                    $file['mirror']       = stripslashes($file['mirror']);

                    $icons = files_posticons();

                    if ($file['posticon'] != '') {
                        $icons = str_replace($file['posticon']."\"", $file['posticon']."\" checked=\"checked\"", $icons);
                    } else {
                        $icons = str_replace('<input type="radio" name="posticon" value="" />', '<input type="radio" name="posticon" value="" '.$cheHTML.' />', $icons);
                    }

                    $listcats = array();
                    $listcats[] = '<select name="category">';
                    $catquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='0' ORDER BY name");
                    while($cat = $db->fetch_array($catquery)) {
                        $cat['name'] = stripslashes($cat['name']);
                        if ($file['catid'] == (int)$cat['id']) {
                            $listcats[] = '<option value="'.intval($cat['id']).'" '.$selHTML.'>'.$cat['name'].'</option>';
                        } else {
                            $listcats[] = '<option value="'.intval($cat['id']).'">'.$cat['name'].'</option>';
                        }
                        $subquery = $db->query("SELECT * FROM ".X_PREFIX."files_categories WHERE status='on' AND parent='$cat[id]' ORDER BY name");
                        while($sub = $db->fetch_array($subquery)) {
                            $sub['name'] = stripslashes($sub['name']);
                            if ($file['catid'] == $sub['id']) {
                                $listcats[] = '<option value="'.intval($sub['id']).'" '.$selHTML.'>&nbsp;&nbsp;&nbsp;'.$sub['name'].'</option>';
                            } else {
                                $listcats[] = '<option value="'.intval($sub['id']).'">&nbsp;&nbsp;&nbsp;'.$sub['name'].'</option>';
                            }
                        }
                        $db->free_result($subquery);
                    }
                    $listcats[] = '</select>';
                    $listcats = implode("\n", $listcats);
                    $db->free_result($catquery);

                    $listlicenses = array();
                    $listlicenses[] = '<select name="license">';
                    if ($file['license'] == 0) {
                        $listlicenses[] = '<option value="0" '.$selHTML.'>'.$lang['none'].'</option>';
                    } else {
                        $listlicenses[] = '<option value="0">'.$lang['none'].'</option>';
                    }
                    $licquery = $db->query("SELECT * FROM ".X_PREFIX."files_licenses ORDER BY name");
                    while($license = $db->fetch_array($licquery)) {
                        $license['name'] = stripslashes($license['name']);
                        if ($file['license'] == $license['id']) {
                            $listlicenses[] = '<option value="'.intval($license['id']).'" '.$selHTML.'>'.$license['name'].'</option>';
                        } else {
                            $listlicenses[] = '<option value="'.intval($license['id']).'">'.$license['name'].'</option>';
                        }
                    }
                    $listlicenses[] = '</select>';
                    $listlicenses = implode("\n", $listlicenses);
                    $db->free_result($licquery);

                    if ($file['posticon'] != '') {
                        $icon = '<img src="'.$THEME['smdir'].'/'.$file['posticon'].'" border="0" alt="" />';
                    } else {
                        $icon = '';
                    }

                    $pin_yes = $pin_no = '';
                    switch($file['pin']) {
                        case 'yes':
                            $pin_yes = $cheHTML;
                            break;
                        default:
                            $pin_no = $cheHTML;
                            break;
                    }

                    $customquery = $db->query("SELECT * FROM ".X_PREFIX."files_custom");
                    while($custom = $db->fetch_array($customquery)) {
                        $dataquery = $db->query("SELECT data FROM ".X_PREFIX."files_custom_data WHERE file='$id' AND custom='$custom[id]'");
                        $data = $db->fetch_array($dataquery);
                        $custom['name'] = stripslashes($custom['name']);
                        $custom['description'] = stripslashes($custom['description']);
                        $customdata['data'] = stripslashes($data['data']);
                        eval('$customfields .= "'.template('files_admin_files_custom').'";');
                    }
                    $db->free_result($customquery);

                    $return = '';
                    if (!isset($_POST['fileid']) || $_POST['fileid'] == 0) {
                        $return = '<input type="hidden" name="rid" value="'.$id.'" />';
                    }
                    eval('echo "'.template('files_admin_files_edit').'";');
                }

                if (isset($_POST['filesubmit'])) {
                    $fid = (int)$fid;
                    if ($fid == 0) {
                        files_errormsg($lang['selecteditfile']);
                    }

                    if (empty($_POST['name'])) {
                        files_errormsg($lang['nofilename']);
                    }

                    $filesize = $filetype = '';
                    if (isset($_POST['dlurl']) && $_POST['dlurl'] != '') {
                        $fileurl = str_replace(' ', '%20', $_POST['dlurl']);
                        if ('./' == substr($fileurl, 0, 2)) {
                            $fileurl = str_replace('./', $SETTINGS['boardurl'], $fileurl);
                        }
                        $ourhead = '';
                        $url = parse_url($fileurl);
                        $host = $url['host'];
                        $path = $url['path'];
                        $fp = @fsockopen($host, 80, $errno, $errstr, 20);
                        if ($fp) {
                            fputs($fp, "HEAD $fileurl HTTP/1.1\r\n");
                            fputs($fp, "HOST: dummy\r\n");
                            fputs($fp, "Connection: close\r\n\r\n");
                            while(!feof($fp)) {
                                $ourhead = sprintf("%s%s", $ourhead, fgets($fp,128));
                            }
                            $size = explode("Content-Length: ", $ourhead);
                            $filesize = isset($size[1]) ? (int) $size[1] : '';
                            $extension_head = explode("Content-Type: ", $ourhead);
                            $extension = $extension_head[1];
                            if (strpos($extension,';')) {
                                $extension = substr($extension, 0, strpos($extension,';'));
                            }
                            $filetype = $extension;
                        }
                    }
                    @fclose($fp);

                    $_POST['name']          = checkInput(addslashes($_POST['name']),      'no', 'no', '', false);
                    $_POST['shortdesc']     = checkInput(addslashes($_POST['shortdesc']), 'no', 'no', '', false);
                    $_POST['longdesc']      = checkInput(addslashes($_POST['longdesc']),  'no', 'no', '', false);
                    $_POST['creator']       = checkInput(addslashes($_POST['creator']),   'no', 'no', '', false);
                    $_POST['version']       = checkInput(addslashes($_POST['version']),   'no', 'no', '', false);
                    $_POST['screenshot']    = files_url_chk($_POST['screenshot']);
                    $_POST['documentation'] = files_url_chk($_POST['documentation']);
                    $_POST['mirror']        = files_url_chk($_POST['mirror']);
                    $_POST['dlurl']         = addslashes($_POST['dlurl']);
                    $_POST['posticon']      = addslashes($_POST['posticon']);
                    $_POST['category']      = (int)$_POST['category'];
                    $_POST['license']       = (int)$_POST['license'];
                    $_POST['pin']           = ($_POST['pin'] == 'yes' ? 'yes' : 'no');
                    $_POST['downloadlist']  = addslashes($_POST['downloadlist']);
                    $_POST['fee']           = floatval($_POST['fee']);
                    $filesize               = addslashes($filesize);
                    $filetype               = addslashes($filetype);

                    $db->query("UPDATE ".X_PREFIX."files SET
                        name='$_POST[name]',
                        description='$_POST[shortdesc]',
                        longdesc='$_POST[longdesc]',
                        creator='$_POST[creator]',
                        version='$_POST[version]',
                        ssurl='$_POST[screenshot]',
                        docsurl='$_POST[documentation]',
                        dlurl='$_POST[dlurl]',
                        mirror='$_POST[mirror]',
                        posticon='$_POST[posticon]',
                        catid='$_POST[category]',
                        license='$_POST[license]',
                        pin='$_POST[pin]',
                        fee='$_POST[fee]',
                        downloadlist='$_POST[downloadlist]',
                        filesize='$filesize',
                        filetype='$filetype'
                        WHERE id='$fid'
                    ");

                    $db->query("DELETE FROM ".X_PREFIX."files_custom_data WHERE file='$fid'");
                    if (!empty($_POST['custom'])) {
                        foreach($custom as $key => $value) {
                            $value = trim(stripslashes($value));
                            if (!empty($value)) {
                                $db->query("INSERT INTO ".X_PREFIX."files_custom_data (file, custom, data) VALUES ('$fid', '$key', '".checkInput(addslashes($value), 'no', 'no', '', false)."')");
                            }
                        }
                    }

                    if (isset($rid)) {
                        files_confirmmsg($lang['fileupdated'], 'files.php?action=file&id='.$rid);
                    } else {
                        files_confirmmsg($lang['fileupdated'], 'files_admin.php?action=file&file=edit');
                    }
                }
                break;

            case 'approve':
                if (!isset($_POST['approvesubmit'])) {
                    $query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='pending' ORDER BY time ASC");
                    $filecount = $db->num_rows($query);

                    if ($filecount == 0) {
                        files_errormsg($lang['noapprovefiles']);
                    }

                    $files = '';
                    while($file = $db->fetch_array($query)) {
                        $file['name'] = stripslashes($file['name']);
                        $file['description'] = stripslashes($file['description']);

                        $catquery = $db->query("SELECT id, name FROM ".X_PREFIX."files_categories WHERE id='$file[catid]'");
                        $category = $db->fetch_array($catquery);
                        $db->free_result($catquery);

                        $category['name'] = stripslashes($category['name']);

                        $datesubmitted = gmdate($dateformat, $file['submitdate']);

                        if ($file['submitby'] != '') {
                            $submittedby = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($file['submitby']).'">'.$file['submitby'].'</a>';
                        } else {
                            $submittedby = $lang['anonymous'];
                        }

                        $mouseover = files_mouseover('files.php?action=file&id='.intval($file['id']));
                        eval('$files .= "'.template('files_admin_files_approve_files').'";');
                    }
                    $db->free_result($query);
                    eval('echo "'.template('files_admin_files_approve').'";');
                }

                if (isset($_POST['approvesubmit'])) {
                    $query = $db->query("SELECT id, name, dlurl, ssurl, docsurl FROM ".X_PREFIX."files WHERE status='pending'");
                    while($file = $db->fetch_array($query)) {
                        $approve = 'approve'.$file['id'];
                        $approve = isset(${$approve}) ? ${$approve} : '';
                        $decline = 'decline'.$file['id'];
                        $decline = isset(${$decline}) ? ${$decline} : '';
                        $time = $onlinetime;

                        if (isset($approve) && $approve != '') {
                            if (isset($file['dlurl']) && $file['dlurl'] != '') {
                                if ('./' == substr($file['dlurl'], 0, 2)) {
                                    $file['dlurl'] = str_replace('./', $SETTINGS['boardurl'], $file['dlurl']);
                                }
                                $file['dlurl'] = str_replace(' ', '%20', $file['dlurl']);
                                $fp = @fopen($file['dlurl'],"r");
                                if ($fp) {
                                    fclose($fp);
                                } else {
                                    files_errormsg($lang['textfile'].' '.stripslashes($file['name']).' - '.$lang['filenotfound']);
                                }
                            } else {
                                files_errormsg($lang['textfile'].' '.stripslashes($file['name']).' - '.$lang['filenotfound']);
                            }

                            if (isset($file['ssurl']) && $file['ssurl'] != '') {
                                $file['ssurl'] = str_replace(' ', '%20', $file['ssurl']);
                                $fp = @fopen($file['ssurl'],"r");
                                if ($fp) {
                                    fclose($fp);
                                } else {
                                    files_errormsg($lang['textfile'].' '.stripslashes($file['name']).' - '.$lang['invalidssurl']);
                                }
                            }

                            if (isset($file['docsurl']) && $file['docsurl'] != '') {
                                $file['docsurl'] = str_replace(' ', '%20', $file['docsurl']);
                                $fp = @fopen($file['docsurl'],"r");
                                if ($fp) {
                                    fclose($fp);
                                } else {
                                    files_errormsg($lang['textfile'].' '.stripslashes($file['name']).' - '.$lang['invaliddocsurl']);
                                }
                            }
                            $db->query("UPDATE ".X_PREFIX."files SET time='$time', status='approved' WHERE id='$approve'");
                        }

                        if (isset($decline) && $decline != '') {
                            $db->query("DELETE FROM ".X_PREFIX."files WHERE id='$decline'");
                        }
                    }
                    $db->free_result($query);

                    files_confirmmsg($lang['filesupdated'], 'files_admin.php');
                }
                break;
        }
        break;

    case 'settings':
        if (!isset($_POST['settingsubmit'])) {
            $status_on = $status_off = '';
            switch($SETTINGS['files_status']) {
                case 'on':
                    $status_on = $cheHTML;
                    break;
                default:
                    $status_off = $cheHTML;
                    break;
            }

            $SETTINGS['files_foldername'] = stripslashes($SETTINGS['files_foldername']);

            $guests_on = $guests_off = '';
            switch($SETTINGS['files_guests']) {
                case 'on':
                    $guests_on = $cheHTML;
                    break;
                default:
                    $guests_off = $cheHTML;
                    break;
            }

            $screenshot_image = $screenshot_url = '';
            switch($SETTINGS['files_screenshot']) {
                case 'image':
                    $screenshot_image = $cheHTML;
                    break;
                default:
                    $screenshot_url = $cheHTML;
                    break;
            }

            $shotsize = explode('|', $SETTINGS['files_shotsize']);
            $shotwidth = $shotsize[0];
            $shotheight = $shotsize[1];

            $mouseover_on = $mouseover_off = '';
            switch($SETTINGS['files_mouseover']) {
                case 'on':
                    $mouseover_on = $cheHTML;
                    break;
                default:
                    $mouseover_off = $cheHTML;
                    break;
            }

            $report_on = $report_off = '';
            switch($SETTINGS['files_report']) {
                case 'on':
                    $report_on = $cheHTML;
                    break;
                default:
                    $report_off = $cheHTML;
                    break;
            }

            $jumpbox_on = $jumpbox_off = '';
            switch($SETTINGS['files_jumpbox']) {
                case 'on':
                    $jumpbox_on = $cheHTML;
                    break;
                default:
                    $jumpbox_off = $cheHTML;
                    break;
            }

            $search_on = $search_off = '';
            switch($SETTINGS['files_search']) {
                case 'on':
                    $search_on = $cheHTML;
                    break;
                default:
                    $search_off = $cheHTML;
                    break;
            }

            $stats_on = $stats_off = '';
            switch($SETTINGS['files_stats']) {
                case 'on':
                    $stats_on = $cheHTML;
                    break;
                default:
                    $stats_off = $cheHTML;
                    break;
            }

            $notify_on = $notify_off = '';
            switch($SETTINGS['files_notify']) {
                case 'on':
                    $notify_on = $cheHTML;
                    break;
                default:
                    $notify_off = $cheHTML;
                    break;
            }

            $commentreport_on = $commentreport_off = '';
            switch($SETTINGS['files_comment_report']) {
                case 'on':
                    $commentreport_on = $cheHTML;
                    break;
                default:
                    $commentreport_off = $cheHTML;
                    break;
            }

            $navigation_on = $navigation_off = '';
            switch($SETTINGS['files_navigation']) {
                case 'on':
                    $navigation_on = $cheHTML;
                    break;
                default:
                    $navigation_off = $cheHTML;
                    break;
            }

            $faq_on = $faq_off = '';
            switch($SETTINGS['files_faq']) {
                case 'on':
                    $faq_on = $cheHTML;
                    break;
                default:
                    $faq_off = $cheHTML;
                    break;
            }

            $SETTINGS['files_content_types'] = stripslashes($SETTINGS['files_content_types']);
            $SETTINGS['files_paypal_account'] = stripslashes($SETTINGS['files_paypal_account']);
            eval('echo "'.template('files_admin_settings').'";');
        }

        if (isset($_POST['settingsubmit'])) {
            if (empty($_POST['foldername'])) {
                files_errormsg($lang['nofoldername']);
            }

            $_POST['foldername'] = addslashes($_POST['foldername']);
            $_POST['files_content_types'] = addslashes($_POST['files_content_types']);
            $_POST['files_paypal_account'] = addslashes($_POST['files_paypal_account']);

            $db->query("UPDATE ".X_PREFIX."settings SET
                files_status='$_POST[status]',
                files_foldername='$_POST[foldername]',
                files_guests='$_POST[guests]',
                files_screenshot='$_POST[screenshot]',
                files_shotsize='$_POST[shotwidth]|$_POST[shotheight]',
                files_cpp='$_POST[cpp]',
                files_fpp='$_POST[fpp]',
                files_mouseover='$_POST[mouseover]',
                files_report='$_POST[report]',
                files_jumpbox='$_POST[jumpbox]',
                files_search='$_POST[search]',
                files_spp='$_POST[spp]',
                files_searchcolor='$_POST[searchcolor]',
                files_stats='$_POST[stats]',
                files_notify='$_POST[notify]',
                files_content_types='$_POST[files_content_types]',
                files_comment_report='$_POST[files_comment_report]',
                files_navigation='$_POST[files_navigation]',
                files_faq='$_POST[files_faq]',
                files_paypal_account='$_POST[files_paypal_account]'
            ");

            files_confirmmsg($lang['settingsupdated'], 'files_admin.php?action=settings');
        }
        break;
}

$jumpbox = files_jumpbox();

eval('echo "'.template('files_copyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>