<?php
/**
 * Title: Download Center
 * Author(s): John Briggs
 * Copyright: (c) 2009 John Briggs
 * Website: http://www.pearljamboots.com
 * Contact: john@pearljamboots.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'files_stats.php');

require 'header.php';
require ROOT.'include/files.inc.php';

loadtemplates(
'files_stats',
'files_copyright',
'files_error'
);

eval('$css = "'.template('css').'";');

if (file_exists('install.php') && !@unlink('install.php') || file_exists('files.xmb') && !@unlink('files.xmb')) {
    error('You must remove the install files named "install.php" and "files.xmb" before you may proceed to use the files system!');
}

nav('<a href="files.php">'.$lang['downloadcenter'].'</a>');
nav($lang['download'].' '.$lang['stats']);

eval('echo "'.template('header').'";');

if ((!X_MEMBER) && $SETTINGS['files_guests'] != 'on') {
    files_errormsg($lang['featureunavailable']);
}

if ($SETTINGS['files_status'] == 'off' && (!X_ADMIN)) {
    files_errormsg($lang['featuredisabled']);
}

if ($SETTINGS['files_stats'] == 'off' && (!X_ADMIN)) {
    files_errormsg($lang['featuredisabled']);
}

$catarray = files_category_array();
$catlist = "'".implode("', '", $catarray)."'";

$query = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."files_categories WHERE status='on' AND id IN ($catlist)");
$totalcategories = $db->result($query, 0);
$db->free_result($query);

$query = $db->query("SELECT COUNT(*) FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist)");
$totalfiles = $db->result($query, 0);
$db->free_result($query);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY time DESC");
$newestfile = $db->fetch_array($query);
$db->free_result($query);
$newestfile['name'] = stripslashes($newestfile['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY time ASC");
$oldestfile = $db->fetch_array($query);
$db->free_result($query);
$oldestfile['name'] = stripslashes($oldestfile['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY views DESC");
$mostview = $db->fetch_array($query);
$db->free_result($query);
$mostview['name'] = stripslashes($mostview['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY views ASC");
$leastview = $db->fetch_array($query);
$db->free_result($query);
$leastview['name'] = stripslashes($leastview['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND votes > 0 AND catid IN ($catlist) ORDER BY (rating/votes) DESC");
$mostpopular = $db->fetch_array($query);
$db->free_result($query);
$mostpopular['name'] = stripslashes($mostpopular['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY (rating/votes) ASC");
$leastpopular = $db->fetch_array($query);
$db->free_result($query);
$leastpopular['name'] = stripslashes($leastpopular['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY dls DESC");
$mostdownload = $db->fetch_array($query);
$db->free_result($query);
$mostdownload['name'] = stripslashes($mostdownload['name']);

$query = $db->query("SELECT * FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist) ORDER BY dls ASC");
$leastdownload = $db->fetch_array($query);
$db->free_result($query);
$leastdownload['name'] = stripslashes($leastdownload['name']);

$query = $db->query("SELECT SUM(dls) FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist)");
$totaldownloads = $db->result($query, 0);
$db->free_result($query);
$totaldownloads = isset($totaldownloads) ? $totaldownloads : 0;

$query = $db->query("SELECT SUM(rating) FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist)");
$avg1 = $db->result($query, 0);
$db->free_result($query);

$query = $db->query("SELECT SUM(votes) FROM ".X_PREFIX."files WHERE status='approved' AND catid IN ($catlist)");
$avg2 = $db->result($query, 0);
$db->free_result($query);

$stars_average = '';
$average = @round($avg1/$avg2);
for($i = 0; $i < $average; $i++) {
    $stars_average .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$average.'/10" />';
}

$averagedownloads = @round($totaldownloads/$totalfiles);

$stars_least = '';
$least = @round($leastpopular['rating']/$leastpopular['votes']);
for($i = 0; $i < $least; $i++) {
    $stars_least .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$least.'/10" />';
}

$stars_most = '';
$most = @round($mostpopular['rating']/$mostpopular['votes']);
for($i = 0; $i < $most; $i++) {
    $stars_most .= '<img src="'.$THEME['imgdir'].'/star.gif" border="0" alt="'.$most.'/10" />';
}

eval($lang['downloadstats1']);

if (!empty($oldestfile['id'])) {
    eval($lang['downloadstats2']);
} else {
    $lang['downloadstats2'] = '';
}

if (!empty($newestfile['id'])) {
    eval($lang['downloadstats3']);
} else {
    $lang['downloadstats3'] = '';
}

if (!empty($leastview['id'])) {
    eval($lang['downloadstats4']);
} else {
    $lang['downloadstats4'] = '';
}

if (!empty($mostview['id'])) {
    eval($lang['downloadstats5']);
} else {
    $lang['downloadstats5'] = '';
}

if (!empty($leastpopular['id'])) {
    eval($lang['downloadstats6']);
} else {
    $lang['downloadstats6'] = '';
}

if (!empty($mostpopular['id'])) {
    eval($lang['downloadstats7']);
} else {
    $lang['downloadstats7'] = '';
}

if (!empty($leastdownload['id'])) {
    eval($lang['downloadstats8']);
} else {
    $lang['downloadstats8'] = '';
}

if (!empty($mostdownload['id'])) {
    eval($lang['downloadstats9']);
} else {
    $lang['downloadstats9'] = '';
}

eval($lang['downloadstats10']);
eval($lang['downloadstats11']);
eval($lang['downloadstats12']);

eval('echo "'.template('files_stats').'";');

$jumpbox = files_jumpbox();

eval('echo "'.template('files_copyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>