<?php
/**
 * Portal System v6.0
 * Copyright (c) 2001-2008 John Briggs
 * The XMB Group
 * http://xmbforum.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 11/30/2008 - correction to left right center block creation.  Fix by whinpo.
 *
 **/

define('X_SCRIPT', 'portal.php');

require 'header.php';
require ROOT.'include/portal.inc.php';

assertPortalTranslation();

$tid = getInt('tid', 'r');

loadtemplates(
'index_ticker',
'portal_news',
'portal_news_archive',
'portal_guest',
'portal_member',
'index_whosonline',
'index_whosonline_today',
'portal_home',
'portal_main_menu',
'portal_search',
'portal_main_block',
'portal_member_mood',
'portal_newmember',
'portal_newposts',
'portal_top_members',
'portal_quick_reg_password',
'portal_quick_reg',
'portal_quick_reg_captcha',
'pcopyright',
'viewthread_post_attachment',
'viewthread_post_attachmentimage',
'viewthread_post_attachmentthumb'
);

eval('$css = "'.template('css').'";');

smcwcache();

if ($SETTINGS['portaltitle'] != '') {
    nav($SETTINGS['portaltitle']);
} else {
    nav($lang['portalnav']);
}

eval('echo "'.template('header').'";');

if ($SETTINGS['portalstatus'] != 'on') {
    error($lang['portaloffmsg'], false);
}

$plinks = array();

$plinks[] = '&raquo;&nbsp;<a href="index.php?forums"><font class="smalltxt">'.$lang['portalmainnav'].'</font></a>';

if ($SETTINGS['searchstatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="search.php"><font class="smalltxt">'.$lang['textsearch'].'</font></a>';
}

if ($SETTINGS['faqstatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="faq.php"><font class="smalltxt">'.$lang['textfaq'].'</font></a>';
}

if ($SETTINGS['memliststatus'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="misc.php?action=list"><font class="smalltxt">'.$lang['textmemberlist'].'</font></a>';
}

if ($SETTINGS['todaysposts'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="today.php"><font class="smalltxt">'.$lang['navtodaysposts'].'</font></a>';
}

if ($SETTINGS['stats'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="stats.php"><font class="smalltxt">'.$lang['navstats'].'</font></a>';
}

if ($SETTINGS['bbrules'] == 'on') {
    $plinks[] = '&raquo;&nbsp;<a href="faq.php?page=forumrules"><font class="smalltxt">'.$lang['textbbrules'].'</font></a>';
}

$plinks = implode("<br />", $plinks);

$fids = permittedForums(forumCache(), 'thread', 'csv');
if ($fids == '') {
     $restrict = 'FALSE';
} else {
     $restrict = 'fid IN('.$fids.')';
}

$sql = $db->query("SELECT COUNT(uid) FROM ".X_PREFIX."members UNION ALL SELECT COUNT(tid) FROM ".X_PREFIX."threads UNION ALL SELECT COUNT(pid) FROM ".X_PREFIX."posts");
$portal_members = $db->result($sql, 0);
if ($portal_members == false) {
    $portal_members = 0;
}

$portal_threads = $db->result($sql, 1);
if ($portal_threads == false) {
    $portal_threads = 0;
}

$portal_posts = $db->result($sql, 2);
if ($portal_posts == false) {
    $portal_posts = 0;
}
$db->free_result($sql);

$portal_newest_topic = '';
$sql = $db->query("SELECT lastpost, tid, subject FROM ".X_PREFIX."threads WHERE $restrict ORDER BY lastpost DESC LIMIT 0,1");
while($last = $db->fetch_array($sql)) {
    $last['subject'] = shortenString(rawHTMLsubject(stripslashes($last['subject'])), 125, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $last['subject'] = postify($last['subject'], 'no', 'no', 'yes', 'no', 'yes', 'yes');
    $portal_newest_topic = '<a href="viewthread.php?tid='.$last['tid'].'">'.$last['subject'].'</a>';
}
$db->free_result($sql);

$sql = $db->query("SELECT regdate FROM ".X_PREFIX."members ORDER BY regdate LIMIT 0, 1");
$days = ($onlinetime - @$db->result($sql, 0)) / 86400;
if ($days > 0) {
    $membersday = number_format(($portal_members / $days), 2);
} else {
    $membersday = number_format(0, 2);
}
$db->free_result($sql);

$timesearch = $onlinetime - 86400;
$eval = $lang['evalnobestmember'];

$sql = $db->query("SELECT author, COUNT(author) AS Total FROM ".X_PREFIX."posts WHERE dateline >= '$timesearch' GROUP BY author ORDER BY Total DESC LIMIT 1");
$info = $db->fetch_array($sql);

if ($info['Total'] != 0) {
    $portal_membesthtml = '<a href="member.php?action=viewpro&amp;member='.recodeOut($info['author']).'"><strong>'.$info['author'].'</strong></a>';
} else {
    $portal_membesthtml = $lang['textnone'];
}
$db->free_result($sql);

if (isset($smileyoff) && $smileyoff == 'yes') {
    $smileyoff = 'yes';
} else {
    $smileyoff = 'no';
}

if (isset($bbcodeoff) && $bbcodeoff == 'yes') {
    $bbcodeoff = 'yes';
} else {
    $bbcodeoff = 'no';
}

$portal_news = '';
$forum = getForum($SETTINGS['portalnewsfid']);
$sql = "SELECT p.*, query2.postcount FROM ".X_PREFIX."posts AS p INNER JOIN ( "
     . " SELECT tid, MIN(dateline) AS firstdate, COUNT(*) AS postcount FROM ".X_PREFIX."posts "
     . " WHERE fid={$SETTINGS['portalnewsfid']} GROUP BY tid "
     . ") AS query2 ON p.tid = query2.tid AND p.dateline = query2.firstdate "
     . "ORDER BY p.dateline DESC LIMIT 0, {$SETTINGS['portalnewsdisplays']}";
$sql = $db->query($sql);

$pids = array();
while($news = $db->fetch_array($sql)) {
    $pids[] = $news['pid'];
}
$pids = implode(', ', $pids);

if (strlen($pids) != 0) {
    $db->data_seek($sql, 0);
    if ($forum['attachstatus'] == 'on') {
        require('include/attach.inc.php');
        $queryattach = $db->query("SELECT a.aid, a.pid, a.filename, a.filetype, a.filesize, a.downloads, a.img_size, thumbs.aid AS thumbid, thumbs.filename AS thumbname, thumbs.img_size AS thumbsize FROM ".X_PREFIX."attachments AS a LEFT JOIN ".X_PREFIX."attachments AS thumbs ON a.aid=thumbs.parentid INNER JOIN ".X_PREFIX."posts AS p ON a.pid=p.pid WHERE p.pid IN ($pids) AND a.parentid=0");
    }
}

while($news = $db->fetch_array($sql)) {
    $author = '<a href="member.php?action=viewpro&amp;member='.recodeOut($news['author']).'">'.$news['author'].'</a>';
    $tid = $news['tid'];
    $date = gmdate($dateformat, $news['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
    $time = gmdate($timecode, $news['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
    $formatdate = $date.' '.$lang['textat'].' '.$time;

    if ($news['subject'] == '') {
        $news['subject'] = $lang['textnosub'];
    }

    $subject = shortenString(rawHTMLsubject(stripslashes($news['subject'])), 75, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $subject = postify($news['subject'], 'no', 'no', 'yes', 'no', 'yes', 'yes');
    $message = shortenString(stripslashes($news['message']), 300, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $message = postify($message, $smileyoff, $bbcodeoff, $forum['allowsmilies'], $forum['allowhtml'], $forum['allowbbcode'], $forum['allowimgcode'], false);

    if ($forum['attachstatus'] == 'on' And $db->num_rows($queryattach) > 0) {
        $files = array();
        $db->data_seek($queryattach, 0);
        while($attach = $db->fetch_array($queryattach)) {
            if ($attach['pid'] == $news['pid']) {
                $files[] = $attach;
            }
        }
        if (count($files) > 0) {
            bbcodeFileTags($message, $files, $news['pid'], ($forum['allowbbcode'] == 'yes' And $news['bbcodeoff'] == 'no'));
        }
    }

    $comments = $news['postcount'];
    $comments -= 1;
    if ($comments == 1) {
        $comment_txt = $lang['portalcomment'];
    } else {
        $comment_txt = $lang['portalcomments'];
    }

    if ($comments > 0) {
        $comments = '<a href="viewthread.php?tid='.$tid.'">'.$comments.' '.$comment_txt.'</a> |';
    } else {
        $comments = '';
    }

    if (isset($news['icon']) && $news['icon'] != '' && file_exists($THEME['smdir'].'/'.$news['icon'])) {
        $icon = '<img src="'.$THEME['smdir'].'/'.$news['icon'].'" border="0" alt="'.$news['icon'].'" />';
    } else {
        $icon = '<img src="'.$THEME['smdir'].'/'.$SETTINGS['portaldgif'].'" border="0" alt="'.$SETTINGS['portaldgif'].'" />';
    }

    $close = $db->query("SELECT closed FROM ".X_PREFIX."threads WHERE tid=$tid");
    $closed = $db->result($close, 0);
    if ($closed == 'yes') {
        $postcomment = $lang['portalclosed'].' |';
    } else {
        $postcomment = '<a href="post.php?action=reply&amp;fid='.$SETTINGS['portalnewsfid'].'&amp;tid='.$tid.'">'.$lang['textreply'].'</a> |';
    }
    eval('$portal_ne = "'.template('portal_news').'";');
    $portal_news .= $portal_ne;
}
$db->free_result($sql);
eval('$portal_news_archive = "'.template('portal_news_archive').'";');

$memcount = 1;
$top_members_list = '';
$sql = $db->query("SELECT * FROM ".X_PREFIX."members ORDER BY postnum DESC LIMIT 0, $SETTINGS[portaltopmembers]");
while($top_member = $db->fetch_array($sql)) {
    if ($top_members_list == '') {
        if ($top_member['avatar'] != '' && $SETTINGS['portalavatar'] == 'on') {
            $avatar = '<img src="'.$top_member['avatar'].'" border="0" alt="'.$lang['altavatar'].'" /></a></div><br />';
        } else {
            $avatar = '';
        }

        $top_members_list = '<div align="center"><a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'">'.$avatar.'<strong>'.$memcount.'. <a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'">'.$top_member['username'].'</a></strong><br /><strong>'.$lang['portalrank'].'</strong>: '.$top_member['status'].'<br /><strong>'.$lang['memposts'].'</strong>: '.$top_member['postnum'].'<br /><hr />';
        $memcount++;
    } else {
        $top_members_list .= '<strong>'.$memcount.'. <a href="member.php?action=viewpro&amp;member='.recodeOut($top_member['username']).'" title="'.$lang['memposts'].' '.$top_member['postnum'].'">'.$top_member['username'].'</a></strong><br /><strong>'.$lang['portalrank'].'</strong>: '.$top_member['status'].'<br /><strong>'.$lang['memposts'].'</strong>: '.$top_member['postnum'].'<br /><br />';
        $memcount++;
    }
}
$db->free_result($sql);

if (!eregi("[1-9]", $SETTINGS['portalpostsnull'])) {
    $dont_fid = '';
} else {
    $dont_fid = "AND fid NOT IN($SETTINGS[portalpostsnull])";
}

$portal_hot_subject = '';
$portal_hotdate = $onlinetime - ($SETTINGS['portalhotdate'] * 86400);
$sql = $db->query("SELECT tid, subject FROM ".X_PREFIX."threads WHERE $restrict AND (substring_index(lastpost, '|',1)+1) >= '$portal_hotdate' $dont_fid ORDER BY replies DESC LIMIT 0, $SETTINGS[portalhottopics]");
while($reply = $db->fetch_array($sql)) {
    $reply['subject'] = shortenString(rawHTMLsubject(stripslashes($reply['subject'])), 125, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $reply['subject'] = postify($reply['subject'], 'no', 'no', 'yes', 'no', 'yes', 'yes');
    $portal_hot_subject .= '<br /><a href="viewthread.php?tid='.$reply['tid'].'">'.$reply['subject'].'</a>';
}
$db->free_result($sql);

$count = 0;
$thisbg = $THEME['altbg2'];
$post_list = '';
$sql = $db->query("SELECT tid, subject, icon FROM ".X_PREFIX."threads WHERE $restrict $dont_fid ORDER BY lastpost DESC LIMIT 0, $SETTINGS[portalmposts]");
while($last = $db->fetch_array($sql)) {
    $last['subject'] = rawHTMLsubject(stripslashes($last['subject']));
    $last['subject'] = postify($last['subject'], 'no', 'no', 'yes', 'no', 'yes', 'yes');
    if (isset($last['icon']) && $last['icon'] != '' && file_exists($THEME['smdir'].'/'.$last['icon'])) {
        $last['icon'] = '<img src="'.$THEME['smdir'].'/'.$last['icon'].'" alt="'.$last['icon'].'" border="0" >';
    } else {
        $last['icon'] = '<img src="'.$THEME['smdir'].'/'.$SETTINGS['portaldgif'].'" alt="'.$SETTINGS['portaldgif'].'" border="0"/>';
    }

    if ($count == 0) {
        $portal_newest_topic = '<a href="viewthread.php?tid='.$last['tid'].'">'.$last['subject'].'</a>';
    }

    $post_list .= '<tr bgcolor="'.$thisbg.'" class="tablerow"><td width="1">'.$last['icon'].'</td><td><a href="viewthread.php?tid='.$last['tid'].'">'.$last['subject'].'</a></td></tr>';
    $post_list .= "\n";

    if ($thisbg == $THEME['altbg2']) {
        $thisbg = $THEME['altbg1'];
    } else {
        $thisbg = $THEME['altbg2'];
    }
    $count++;
}
$db->free_result($sql);

$num = 0;
$new_members_list = '';
$sql = $db->query("SELECT username FROM ".X_PREFIX."members WHERE lastvisit!=0 ORDER BY regdate DESC LIMIT 0, $SETTINGS[portalnewmembers]");
while($lastmem = $db->fetch_array($sql)) {
    if ($num == 0) {
        $portal_newest_member = '<a href="member.php?action=viewpro&amp;member='.recodeOut($lastmem['username']).'"><strong>'.$lastmem['username'].'</strong></a>';
    }

    $new_members_list .= '<a href="member.php?action=viewpro&amp;member='.recodeOut($lastmem['username']).'">'.$lastmem['username'].'</a><br />';
    $num++;
}
$db->free_result($sql);

$portal_quickreg = '';
if (X_GUEST) {
    $pwtd = '';
    if ($SETTINGS['emailcheck'] != 'on') {
        eval('$pwtd = "'.template('portal_quick_reg_password').'";');
    }

    $captcharegcheck = '';
    if ($SETTINGS['captcha_status'] == 'on' && $SETTINGS['captcha_reg_status'] == 'on' && !DEBUG) {
        require ROOT.'include/captcha.inc.php';
        $Captcha = new Captcha(250, 50);
        if ($Captcha->bCompatible !== false) {
            $imghash = $Captcha->GenerateCode();
            eval('$captcharegcheck = "'.template('portal_quick_reg_captcha').'";');
        }
    }

    $portal_quickreg = '';
    if ($SETTINGS['regstatus'] == 'on') {
        eval('$portal_quickreg = "'.template('portal_quick_reg').'";');
    }
    eval('$portal_welcome = "'.template('portal_guest').'";');
} else {
    if ($self['avatar'] == '') {
        $avatar = '';
    } else {
        $avatar = '<img src="'.$self['avatar'].'" border="0" alt="'.$lang['altavatar'].'" /><br />';
    }
    eval('$portal_welcome = "'.template('portal_member').'";');
}

$ticker = '';
if ($SETTINGS['tickerstatus'] == 'on') {
    $contents = '';
    $news = explode("\n", str_replace(array("\r\n", "\r"), array("\n"), $tickercontents));
    for($i=0;$i<count($news);$i++) {
        if (strlen(trim($news[$i])) == 0) {
            continue;
        }

        $news[$i] = str_replace('\"', '"', addslashes(postify($news[$i], 'no', 'no', 'yes', 'yes', 'yes', 'yes', false, 'yes', 'no')));
        $contents .= "\tcontents[$i]='$news[$i]';\n";
    }
    eval('$ticker = "'.template('index_ticker').'";');
}

$whosonline = $whosonlinetoday = '';
if ($SETTINGS['whosonlinestatus'] == 'on') {
    $hiddencount = 0;
    $membercount = 0;
    $guestcount = $db->result($db->query("SELECT COUNT(DISTINCT ip) AS guestcount FROM ".X_PREFIX."whosonline WHERE username = 'xguest123'"), 0);
    $member = array();
    $query  = $db->query("SELECT m.username, MAX(m.status) AS status, MAX(m.invisible) AS invisible FROM ".X_PREFIX."members AS m INNER JOIN ".X_PREFIX."whosonline USING (username) GROUP BY m.username ORDER BY m.username");
    while($online = $db->fetch_array($query)) {
        if ($online['invisible'] != 0 && X_ADMIN) {
            $member[] = $online;
            $hiddencount++;
        } else if ($online['invisible'] != 0) {
            $hiddencount++;
        } else {
            $member[] = $online;
            $membercount++;
        }
    }
    $db->free_result($query);

    $onlinetotal = $guestcount + $membercount;

    if ($membercount != 1) {
        $membern = '<strong>'.$membercount.'</strong> '.$lang['textmembers'];
    } else {
        $membern = '<strong>1</strong> '.$lang['textmem'];
    }

    if ($guestcount != 1) {
        $guestn = '<strong>'.$guestcount.'</strong> '.$lang['textguests'];
    } else {
        $guestn = '<strong>1</strong> '.$lang['textguest1'];
    }

    if ($hiddencount != 1) {
        $hiddenn = '<strong>'.$hiddencount.'</strong> '.$lang['texthmems'];
    } else {
        $hiddenn = '<strong>1</strong> '.$lang['texthmem'];
    }

    eval($lang['whosoneval']);
    $memonmsg = '<span class="smalltxt">'.$lang['whosonmsg'].'</span>';

    $memtally = array();
    $num = 1;
    $show_total = (X_ADMIN) ? ($membercount+$hiddencount) : ($membercount);

    $show_inv_key = false;
    for($mnum=0; $mnum<$show_total; $mnum++) {
        $pre = $suff = '';

        $online = $member[$mnum];

        $pre = '<span class="status_'.str_replace(' ', '_', $online['status']).'">';
        $suff = '</span>';

        if ($online['invisible'] != '0') {
            $pre .= '<strike>';
            $suff = '</strike>'.$suff;
            if (!X_ADMIN && $online['username'] != $xmbuser) {
                $num++;
                continue;
            }
        }

        if ($online['username'] == $xmbuser && $online['invisible'] != '0') {
            $show_inv_key = true;
        }

        $memtally[] = '<a href="member.php?action=viewpro&amp;member='.recodeOut($online['username']).'">'.$pre.''.$online['username'].''.$suff.'</a>';
        $num++;
    }

    if (X_ADMIN || $show_inv_key === true) {
        $hidden = ' - <strike>'.$lang['texthmem'].'</strike>';
    } else {
        $hidden = '';
    }

    $memtally = implode(', ', $memtally);
    if ($memtally == '') {
        $memtally = '&nbsp;';
    }

    $whosonlinetoday = '';
    if ($SETTINGS['onlinetoday_status'] == 'on') {
        $datecut = $onlinetime - (3600 * 24);
        if (X_ADMIN) {
            $query = $db->query("SELECT username, status FROM ".X_PREFIX."members WHERE lastvisit >= '$datecut' ORDER BY lastvisit DESC LIMIT 0, $onlinetodaycount");
        } else {
            $query = $db->query("SELECT username, status FROM ".X_PREFIX."members WHERE lastvisit >= '$datecut' AND invisible != '1' ORDER BY lastvisit DESC LIMIT 0, $onlinetodaycount");
        }

        $todaymembersnum = 0;
        $todaymembers = array();
        $pre = $suff = '';
        while($memberstoday = $db->fetch_array($query)) {
            $pre = '<span class="status_'.str_replace(' ', '_', $memberstoday['status']).'">';
            $suff = '</span>';
            $todaymembers[] = '<a href="member.php?action=viewpro&amp;member='.recodeOut($memberstoday['username']).'">'.$pre.''.$memberstoday['username'].''.$suff.'</a>';
            ++$todaymembersnum;
        }
        $todaymembers = implode(', ', $todaymembers);
        $db->free_result($query);

        if ($todaymembersnum == 1) {
            $memontoday = $todaymembersnum.$lang['textmembertoday'];
        } else {
            $memontoday = $todaymembersnum.$lang['textmemberstoday'];
        }
        eval($lang['last50todayeval']);
        eval('$whosonlinetoday = "'.template('index_whosonline_today').'";');
    }
    eval('$whosonline = "'.template('index_whosonline').'";');
}

$moodmems_list = '';
$sql = $db->query("SELECT username, mood FROM ".X_PREFIX."members WHERE mood != '$lang[nomoodtext]' AND mood != '' AND mood != 'Not Defined' ORDER BY RAND() LIMIT 0, $SETTINGS[portalrmods]");
while ($moodmems = $db->fetch_array($sql)) {
    if ($moodmems['mood'] != '') {
        $moodmems['mood'] = postify($moodmems['mood'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    } else {
        $moodmems['mood'] = $lang['nomoodtext'];
    }

    $moodmems_list .= '<tr><td class="mediumtxt" bgcolor="'.$altbg2.'"><a href="member.php?action=viewpro&amp;member='.recodeOut($moodmems['username']).'">'.$moodmems['username'].'</a></td><td class="mediumtxt" bgcolor="'.$altbg1.'">'.$moodmems['mood'].'</td></tr>';
    $moodmems_list .= "\n";
}
$db->free_result($sql);

$center = array();
$right = array();
$left = array();

$sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates WHERE status='on' ORDER BY displayorder ASC LIMIT 0, 30");
while($block = $db->fetch_array($sql)) {
    if ($block['direction'] == 'center') {
        eval('$center[] = "'.template($block['name']).'";');
    } else if ($block['direction'] == 'right') {
        eval('$right[] = "'.template($block['name']).'";');
    } else if ($block['direction'] == 'left') {
        eval('$left[] = "'.template($block['name']).'";');
    }
}
$db->free_result($sql);

$centerblock = implode('<br />', $center);
$rightblock = implode('<br />', $right);
$leftblock = implode('<br />', $left);

eval('echo "'.template('portal_home').'";');

// please do not remove this.
// show your support by keeping this in place so others may enjoy.
eval('echo "'.template('pcopyright').'";');

end_time();
eval('echo "'.template('footer').'";');
?>
