<?php
/**
 * Portal System v6.0
 * Copyright (c) 2001-2008 John Briggs
 * The XMB Group
 * http://xmbforum.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

if (!defined('IN_CODE')) {
    exit("Not allowed to run this file directly.");
}

function assertPortalTranslation() {
    global $lang, $langfile;

    if (isset($lang['portalview'])) {
        return TRUE;
    } elseif (installPortalTranslation($langfile)) {
        loadLang($langfile);
        return TRUE;
    } else {
        exit ('Error: XMB Portal failed to start because the default language is missing.  Please place English.portal.php in the lang subfolder to correct this.');
    }
}

function installPortalTranslation($loadname='', $savename='') {
    global $langfile;

    require_once(ROOT.'include/translation.inc.php');

    if ($loadname == '') {
        $loadname = $langfile;
    }
    if ($savename == '') {
        $savename = $loadname;
    }

    // Load a portal language file
    if (file_exists(ROOT.'lang/'.$loadname.'.portal.php')) {
        require ROOT.'lang/'.$loadname.'.portal.php';
    } elseif (file_exists(ROOT.'lang/English.portal.php')) {
        require ROOT.'lang/English.portal.php';
    } else {
        return FALSE;
    }

    setManyLangValues($lang, $savename);

    // Portal language is now installed but is not loaded.
    return TRUE;
}
?>
