<?php
/**
 * Portal System v6.0
 * Copyright (c) 2001-2008 John Briggs
 * The XMB Group
 * http://xmbforum.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

define('X_SCRIPT', 'cp_portal.php');

require 'header.php';
require ROOT.'include/admin.inc.php';

header('X-Robots-Tag: noindex');

$tid = getInt('tid', 'r');

loadtemplates(
'error_nologinsession',
'padmin_admin_menu',
'padmin_admin_settings',
'padmin_admin_blockselect',
'padmin_admin_blockadd',
'padmin_admin_editselect',
'padmin_admin_blockedit'
);

eval('$css = "'.template('css').'";');

nav('<a href="cp.php">'.$lang['textcp'].'</a>');
nav($lang['portalcp']);

eval('echo "'.template('header').'";');

if (!X_ADMIN) {
    eval('echo "'.template('error_nologinsession').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit();
}

smcwcache();

$auditaction = $_SERVER['REQUEST_URI'];
$aapos = strpos($auditaction, "?");
if ($aapos !== false) {
    $auditaction = substr($auditaction, $aapos + 1);
}
$auditaction = addslashes("$onlineip|#|$auditaction");
audit($xmbuser, $auditaction, 0, 0);

$blocks = postedVar('blocks', '', FALSE, FALSE, FALSE, 'r');

eval('echo "'.template('padmin_admin_menu').'";');

if ($action == 'settings') {
    if (noSubmit('settingsubmit')) {
        $portalavataron = $portalavataroff = '';
        settingHTML('portalavatar', $portalavataron, $portalavataroff);

        $portalstatuson = $portalstatusoff = '';
        settingHTML('portalstatus', $portalstatuson, $portalstatusoff);

        $portalviewon = $portalviewoff = '';
        settingHTML('portalview', $portalviewon, $portalviewoff);

        eval('echo "'.template('padmin_admin_settings').'";');
    }

    if (onSubmit('settingsubmit')) {
        if (empty($portaltitlenew)) {
            error($lang['portalnotitle'], false);
        }

        if (empty($portaldgifnew)) {
            error($lang['portalnodgif'], false);
        }

        $portaltitlenew = postedVar('portaltitlenew');
        $portaldgifnew = postedVar('portaldgifnew');
        $portalpostsnullnew = postedVar('portalpostsnullnew');
        $portalnewsfidnew = formInt('portalnewsfidnew');
        $portalnewsdisplaysnew = formInt('portalnewsdisplaysnew');
        $portalmpostsnew = formInt('portalmpostsnew');
        $portalhotdatenew = formInt('portalhotdatenew');
        $portalhottopicsnew = formInt('portalhottopicsnew');
        $portalnewmembersnew = formInt('portalnewmembersnew');
        $portalrmodsnew = formInt('portalrmodsnew');
        $portaltopmembersnew = formInt('portaltopmembersnew');

        $portalavatarnew = formOnOff('portalavatarnew');
        $portalstatusnew = formOnOff('portalstatusnew');
        $portalviewnew = formOnOff('portalviewnew');

        $db->query("UPDATE ".X_PREFIX."settings SET
            portaltitle='$portaltitlenew',
            portalnewsfid='$portalnewsfidnew',
            portalnewsdisplays='$portalnewsdisplaysnew',
            portalmposts='$portalmpostsnew',
            portalhotdate='$portalhotdatenew',
            portalhottopics='$portalhottopicsnew',
            portaldgif='$portaldgifnew',
            portalnewmembers='$portalnewmembersnew',
            portalrmods='$portalrmodsnew',
            portalavatar='$portalavatarnew',
            portaltopmembers='$portaltopmembersnew',
            portalpostsnull='$portalpostsnullnew',
            portalstatus='$portalstatusnew',
            portalview='$portalviewnew'
        ");

        echo '<br />';
        message($lang['portalsettingsupdated'], false, '', '', 'cp_portal.php?action=settings', true, false, true);
    }
}

if ($action == 'blocks') {
    if ($blocks == 'delete') {
        if (noSubmit('blockdeletesubmit')) {
            $listblocks = array();
            $listblocks[] = '<select name="pid">';
            $listblocks[] = '<option value="">'.$lang['portalselectblock'].':</option>';
            $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates ORDER BY name ASC");
            while($t = $db->fetch_array($sql)) {
                $listblocks[] = '<option value="'.intval($t['id']).'">'.stripslashes($t['name']).'</option>';
            }
            $listblocks[] = '</select>';
            $listblocks = implode("\n", $listblocks);
            $db->free_result($sql);

            $listtemplates = array();
            $listtemplates[] = '<select name="tid">';
            $listtemplates[] = '<option value="">'.$lang['portalselectblock'].':</option>';
            $sql = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name LIKE 'portal_%' ORDER BY name ASC");
            while($p = $db->fetch_array($sql)) {
                $listtemplates[] = '<option value="'.intval($p['id']).'">'.stripslashes($p['name']).'</option>';
            }
            $listtemplates[] = '</select>';
            $listtemplates = implode("\n", $listtemplates);
            $db->free_result($sql);
            eval('echo "'.template('padmin_admin_blockselect').'";');
        }

        if (onSubmit('blockdeletesubmit')) {
            $pid = formInt('pid');
            $tid = formInt('tid');
            $db->query("DELETE FROM ".X_PREFIX."portal_templates WHERE id=$pid");
            $db->query("DELETE FROM ".X_PREFIX."templates WHERE id=$tid");
            echo '<br />';
            message($lang['portalblockdeleted'], false, '', '', 'cp_portal.php?action=blocks&blocks=delete', true, false, true);
        }
    }
}

if ($blocks == 'add') {
    if (noSubmit('addsubmit')) {
        eval('echo "'.template('padmin_admin_blockadd').'";');
    } else {
        $dbnewname = postedVar('newname');
        $dbnewtemplate = $db->escape(addslashes(postedVar('newtemplate', '', FALSE, FALSE)));
        if ($dbnewname == '') {
            error($lang['templateempty'], false);
        }

        $check = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name='$dbnewname'");
        if ($db->num_rows($check) != 0) {
            error($lang['templateexists'], false);
        }

        $check = $db->query("SELECT * FROM ".X_PREFIX."portal_templates WHERE name='$dbnewname'");
        if ($db->num_rows($check) != 0) {
            error($lang['templateexists'], false);
        }

        $newdirection = ($newdirection == 'left') ? 'left' : ($newdirection == 'center' ? 'center' : 'right');
        $newstatus = formOnOff('newstatus');
        $newdisplayorder = getInt('newdisplayorder', 'r');
        $db->query("INSERT INTO ".X_PREFIX."templates (name, template) VALUES ('$dbnewname', '$dbnewtemplate')");
        $db->query("INSERT INTO ".X_PREFIX."portal_templates (name, direction, status, displayorder) VALUES ('$dbnewname', '$newdirection', '$newstatus',  $newdisplayorder)");
        echo '<br />';
        message($lang['portalbadded'], false, '', '', 'cp_portal.php?action=blocks&blocks=add', true, false, true);
    }
}

if ($blocks == 'edit') {
    if (noSubmit('blockeditsubmit')) {
        $selectblocks = array();
        $selectblocks[] = '<select name="tid">';
        $selectblocks[] = '<option value="">'.$lang['portalselectblock'].':</option>';
        $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates ORDER BY name");
        while($t = $db->fetch_array($sql)) {
            $selectblocks[] = '<option value="'.intval($t['id']).'">'.stripslashes($t['name']).'</option>';
        }
        $selectblocks[] = '</select>';
        $selectblocks = implode("\n", $selectblocks);
        $db->free_result($sql);
        eval('echo "'.template('padmin_admin_editselect').'";');
    }

    if (onSubmit('blockeditselect')) {
        $tid = formInt('tid');
        if ($tid == 0) {
            error($lang['selecttemplate'], false);
        }

        $sql = $db->query("SELECT * FROM ".X_PREFIX."portal_templates WHERE id=$tid");
        while($t = $db->fetch_array($sql)) {
            $tname = $db->escape($t['name']);

            $statuson = $statusoff = '';
            switch($t['status']) {
                case 'on':
                    $statuson = $cheHTML;
                    break;
                default:
                    $statusoff = $cheHTML;
                    break;
            }

            $left = $center = $right = '';
            switch($t['direction']) {
                case 'left':
                    $left = $selHTML;
                    break;
                case 'center':
                    $center = $selHTML;
                    break;
                default:
                    $right = $selHTML;
                    break;
            }

            $t['displayorder'] = (int) $t['displayorder'];

            $sql2 = $db->query("SELECT * FROM ".X_PREFIX."templates WHERE name='$tname'");
            $tm = $db->fetch_array($sql2);
            $db->free_result($sql2);
            $tm['template'] = cdataOut(stripslashes($tm['template']));
            eval('echo "'.template('padmin_admin_blockedit').'";');
        }
        $db->free_result($sql);
    }

    if (onSubmit('blockeditsubmit')) {
        $dbname = postedVar('name');
        $dbnewtemplate = $db->escape(addslashes(postedVar('newtemplate', '', FALSE, FALSE)));
        $newdirection = ($newdirection == 'left') ? 'left' : ($newdirection == 'center' ? 'center' : 'right');
        $newstatus = ($newstatus == 'on') ? 'on' : 'off';
        $newdisplayorder = getInt('newdisplayorder', 'r');
        $id = getInt('id', 'r');
        $db->query("UPDATE ".X_PREFIX."portal_templates SET
            direction='$newdirection',
            status='$newstatus',
            displayorder=$newdisplayorder
            WHERE id=$id"
        );

        $db->query("UPDATE ".X_PREFIX."templates SET template='$dbnewtemplate' WHERE name='$dbname'");
        echo '<br />';
        message($lang['portalbedited'], false, '', '', 'cp_portal.php?action=blocks&blocks=edit', true, false, true);
    }
}

if ($action == 'langinstall') {
    if (noSubmit('langsubmit')) {
        echo '<form action="cp_portal.php?action=langinstall" method="post"><div style="text-align: center;">';
        echo '<br />'.$lang['portal_lang_expl'].'<br /><b>'.$langfile.'.portal.php</b><br />';
        echo '<input class="submit" type="submit" name="langsubmit" value="'.$lang['textsubmitchanges'].'" />';
        echo '</div></form>';
    } else {
        if (installPortalTranslation($langfile)) {
            message($lang['langimportsuccess'], false, '', '', 'cp_portal.php', true, false, true);
        } else {
            error($lang['langimportfail'], FALSE);
        }
    }
}

end_time();
eval('echo "'.template('footer').'";');
?>