<?php
/**
 * Calendar System v2.0
 *  2006 John Briggs
 * http://www.xmbmods.com

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

// Event List by GuldantheWarlock  2008 XMB Garage (http://www.xmbgarage.com)

/*if (!defined('ROOT')) {
    define('ROOT', './forums/');
}*/

define('X_SCRIPT', 'eventlist.php');

require 'header.php';

loadtemplates(
'cal_events_list'
);

nav($lang['calendar_eventslist']);

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');

if (!function_exists('month2text')) {
    function month2text($num) {
        global $lang;
        
        $num = (int) $num;
        if ($num < 1 || $num > 12) {
            $num = 1;
        }
        
        $months = array(
            $lang['textjan'],
            $lang['textfeb'],
            $lang['textmar'],
            $lang['textapr'],
            $lang['textmay'],
            $lang['textjun'],
            $lang['textjul'],
            $lang['textaug'],
            $lang['textsep'],
            $lang['textoct'],
            $lang['textnov'],
            $lang['textdec']
        );
        
        return $months[$num-1];
    }
}

function makeMonthLinks($curmonth) {
    $links = array();
    for($i = 1;$i<=12;$i++) {
        if ($i == $curmonth) {
            $links[] = '<strong>'.month2text($i).'</strong>';
        } else {
            $links[] = '<a href="./eventlist.php?month='.$i.'">'.month2text($i).'</a>';
        }
    }
    return implode(' | ', $links);
}

eval('$css = "'.template('css').'";');

$month    = (isset($_GET['month']) && is_numeric($_GET['month'])) ? (int) $_GET['month'] : (int) date('n');
$eventid  = (isset($_GET['eventid']) && is_numeric($_GET['eventid'])) ? (int) $_GET['eventid'] : 0;
$curmonth = month2text($month);
$year     = date('Y');

$query  = $db->query("SELECT themes, special_event_color, special_event_effect FROM ".X_PREFIX."calendar");
$calset = $db->fetch_array($query);
$db->free_result($query);

$cal_seventcolor = ($calset['themes'] == $lang['texton']) ? (isset(${$calset['special_event_color']}) ? "${$calset['special_event_color']}" : '') : $calset['special_event_color'];

$eventlinks = makeMonthLinks($month);

if ($eventid > 0) {
    $query = $db->query("SELECT * FROM ".X_PREFIX."events WHERE id='$eventid'");
    $event = $db->fetch_array($query);
    $db->free_result($query);
    
    $heading = stripslashes($event['subject']);
    
    $events   = array();
    $events[] = '<center>'.stripslashes($event['subject']).'</center><br /><br />';
    $events[] = '<center><strong>Date:</strong> '.$event['eventday'].'</center><br /><br />';
    $events[] = stripslashes(postify(stripslashes($event['body']), 'no', 'no', 'yes', 'yes', 'yes', 'yes', 'yes'));
    $events   = implode("\n", $events);
} else {
    $events = array();
    $query  = $db->query("SELECT id, type, subject, eventday FROM ".X_PREFIX."events WHERE eventday LIKE '$curmonth%$year' AND membersonly='0' ORDER BY eventday ASC");
    while($event = $db->fetch_array($query)) {
        $date = explode(' ', str_replace(',', '', $event['eventday']));
        
        $pre = $suff = '';
        if ($event['type'] == 'special') {
	        switch($calset['special_event_effect']) {
		        case 'bold':
		            $pre  = '<span style="color: '.$cal_seventcolor.';"><strong>';
		            $suff = '</strong></span>';
		            break;
		        case 'italic':
		            $pre  = '<span style="color: '.$cal_seventcolor.';"><em>';
		            $suff = '</em></span>';
		            break;
		        case 'underline':
		            $pre  = '<span style="color: '.$cal_seventcolor.';text-decoration: underline;">';
		            $suff = '</span>';
		            break;
	        }
        }
        $events[] = '<a href="./eventlist.php?eventid='.$event['id'].'">'.$pre.stripslashes($event['subject']).$suff.'</a> ('.$event['eventday'].')';
    }
    $db->free_result($query);

    $events = implode("<br />\n", $events);
    $heading = 'Events for '.$curmonth;
}

echo $css;
if (false !== strpos($boardimg, ',')) {
    $flashlogo = explode(",",$boardimg);
    //check if it's an URL or just a filename
    $l = array();
    $l = parse_url($flashlogo[0]);
    if (!isset($l['scheme']) || !isset($l['host'])) {
        $flashlogo[0] = $imgdir.'/'.$flashlogo[0];
    }
    $logo = '<object type="application/x-shockwave-flash" data="'.$flashlogo[0].'" width="'.$flashlogo[1].'" height="'.$flashlogo[2].'"><param name="movie" value="'.$flashlogo[0].'" /><param name="AllowScriptAccess" value="never" /></object>';
} else {
    $l = array();
    $l = parse_url($boardimg);
    if (!isset($l['scheme']) || !isset($l['host'])) {
        $boardimg = $imgdir.'/'.$boardimg;
    }
    $logo = '<a href="index.php"><img src="'.$boardimg.'" alt="'.$bbname.'" border="0" /></a>';
}
eval('echo "'.template('cal_events_list').'";');
end_time();
eval('echo "'.template('footer').'";');
?>

</body>
</html>