<?php
/**
 * Name: Photo Gallery v2.0
 * Developed And Maintained By Steven Waters, John Briggs
 * Copyright (c) 2008, Steven Waters, John Briggs
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

require 'header.php';
require ROOT.'include/gallery.functions.inc.php';

loadtemplates(
'img_search',
'img_footer',
'img_error',
'img_search_results_row',
'misc_search_results',
'misc_search_results_none'
);

eval('$css = "'.template('css').'";');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM ".X_PREFIX."imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

nav('<a href="gallery.php">'.stripslashes($gsettings['title']).'</a>');
nav($lang['textsearch']);

eval('echo "'.template('header').'";');

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    gallery_error($lang['img_errorprivgallery']);
}

if ($gsettings['search'] != 'on') {
    gallery_error($lang['fnasorry']);
}

// This was 'borrowed' from the existing XMB search php code... Plagarism is patriotic!!
if (!isset($searchsubmit) && !isset($page)) {
    $restrict = '';
    switch ($self['status']) {
        case 'member':
            $restrict .= " a.who_view !='3' AND";
        case 'Moderator':
        case 'Super Moderator':
            $restrict .= " a.who_view != '2' AND";
        case 'Administrator':
        case 'Super Administrator':
            // no restrictions
            break;
        default:
            $restrict .= " a.who_view !='3' AND a.who_view != '2' AND a.view_list = '' AND a.password = '' AND";
            break;
    }

    $albumselect = '<select name="srchcid">'.'\n';
    $albumselect .= '<option value="all">'.$lang['img_textallalbumsandsubs'].'</option>\n';
    $queryfor = $db->query("SELECT cid, name FROM ".X_PREFIX."imgcats AS a WHERE $restrict sub=0 ORDER BY displayorder");
    while ($album = $db->fetch_array($queryfor)) {
        $albumselect .= '<option value="'.$album['cid'].'"> &raquo; '.stripslashes($album['name']).'</option>';
        $querysub = $db->query("SELECT cid, name FROM ".X_PREFIX."imgcats AS a WHERE $restrict sub='$album[cid]' ORDER BY displayorder");
        while ($sub = $db->fetch_array($querysub)) {
            $albumselect .= '<option value="'.$sub['cid'].'">&nbsp; &nbsp; &raquo; '.stripslashes($sub['name']).'</option>';
        }
        $albumselect .= '<option value="" disabled="disabled">&nbsp;</option>';
        $db->free_result($querysub);
    }
    $albumselect .= '</select>';
    $db->free_result($queryfor);
    eval('echo "'.template('img_search').'";');
} else {
    // This line modified to check for length of user name < 2 instead of < 3
    if (strlen($srchtxt) < 3 && strlen($srchuname) < 2) {
        gallery_error($lang['img_errornosearch']);
    }
    if ($searchsubmit || $page) {
        if (!isset($page)) {
            $page = 1;
            $offset = 0;
            $start = 0;
            $end = ((isset($ppp) && $ppp > 0) ? $ppp : (isset($postperpage) && $postperpage > 0 ? $postperpage : 20));
        } else {
            if ($page < 1) {
                $page = 1;
            }

            $offset = ($page-1) * ((isset($ppp) && $ppp > 0) ? $ppp : (isset($postperpage) && $postperpage > 0 ? $postperpage : 20));
            $start = $offset;
            $end = ((isset($ppp) && $ppp > 0) ? $ppp : (isset($postperpage) && $postperpage > 0 ? $postperpage : 20));
        }
        $sql = "SELECT count(i.iid), i.*, a.who_view AS who_view, a.view_list AS viewlist, a.password AS password FROM ".X_PREFIX."imgimages i, ".X_PREFIX."imgcats a WHERE i.cid=a.cid";

        if ($srchfrom == 0) {
            $srchfrom = time();
            $srchfromold = 0;
        } else {
            $srchfromold = $srchfrom;
        }
        $ext = array();

        $srchfrom = time() - $srchfrom;
        if ($srchtxt) {
            $sql .= " AND (i.name LIKE '%$srchtxt%' OR i.description LIKE '%$srchtxt%')";
            $ext[] = 'srchtxt='.$srchtxt;
        }
        if (!empty($srchuname)) {
            $sql .= " AND i.author='$srchuname'";
            $ext[] = 'srchuname='.$srchuname;
        }
        if ($srchcid != 'all' && !empty($srchcid)) {
            $sql .= " AND i.cid='$srchcid'";
            $ext[] = 'srchcid='.((int) $srchcid);
        }
        if ($srchfrom) {
            $sql .= " AND i.dateline >= '$srchfrom'";
            $ext[] = 'srchfrom'.((int) $srchfromold);
        }
        $sql .=" GROUP BY dateline ORDER BY dateline DESC LIMIT $start,$end";
        if (!isset($page) || $page < 1) {
            $pagenum = 2;
        } else {
            $pagenum = $page+1;
        }
        $querysrch = $db->query($sql);
        $results = 0;
        $results = $db->num_rows($querysrch);

        if (!empty($srchuname)) {
            $srchtxt = '\0';
        }
        $nextlink = '';
        $multipage = '';
        $searchresults = '';
        while ($post = $db->fetch_array($querysrch)) {
            $cidpw = isset($_COOKIE['albumpw'.$post['cid']]) ? $_COOKIE['albumpw'.$post['cid']] : '';
            $authorization = gallery_viewalbumperm($post['cid']);
            if (($post['password'] != '' && $post['password'] != $cidpw) && !X_ADMIN) {
                continue;
            }

            if ($authorization) {
                $iid = $post['iid'];
                $message = stripslashes($post['description']);
                $srchtxt = str_replace(array('_ ', ' _','% ', ' %'), '', $srchtxt);
                $position = strpos($message, $srchtxt, 0);
                $show_num = 100;
                $msg_leng = strlen($message);

                if ($position <= $show_num) {
                $min = 0;
                    $add_pre = '';
                } else {
                    $min = $position - $show_num;
                    $add_pre = '...';
                }

                if (($msg_leng - $position) <= $show_num) {
                    $max = $msg_leng;
                    $add_post = '';
                } else {
                    $max = $position + $show_num;
                    $add_post = '...';
                }

                $show = substr($message, $min, $max);
                $show = str_replace($srchtxt, '<b><i>'.$srchtxt.'</i></b>', $show);
                $show = postify($show, 'no', 'yes', 'yes', 'no', 'no', 'no');

                $date = gmdate($dateformat, $post['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
                $time = gmdate($timecode, $post['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
                $poston = $date.' '.$lang['textat'].' '.$time;
                $postby = $post['author'];

                $post['name'] = stripslashes(censor($post['name']));

                eval('$searchresults .= "'.template('img_search_results_row').'";');
            }
        }
    }
    if ($results == 0) {
        eval('$searchresults = "'.template('misc_search_results_none').'";');
    } elseif ($results == ((isset($ppp) && $ppp > 0) ? $ppp : (isset($postperpage) && $postperpage > 0 ? $postperpage : 20))) {
        // create a string containing the stuff to search for
        $ext = htmlspecialchars(implode('&', $ext));
        eval('$nextlink = "'.template('misc_search_nextlink').'";');
    }
    eval('echo "'.template('misc_search_results').'";');
}

eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>