<?php
/**
 * Name: Photo Gallery v2.0
 * Developed And Maintained By Steven Waters, John Briggs
 * Copyright (c) 2008, Steven Waters, John Briggs
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

require 'header.php';
require ROOT.'include/gallery.functions.inc.php';

loadtemplates(
'img_links',
'img_album',
'img_album_icon',
'img_album_list',
'img_album_tiles',
'img_textrules',
'img_albummultipage',
'img_album_links',
'forumdisplay_password',
'img_footer'
);

eval('$css = "'.template('css').'";');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM ".X_PREFIX."imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

$cid = (isset($cid) ? (int) $cid : 0);

//  Retrieve the album settings, store them in an array
if ($cid != 0) {
    $query = $db->query("SELECT * FROM ".X_PREFIX."imgcats WHERE cid = '$cid'");
    if ($db->num_rows($query) == 1) {
        $album = $db->fetch_array($query);
        $album['name'] = stripslashes($album['name']);
    } else {
        eval('echo "'.template('header').'";');
        gallery_error($lang['img_errornoalbum']);
    }
    $db->free_result($query);
} else {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errornoalbum']);
}

$query = $db->query("SELECT name FROM ".X_PREFIX."imgcats WHERE cid = '$album[sub]'");
if ($db->num_rows($query) == 1) {
    $owneralbum = $db->fetch_array($query);
    $ownername = stripslashes($owneralbum['name']);
} else {
    $ownername = '';
}
$db->free_result($query);

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivgallery']);
}

//  Check for permissions to view the album
if (!gallery_viewalbumperm($cid)) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivalbum']);
}

gallery_pwverify($album['password'], 'gallery_view_album.php?cid='.$cid, $cid, true);

nav('<a href=gallery.php>'.stripslashes($gsettings['title']).'</a>');
if (!empty($ownername)) {
    nav('<a href="gallery_view_album.php?cid='.$album['sub'].'" >'.$ownername.'</a>');
}
nav(stripslashes($album['name']));
eval('echo "'.template('header').'";');

// Get set up for paging
$end = $gsettings['thumbs_on_page'];
if (isset($page)) {
    $start = ($page-1) * $end;
} else {
    // Update the views for the album.
    $db->query("UPDATE ".X_PREFIX."imgcats SET views=views+1 WHERE cid='$cid'");
    $start = 0;
    $page = 1;
}

$imagerows = '';
$foundimage = false;

switch ($gsettings['display_images']) {
    case '2':
        //  If the display settings is 'icon'.
        $i = 0;

        if (!isset($page) || $page == 1) {
            // Display the subalbum folders first
            $query = $db->query("SELECT cid, name FROM ".X_PREFIX."imgcats WHERE sub=$cid ORDER BY $gsettings[album_order]");

            while ($subalbums = $db->fetch_array($query)) {
                //  Check for permissions to view the subalbum
                $authorization = gallery_viewalbumperm($subalbums['cid']);
                if ($authorization) {
                    $i = $i+1;
                    $break = '';
                    $name = stripslashes($subalbums['name']);
                    $link = 'gallery_view_album.php?action=view&amp;cid='.$subalbums['cid'];

                    $image = $db->query("SELECT i.url as url, i.thumb as thumb, t.height as height, t.width as width
                                FROM ".X_PREFIX."imgimages i LEFT JOIN ".X_PREFIX."imgthumbnails t ON i.iid=t.iid WHERE i.cid=$subalbums[cid] ORDER BY i.dateline ASC LIMIT 1");
                    $url = $db->fetch_array($image);
                    $db->free_result($image);
                    if (empty($url['thumb']) && empty($url['url'])) {
                        $thumb = '<a href="'.$link.'"><img src="'.$imgdir.'/imgfolder.gif" alt="'.$lang['img_textnoimages'].'" border="0" /></a>';
                        $resize = '';
                    } else {
                        if ($url['thumb'] != 'resize') {
                            $url = $url['thumb'];
                            $resize = gallery_resize($url,'thumb', $url['height'], $url['width']);
                        } else {
                            $url = $url['url'];
                            $resize = gallery_resize($url,'thumb');
                        }
                        $url = stripslashes($url);
                        $thumb = '<a href='.$link.'><img src='.$url.' alt='.$name.' border="0" '.$resize.' /></a>';
                        $name = $name.' '.$lang['img_textalbum'];
                    }
                    $foundimage = true;
                    if ($i == $gsettings['thumbs_on_row']) {
                        $i = 0;
                        $break = '</tr><tr>';
                    }
                    eval('$imagerows .= "'.template('img_album_icon').'";');
                }
            }
            $db->free_result($query);
        }
        // Now display the images for this album
        $query = $db->query("SELECT i.iid as iid, i.name as name, i.author as author, i.url as url, i.thumb as thumb, t.width as width, t.height as height
                    FROM ".X_PREFIX."imgimages i LEFT JOIN ".X_PREFIX."imgthumbnails t ON i.iid=t.iid WHERE i.cid=$cid ORDER BY i.$gsettings[image_order] LIMIT $start, $end");
        while ($image = $db->fetch_array($query)) {
            $break = '';
            $i = $i+1;
            $resize = '';
            if ($image['thumb'] != 'resize') {
                $url = $image['thumb'];
                $resize = gallery_resize($url, 'thumb', $image['height'], $image['width']);
            } else {
                $url = $image['url'];
                $resize = gallery_resize($url,'thumb');
            }
            $url = stripslashes($url);
            $name = stripslashes($image['name']);
            $link = 'gallery_image.php?action=view&amp;iid='.$image['iid'].'#pictop';
            $thumb = '<a href='.$link.'><img src="'.$url.'" alt="'.$name.'" border="0" '.$resize.' /></a>';
            $foundimage = true;

            if ($i == $gsettings['thumbs_on_row']) {
                $i = 0;
                $break = '</tr><tr>';
            }
            eval('$imagerows .="'.template('img_album_icon').'";');
        }
        if (!$foundimage) {
            $imagerows = '<td><div class="smalltxt">'.$lang['img_textnoimages'].'</div></td>';
        }
        $db->free_result($query);
        break;

    case '3':
        //  If the display settings is 'tiles'.
        $i = 0;

        if (!isset($page) || $page == 1) {
            // Display the subalbum folders first
            $query = $db->query("SELECT cid, name, description FROM ".X_PREFIX."imgcats WHERE sub=$cid ORDER BY $gsettings[album_order]");

            while ($subalbums = $db->fetch_array($query)) {
                //  Check for permissions to view the subalbum
                $authorization = gallery_viewalbumperm($subalbums['cid']);
                if ($authorization) {
                    $i = $i+1;
                    $break = '';
                    $name = stripslashes($subalbums['name']);
                    $desc = stripslashes($subalbums['description']);
                    $thumb = '<img src="'.$imgdir.'/imgfolder.gif" alt="'.$name.'" border="0" />';
                    $link = '<a href=gallery_view_album.php?cid='.$subalbums['cid'].'><font class="smalltxt"><b>'.$name.'</b></font></a>';
                    $foundimage = true;

                    if ($i == $gsettings['thumbs_on_row']) {
                        $i = 0;
                        $break = '</tr><tr>';
                    }
                    eval('$imagerows .= "'.template('img_album_tiles').'";');
                }
            }
            $db->free_result($query);
        }
        // Now display the images for this album
        $query = $db->query("SELECT i.iid as iid, i.name as name, i.description as description, i.url as url, i.thumb as thumb, t.width as width, t.height as height
                        FROM ".X_PREFIX."imgimages i LEFT JOIN ".X_PREFIX."imgthumbnails t ON i.iid=t.iid WHERE i.cid=$cid ORDER BY i.$gsettings[image_order] LIMIT $start, $end");

        while ($image = $db->fetch_array($query)) {
            $break = '';
            $i = $i+1;

            if ($image['thumb'] != 'resize') {
                $url = $image['thumb'];
                $resize = gallery_resize($url, 'thumb', $image['height'], $image['width']);
            } else {
                $url = $image['url'];
                $resize = gallery_resize($url,'thumb');
            }
            $url = stripslashes($url);
            $name = stripslashes($image['name']);
            $desc = stripslashes($image['description']);
            $thumb = '<img src="'.$url.'" alt="'.$name.'" border="0" '.$resize.' />';
            $link = '<a href=gallery_image.php?action=view&amp;iid='.$image['iid'].'#pictop><font class="smalltxt"><b>'.$name.'</b></font></a>';
            $foundimage = true;

            if ($i == $gsettings['thumbs_on_row']) {
                $i = 0;
                $break = '</tr><tr>';
            }
            eval('$imagerows .= "'.template('img_album_tiles').'";');
        }
        if (!$foundimage) {
            $imagerows = '<td><div class="smalltxt">'.$lang['img_textnoimages'].'</div></td>';
        }
        $db->free_result($query);
        break;
}

//rules
$rules = '';
if ($gsettings['rules']=='All' || $gsettings['rules']=='Category') {
    $rule_left = postify($gsettings['rule_left'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    $rule_right = postify($gsettings['rule_right'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    eval('$rules = "'.template("img_textrules").'";');
}

eval('echo "'.template('img_album').'";');

// See if we need the multipage
if ($page) {
    $start = ($page-1) *$end;
} else {
    $start = 0;
    $page = 1;
}

$query = $db->query("SELECT count(iid) FROM ".X_PREFIX."imgimages WHERE cid='$cid'");
$topicsnum = $db->result($query, 0);
$db->free_result($query);

$mpurl = 'gallery_view_album.php?cid='.$cid;
if (($multipage = multi($topicsnum, $end, $page, $mpurl)) === false) {
    $multipage = '';
} else {
    eval('echo "'.template('img_albummultipage').'";');
}

// Find the prior and next albums to create the paging links.
// If this is a subalbum, this will let you page other subalbums in this album.
// If this is an album, this will let you page other albums in the gallery.
$priornextdata = gallery_albums();
$sub = ($album['sub'] == 0 ? false : true);
$priorcid = '';
$priorname = '';
$priorfound = false;
$nextcid = '';
$nextname = '';
$nextfound = false;
for ($i=0; $i< count($priornextdata); $i++) {

    if (!$sub) {
        if ($priornextdata[$i]['sub'] == 0) {
            if (!$priorfound && $priornextdata[$i]['cid'] != $cid) {
                $priorcid = $priornextdata[$i]['cid'];
                $priorname = $priornextdata[$i]['name'];
            } elseif ($priornextdata[$i]['cid'] == $cid) {
                $priorfound = true;
            } elseif ($priorfound == true) {
                $nextcid = $priornextdata[$i]['cid'];
                $nextname = $priornextdata[$i]['name'];
                $nextfound = true;
            }
        }
    } elseif ($sub) {

        if ($album['sub'] == $priornextdata[$i]['sub']) {
            if (!$priorfound && $priornextdata[$i]['cid'] != $cid) {
                $priorcid = $priornextdata[$i]['cid'];
                $priorname = $priornextdata[$i]['name'];
            } elseif ($priornextdata[$i]['cid'] == $cid) {
                $priorfound = true;
            } elseif ($priorfound == true) {
                $nextcid = $priornextdata[$i]['cid'];
                $nextname = $priornextdata[$i]['name'];
                $nextfound = true;
            }
        }
    }

    if ($nextfound) {
        break;
    }
}

if ($priorfound && !empty($priorcid)) {
    $priorlink = '<a href="gallery_view_album.php?cid='.$priorcid.'"><img src="'.$imgdir.'/previous.gif" alt="'.$lang['img_textprior'].'" border="0" /> <font class="smalltxt"><b>'.$priorname.'</b></font></a>';
} else {
    $priorlink = '<img src="'.$imgdir.'/previous2.gif" alt="" border="0" />';
}

if ($nextfound) {
    $nextlink = '<a href="gallery_view_album.php?cid='.$nextcid.'"><font class="smalltxt"><b>'.$nextname.'</b></font> <img src="'.$imgdir.'/next.gif" alt="'.$lang['img_textnext'].'" border="0" /></a>';
} else {
    $nextlink = '<img src="'.$imgdir.'/next2.gif" alt="" border="0" />';
}

// Build the links
$displaylinks = array();

if (X_ADMIN) {
    $displaylinks[] = '<a href="gallery_admin.php">'.$lang['img_textadmin'].'</a>';
}

//  Check for permissions to add images
if (gallery_addimageperm($cid)) {
    $displaylinks[] = '<a href="gallery_image.php?action=add&amp;cid='.$album['cid'].'">'.$lang['img_textaddimage'].'</a>';
}

//  Check for permissions to upload images
if (gallery_uploadimageperm($cid)) {
    // Check for multi upload
    if ($gsettings['multi_upload'] == 'on') {
        $displaylinks[] = '<a href="gallery_image.php?action=multiupload&amp;cid='.$album['cid'].'">'.$lang['img_textuplimage'].'</a>';
    } else {
        $displaylinks[] = '<a href="gallery_image.php?action=upload&amp;cid='.$album['cid'].'">'.$lang['img_textuplimage'].'</a>';
    }
}

//  Check for permissions to album create link
if (gallery_createpermission()){
    if ($gsettings['member_subalbums'] == 'on' && $album['sub'] == '0') {
       $displaylinks[] = '<a href="gallery_user_album.php?action=createsubalbum&amp;cid='.$album['cid'].'">'.$lang['img_textnewsubalbum'].'</a>';
    }
}

// Check for permissions to edit or delete this album
if (!X_GUEST) {
    if (X_ADMIN || $album['author'] == $self['username']) {
        $displaylinks[] = '<a href="gallery_user_album.php?action=editalbum&amp;cid='.$album['cid'].'">'.$lang['img_texteditalbum'].'</a>';
        $displaylinks[] = '<a href="gallery_user_album.php?action=deletealbum&amp;cid='.$album['cid'].'">'.$lang['img_textdelalbum'].'</a>';
    }
}
$displaylinks = implode(' | ', $displaylinks);
eval('echo "'.template('img_album_links').'";');
eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>