<?php
/**
 * Name: Photo Gallery v2.0
 * Developed And Maintained By Steven Waters, John Briggs
 * Copyright (c) 2008, Steven Waters, John Briggs
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

require 'header.php';
require ROOT.'include/gallery.functions.inc.php';

loadtemplates(
'img_links',
'img_user_albums',
'img_user_editalbums',
'img_user_deletealbums',
'img_footer',
'img_user_subalbums',
'img_info',
'img_warn',
'img_error'
);

eval('$css = "'.template('css').'";');

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM ".X_PREFIX."imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivgallery']);
}

// If the cid is set, do a quick check for passwords.
if (isset($cid)) {
    $cid = (int) $cid;
    if (!gallery_viewalbumperm($cid)) {
        eval('echo "'.template('header').'";');
        gallery_error($lang['img_errorprivalbum']);
    }
    $query = $db->query("SELECT password FROM ".X_PREFIX."imgcats WHERE cid='$cid'");
    $password = $db->result($query, 0);
    $db->free_result($query);
    gallery_pwverify($password, 'gallery_user_album.php?action='.$action.'&amp;cid='.$cid, $cid, true);
}


nav('<a href=gallery.php>'.stripslashes($gsettings['title']).'</a>');
if ($action == 'createalbum') {
    nav($lang['img_textnewalbum']);
} elseif ($action == 'createsubalbum') {
    nav($lang['img_textnewsubalbum']);
} elseif ($action == 'editalbum') {
    nav($lang['img_texteditalbum']);
} elseif ($action == 'deletealbum') {
    nav($lang['img_textdelalbum']);
}

eval('echo "'.template('header').'";');

switch ($action) {
    case 'createalbum':
        //  Check to see if the user has permissions to be here
        if (!gallery_createpermission()) {
            gallery_error($lang['img_errornoalbumcreate']);
        }

        if (!isset($_POST['albumsubmit'])) {
            // This will display the user create album screen
            eval('echo "'.template('img_user_albums').'";');

        } elseif ($_POST['albumsubmit']) {
            // Validate the name and url
            if (!strlen(trim($name_new)) > 0) {
                gallery_error($lang['img_errornoalbumname']);
            }

            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);

            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));

            // Set the display order for the new album
            $query = $db->query("SELECT displayorder FROM ".X_PREFIX."imgcats ORDER BY displayorder DESC LIMIT 0,1");

            if ($db->num_rows($query) == 1) {
                $displayorder_new = $db->result($query, 0);
            } else {
                $displayorder_new = 0;
            }

            $displayorder_new = $displayorder_new + 1;

            $db->query("INSERT INTO ".X_PREFIX."imgcats( cid, name, description, status, displayorder, sub,
                author, creator_only ) VALUES ( '', '$name_new', '$desc_new', 'on', '$displayorder_new',
                '0', '$self[username]', '$gsettings[creator_only]')");
            $cid = $db->insert_id();

            gallery_info($lang['img_infoalbummsg'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'createsubalbum':
        //  Create an subalbum
        //  Check to see if the user has permissions to be here
        if (!gallery_createpermission()) {
            gallery_error($lang['img_errornoalbumcreate']);
        }

        if (X_ADMIN || $gsettings['member_subalbums'] == 'on') {
            // good to go
        } else {
            gallery_error($lang['img_errornoalbumcreate']);
        }

        if (!isset($_POST['subalbumsubmit'])) {
            $query = $db->query("SELECT name FROM ".X_PREFIX."imgcats WHERE cid = '$cid'");
            if ($db->num_rows($query) == 1) {
                $album = $db->fetch_array($query);
                $albumname = stripslashes($album['name']);
            } else {
                gallery_error($lang['img_errornoalbum']);
            }
            $db->free_result($query);

            // This will display the user create album screen
            eval('echo "'.template('img_user_subalbums').'";');

        } elseif ($_POST['subalbumsubmit']) {
            if (!strlen(trim($name_new)) > 0) {
                gallery_error($lang['img_errornoalbumname']);
            }

            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);

            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));

            // Set the display order for the new album
            $query = $db->query("SELECT displayorder FROM ".X_PREFIX."imgcats WHERE sub = '$cid' ORDER BY
                displayorder DESC LIMIT 0,1");

            if ($db->num_rows($query) == 1) {
                $displayorder_new = $db->result($query, 0);
            } else {
                $displayorder_new = 0;
            }
            $db->free_result($query);

            $displayorder_new = $displayorder_new + 1;

            $db->query("INSERT INTO ".X_PREFIX."imgcats( cid, name, description, status, displayorder, sub,
                author, creator_only ) VALUES ( '', '$name_new', '$desc_new', 'on', '$displayorder_new',
                '$cid', '$self[username]', '$gsettings[creator_only]')");
            $cid = $db->insert_id();

            gallery_info($lang['img_infoalbummsg'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'editalbum':
        // Edit an album
        // Permissions checks.
        $query = $db->query("SELECT * FROM ".X_PREFIX."imgcats WHERE cid = '$cid'");
        if ($db->num_rows($query) == 1) {
            $album = $db->fetch_array($query);
        } else {
            gallery_error($lang['img_errornoalbum']);
        }
        $db->free_result($query);

        //  Check for permissions to edit this album.
        if (X_ADMIN || $album['author'] == $self['username']) {
            // good to go
        } else {
            gallery_error($lang['img_errornoalbumupdate']);
        }
        if (!isset($_POST['editalbumsubmit'])) {
            $album['closed'] = ($album['closed'] == 'yes') ? 'yes' : 'no';

            $album['name'] = stripslashes($album['name']);
            $album['description'] = stripslashes($album['description']);
            $closenew = '';
            if ($album['closed'] == 'yes') {
                $closenew = 'checked';
            }

            // This will display the user edit album screen
            eval('echo "'.template('img_user_editalbums').'";');

        } elseif ($_POST['editalbumsubmit']) {
            if (!strlen(trim($name_new)) > 0) {
                gallery_error($lang['img_errornoalbumname']);
            }

            $name_new = checkInput($name_new, 'no', 'no', '', false);
            $desc_new = checkInput($desc_new, 'no', 'no', '', false);
            $name_new = addslashes(trim($name_new));
            $desc_new = addslashes(trim($desc_new));
            if (isset($closenew)) {
                $closenew = 'yes';
            } else {
                $closenew = 'no';
            }
            $db->query("UPDATE ".X_PREFIX."imgcats SET name='$name_new', description = '$desc_new', closed = '$closenew' WHERE cid='$cid'");

            gallery_info($lang['img_infoalbumupd'],'gallery_view_album.php?cid='.$cid);
        }
        break;

    case 'deletealbum':
        //  Delete an album
        if (!isset($_POST['deletealbumsubmit'])) {
            $query = $db->query("SELECT * FROM ".X_PREFIX."imgcats WHERE cid = '$cid'");
            if ($db->num_rows($query) == 1) {
                $album = $db->fetch_array($query);
                $db->free_result($query);
            } else {
                gallery_error($lang['img_errornoalbum']);
            }

            //  Check for permissions to delete this album.
            if (X_ADMIN || $album['author'] == $self['username']) {
                // good to go
            } else {
                gallery_error($lang['img_errornoalbumupdate']);
            }

            // This will display a message to warn the user
            $message = $lang['img_infoconfirmdelalbum'];
            eval('echo "'.template('img_warn').'";');
            eval('echo "'.template('img_user_deletealbums').'";');

        } elseif ($_POST['deletealbumsubmit']) {
            $query = $db->query("SELECT * FROM ".X_PREFIX."imgcats WHERE cid = '$cid'");
            if ($db->num_rows($query) == 1) {
                $album = $db->fetch_array($query);
                $db->free_result($query);
            } else {
                gallery_error($lang['img_errornoalbum']);
            }

            //  Check for permissions to delete this album.
            if (!X_ADMIN || $album['author'] != $self['username']) {
                gallery_error($lang['img_errornoalbumupdate']);
            }

            // Remove all of the album from the database.
            gallery_deletealbumdb($cid);
            gallery_info($lang['img_infoalbumdel'],'gallery.php');
        }
        break;
}

eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>