<?php
/**
 * Name: Photo Gallery v2.0
 * Developed And Maintained By Steven Waters, John Briggs
 * Copyright (c) 2008, Steven Waters, John Briggs
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

if (!((bool) ini_get('safe_mode'))) {
    set_time_limit(1000);
}

require 'header.php';
require ROOT.'include/gallery.functions.inc.php';

loadtemplates('');

if (!X_SADMIN) {
    eval('$css = "'.template('css').'";');
    error($lang['superadminonly']);
}

// BEGIN CONFIGURATION SETTINGS
$hackname = 'Photo Gallery v2.0'; // Hack Name
$fontstyle = 'Tahoma'; // Font Type
$fontsize = '10px'; // Font Size
$txtcolor = '#000000';  // Text Color
$bgcolor = '#EDF0F7';  // Background Color
$bordercolor = '#C4C8D4';  // Border Color
$altbg1 = '#EDF0F7';  // Alternate Color 1
$altbg2 = '#FFFFFF';  // Alternate Color 2
$tablewidth = '400';  // Table Width
$borderwidth = '1';  // Border Width
$tablespace = '5';  // Table Spacing
$usetemplatefile = 'yes';  // Does this hack use a template (.xmb) file?  yes or no
$templatefilename = 'img_templates.xmb';  // Template file name, if any is used
$checkfiles = array(
    'lang/English.gallery.php',
    'gallery.php',
    'gallery_admin.php',
    'gallery_comments.php',
    'include/gallery.functions.inc.php',
    'gallery_image.php',
    'gallery_misc.php',
    'gallery_search.php',
    'gallery_stats.php',
    'gallery_user_album.php',
    'gallery_view_album.php',
    'gallery_view_comments.php'
    );  // Files that need to be uploaded
// END CONFIGURATION SETTINGS
?>
<html>
<head>
<title><?php echo $hackname?> Installer</title>
<style type="text/css">
<!--
body { scrollbar-base-color: #EDF0F7; scrollbar-arrow-color: #FFFFFF }
a { color: #000000; text-decoration: none }
a:hover { text-decoration: underline }
.header { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: bold; background-color: #FFFFFF }
.tablerow { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: normal }
textarea, select, input, object { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: normal; background-color: #EDF0F7 }
//-->
</style>
</head>
<body text="<?php echo $txtcolor?>" bgcolor="<?php echo $bgcolor?>" link="<?php echo $bgcolor?>">
<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" align="center">
<tr><td align="center" valign="center">

<?php
if (!isset($_POST['confirmsubmit']) && !isset($_POST['licensesubmit']) && !isset($_POST['installsubmit']) && !isset($_POST['removesubmit'])) {
    $removebutton = '';
    if (file_exists("gallery.php")) {
        $removebutton = '<input type="submit" name="removesubmit" value="Uninstall" />';
    }
    ?>
    <form method="post" action="gallery_upgrade.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong><?php echo $hackname?></strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    Thanks for choosing to install another hack by XMBMods.com!
    <br /><br /><br />
    This part of the installation will create all necessary database tables and templates, insert any necessary data, and configure any necessary settings.<br /><br /><br />
    Before continuing, be sure that you have completed the instructions provided in the hack installation text file.<br /><br /><br />
    <input type="submit" name="confirmsubmit" value="Install" /> <?php echo $removebutton?>
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['removesubmit'])) {
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcats");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimages");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgsettings");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgvotes");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcomments");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimagedata");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgthumbnails");
    $db->query("DELETE FROM ".$tablepre."templates WHERE name LIKE 'img_%'");
    $db->query("DELETE FROM ".$tablepre."templates WHERE name=''");
    ?>
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>Uninstall</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    <strong><?php echo $hackname?></strong> has been successfully removed!<br /><br /><br />
    To complete the uninstall, please delete the file <strong>gallery_upgrade.php</strong> and <strong>img_templates.xmb</strong>.
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    <?php
}

if (isset($_POST['confirmsubmit'])) {
    ?>
    <form method="post" action="gallery_upgrade.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>Important!</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    As with any hack, we recommend backing up your current database, templates, and files.<br /><br /><br />
    This safety precaution can mean the difference between a successful installation or an evening full of headaches.<br /><br /><br />
    Did you make a backup of your database and templates?<br /><br /><br />
    <input type="submit" name="licensesubmit" value="Yes"> <input type="submit" name="cancelsubmit" value="No" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['licensesubmit'])) {
    ?>
    <form method="post" action="gallery_upgrade.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>License Agreement</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    This hack and all code contained within are released under the GNU GPL license.<br /><br /><br />
    All copyright information, found within this hack, may not be removed for any reason and must remain visible at all times.<br /><br /><br />
    Do you agree to these terms?<br /><br /><br />
    <input type="submit" name="installsubmit" value="Agree"> <input type="submit" name="cancelsubmit" value="Disagree" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['installsubmit'])) {
    ?>
    <form method="post" action="gallery_upgrade.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong><?php echo $hackname?></strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    <?php
    for ($i = 0; $i < count($checkfiles); $i++) {
        if (!file_exists($checkfiles[$i])) {
            echo '<strong>Error!</strong> The installation has been halted.<br /><br /><br />';
            echo 'The file, <strong>'.$checkfiles[$i].'</strong>, does not exist.<br /><br /><br />';
            echo 'Please upload the file and click restart to continue.<br /><br /><br />';
            echo '<input type="submit" name="cancelsubmit" value="Restart" />';
            exit;
        }
    }
    ?>
    Now installing! Please be patient as this process may take a few minutes.<br /><br /><br />
    <?php

    require_once('include/gallery.functions.inc.php');
    // BEGIN
    echo "Altering table <strong>".$tablepre."imgcats</strong> and inserting any necessary data.<br /><br />";
    $db->query("ALTER TABLE ".$tablepre."imgcats
      ADD INDEX `author` (`author`),
      ADD INDEX `sub` (`sub`),
      ADD INDEX `name` (`name`),
      ADD INDEX `displayorder` (`displayorder`)
    ");

    echo "Altering table <strong>".$tablepre."imgimages</strong> and inserting any necessary data.<br /><br />";
    $db->query("ALTER TABLE ".$tablepre."imgimages
      ADD INDEX `author` (`author`),
      ADD INDEX `cid` (`cid`),
      ADD INDEX `name` (`name`),
      ADD INDEX `dateline` (`dateline`)
    ");

    echo "Altering table <strong>".$tablepre."imgcomments</strong> and inserting any necessary data.<br /><br />";
    $db->query("ALTER TABLE ".$tablepre."imgcomments
      ADD INDEX `iid` (`iid`),
      ADD INDEX `dateline` (`dateline`),
      ADD INDEX `cid` (`cid`)
    ");

    echo "Creating table <strong>".$tablepre."imgimagedata</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimagedata");
    $db->query("CREATE TABLE ".$tablepre."imgimagedata (
      `iid` smallint(6) DEFAULT '0' NOT NULL,
      `cid` smallint(6) DEFAULT '0' NOT NULL,
      `height` int(3) DEFAULT '0' NOT NULL,
      `width` int(3) DEFAULT '0' NOT NULL,
      `filetype` VARCHAR(120) NOT NULL default '',
      `imagedata` LONGBLOB NOT NULL,
      PRIMARY KEY (`iid`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgthumbnails</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgthumbnails");
    $db->query("CREATE TABLE ".$tablepre."imgthumbnails (
      `iid` smallint(6) DEFAULT '0' NOT NULL,
      `cid` smallint(6) DEFAULT '0' NOT NULL,
      `height` int(3) DEFAULT '0' NOT NULL,
      `width` int(3) DEFAULT '0' NOT NULL,
      `filetype` VARCHAR(120) NOT NULL default '',
      `thumbnail` MEDIUMBLOB NOT NULL,
      PRIMARY KEY (`iid`)
    ) ");
    // END
    // BEGIN INSERTING UPLOADED THUMBNAILS
    echo "Moving thumbnail images to the database.<br /><br />";
    $total = 0;
    $totalmoved = 0;
    $query = $db->query("SELECT thumb, iid, cid FROM ".$tablepre."imgimages WHERE thumb!='resize'");
    while ($images = $db->fetch_array($query)) {
        $total = $total + 1;
        $images['thumb'] = stripslashes($images['thumb']);
        if (file_exists($images['thumb'])) {
            $size = GetImageSize($images['thumb']);
            $width = $size[0];
            $height = $size[1];
            $imagetype = $size[2];
            $imagedata = addslashes(fread(fopen($images['thumb'], 'rb'), filesize($images['thumb'])));
            $imagetype = image_type_to_mime_type($imagetype);
            $db->query("INSERT INTO ".X_PREFIX."imgthumbnails SET iid='$images[iid]', cid='$images[cid]', width='$width', height='$height', filetype='$imagetype', thumbnail='$imagedata'");
            $thumb_url = 'gallery.php?action=viewthumb&amp;iid='.$images['iid'].'&amp;cid='.$images['cid'];
            $thumb_url = addslashes($thumb_url);
            $db->query("UPDATE ".X_PREFIX."imgimages SET thumb='$thumb_url' WHERE iid='$images[iid]' ");
            $totalmoved = $totalmoved + 1;
        }
    }
    if ($total != $totalmoved) {
        echo "    <strong>The upgrade was not able to move all the thumbnail images for all the uploaded images</strong>.<br /><br />";
    }
    $db->free_result($query);
    // END INSERTING UPLOADED THUMBNAILS
    // BEGIN CREATING THUMBNAILS FOR UPLOADED IMAGES THAT HAD NO THUMBNAILS
    echo "Creating missing thumbnail images for uploading photos.<br /><br />";
    $total = 0;
    $totalmoved = 0;
    $query = $db->query("SELECT url, iid, cid FROM ".$tablepre."imgimages WHERE thumb='resize' AND upload='yes'");
    while ($images = $db->fetch_array($query)) {
        $total = $total + 1;
        $images['url'] = stripslashes($images['url']);
        if (file_exists($images['url'])) {
            gallery_createthumbrow($images['url'], $images['iid'], $images['cid']);
            $totalmoved = $totalmoved + 1;
        }
    }
    if ($total != $totalmoved) {
        echo "    <strong>The upgrade was not able to create thumbnail images for all the uploaded images</strong>.<br /><br />";
    }
    $db->free_result($query);
    // END CREATING THUMBNAILS FOR UPLOADED IMAGES THAT HAD NO THUMBNAILS
    // BEGIN INSERTING UPLOADED IMAGES
    echo "Moving uploaded images to the database.<br /><br />";
    $total = 0;
    $totalmoved = 0;
    $query = $db->query("SELECT url, iid, cid FROM ".$tablepre."imgimages WHERE upload='yes'");
    while ($images = $db->fetch_array($query)) {
        $total = $total + 1;
        $images['url'] = stripslashes($images['url']);
        if (file_exists($images['url'])) {
            $size = GetImageSize($images['url']);
            $width = $size[0];
            $height = $size[1];
            $imagetype = $size[2];
            $imagedata = addslashes(fread(fopen($images['url'], 'rb'), filesize($images['url'])));
            $imagetype = image_type_to_mime_type($imagetype);
            $db->query("INSERT INTO ".X_PREFIX."imgimagedata SET iid='$images[iid]', cid='$images[cid]', width='$width', height='$height', filetype='$imagetype', imagedata='$imagedata'");
            $url = 'gallery.php?action=viewimage&amp;iid='.$images['iid'].'&amp;cid='.$images['cid'];
            $url = addslashes($url);
            $db->query("UPDATE ".X_PREFIX."imgimages SET url='$url' WHERE iid='$images[iid]'");
            $totalmoved = $totalmoved + 1;
        }
    }
    if ($total != $totalmoved) {
        echo "    <strong>The upgrade was not able to move all the uploaded images</strong>.<br /><br />";
    }
    $db->free_result($query);
    // END INSERTING UPLOADED IMAGES
    // BEGIN UPDATING SETTINGS TABLE
    echo "Updating <strong>".$tablepre."imgsettings</strong> and any necessary data.<br /><br />";
    $old_resize = $db->result($db->query("SELECT resize_thumb FROM ".$tablepre."imgsettings"), 0);
    if ($old_resize == 'yes') {
        $resize = 'no';
    } else {
        $resize = 'yes';
    }
    $db->query("UPDATE ".$tablepre."imgsettings SET resize_thumb = '$resize' ");
    echo "Updating <strong>".$tablepre."imgsettings</strong> removing unnecessary columns.<br /><br />";
    $db->query("ALTER TABLE ".$tablepre."imgsettings DROP COLUMN upl_folder ");
    // END UPDATING SETTINGS TABLE
    // BEGIN TEMPLATES
    if ($usetemplatefile == 'yes') {
        echo "Creating any necessary templates.<br /><br />";
        $db->query("DELETE FROM ".$tablepre."templates WHERE name LIKE 'img_%'");

        $filesize = @filesize($templatefilename);
        $fp = @fopen($templatefilename, 'r');
        $templatesfile = @fread($fp, $filesize);
        @fclose($fp);
        $templates = explode("|#*XMB TEMPLATE FILE*#|", $templatesfile);
        while (list($key,$val) = each($templates)) {
            $template = explode("|#*XMB TEMPLATE*#|", $val);
            if (isset($template[1])) {
                $template[1] = addslashes($template[1]);
                $db->query("INSERT INTO ".$tablepre."templates (id, name, template) VALUES ('', '".addslashes($template[0])."', '".addslashes($template[1])."')");
            }
        }
        $db->query("DELETE FROM ".$tablepre."templates WHERE name=''");
    }
    // END TEMPLATES
    ?>
    <br />
    The installation of <strong><?php echo $hackname?></strong> is now complete!<br /><br /><br />
    Please delete files <strong>gallery_upgrade.php</strong> and <strong>img_templates.xmb</strong> and click finish to continue.<br /><br /><br />
    <input type="button" onclick="location.href='gallery.php'" value="Finish" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
    @unlink("img_templates.xmb");
    @unlink("gallery_install.php");
    @unlink("gallery_update.php");
}
?>
<br />
<span class="tablerow"><strong><a href="http://www.xmbmods.com" target="_blank">XMBMods.com</a></strong> &copy; 2005 - 2006</span>
</td>
</tr>
</table>
</form>
</body>
</html>