<?php

/*  File Id: avatar.php, v1.0 */
/*
    Random Avatar v1.0

    Designed For Use With XMB 1.9.8

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('IMGDIR', './'); // Set to path of images, relative to file.

function getExt($file) {
    $parts = explode('.', $file);
    return $parts[count($parts)-1];
}

$i = 0;
$images = array();

if ($dh = opendir(IMGDIR)) {
    while($f = readdir($dh)) {
        $image = array();
        if ($f != '.' && $f != '..') {
            $image = getExt($f);
            if ($image != 'php' && $image != 'html') {
                $images[$i] = array($f, $image);
            }
            $i++;
        }
    }
}
closedir($dh);

if (isset($_GET['debug']) && (int)$_GET['debug'] == 1) {
    echo nl2br(print_r($images, true));
    exit;
} 

$rand = -1;
while(!isset($images[$rand])) {
    $rand = rand(0, count($images)-1);
}

$type = ($images[$rand][1] == 'jpg') ? 'jpeg' : $images[$rand][1];
header("Content-Type: image/".$type);
header("Location: ".IMGDIR.$images[$rand][0]);
exit;
?>