<?php
/*
    Stats Calendar v1.1
     2006 John Briggs. All rights reserved.
    http://www.xmbmods.com

    This program is free software; you can redistribute it AND/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');

loadtemplates('misc_feature_notavailable');

$view = (isset($view) && $view == 'yearly') ? 'yearly' : '';
switch ($view) {
    case 'yearly':
        nav('<a href="statscal.php">'.$lang['statscal'].'</a>');
        nav($lang['statscalyearlytotal']);
        break;
    default:
        nav($lang['statscal']);
        break;
}

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');

if ($SETTINGS['stats'] == 'off') {
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

$MonthNames = array('', $lang['textjan'], $lang['textfeb'], $lang['textmar'], $lang['textapr'], $lang['textmay'], $lang['textjun'], $lang['textjul'], $lang['textaug'], $lang['textsep'], $lang['textoct'], $lang['textnov'], $lang['textdec']);
$DayNames = array('', $lang['statscalsun'], $lang['statscalmon'], $lang['statscaltue'], $lang['statscalwed'], $lang['statscalthu'], $lang['statscalfri'], $lang['statscalsat']);

if ($view == 'yearly') {
    $mempx = .1;
    $threadpx = .1;
    $postpx = .1;
} else {
    $mempx = .4;
    $threadpx = .4;
    $postpx = .4;
}

$tmOffset = ($timeoffset * 3600) + ($addtime * 3600);

$query = $db->query("SELECT regdate FROM $table_members ORDER BY regdate ASC LIMIT 1");
while ($member = $db->fetch_array($query)) {
    $StartDate  = $member['regdate'];
    $StartMonth = gmdate("n", $StartDate + $tmOffset);
    $StartYear  = gmdate("Y", $StartDate + $tmOffset);
}
$db->free_result($query);

$CurrentDate = $onlinetime;
$CurrentDay = gmdate("d", $CurrentDate + $tmOffset);
$CurrentMonth = gmdate("n", $CurrentDate + $tmOffset);
$CurrentYear = gmdate("Y", $CurrentDate + $tmOffset);

$month = empty($month) || $month < 1 || $month > 12 ? $CurrentMonth : $month;
$year = empty($year) ? $CurrentYear : $year;

$MinDate = gmmktime(0, 0, 0, $month, 1, $year) - $tmOffset;
$dim = gmdate("t", $MinDate + $tmOffset);
$MaxDate = gmmktime(0, 0, 0, $month, $dim, $year) - $tmOffset;

if ($MinDate < $StartDate) {
    $month = $StartMonth;
    $year = $StartYear;
} elseif ($MaxDate > $CurrentDate) {
    $month = $CurrentMonth;
    $year = $CurrentYear;
}

$MonthYear = gmmktime(0, 0, 0, $month, 1, $year) - $tmOffset;
$dim = gmdate("t", $MonthYear + $tmOffset);
$FirstDay = gmdate("w", $MonthYear + $tmOffset) + 1;

$newmembers = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$newthreads = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
$newposts = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

if ($view == 'yearly') {
    $FirstMonth = $year == $StartYear ? $StartMonth : 1;
    $LastMonth = $year == $CurrentYear ? $CurrentMonth : 12;

    $calendar = "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
    $calendar .= "<tr><td bgcolor='$bordercolor'>\n";

    $calendar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'>\n";
    $calendar .= "<tr class='category'><td colspan='7' align='center'><strong><font color='$cattext'>$year $lang[statscalmonthtotal]</font></strong></td></tr>\n";

    $DisplayMonth = 1;

    $calmouseover = " onmouseover='this.style.backgroundColor=\"$altbg2\";' onmouseout='this.style.backgroundColor=\"$altbg1\";'";

    for ($i = 1; $i < $FirstMonth; $i++) {
        if ($DisplayMonth == 1) {
            $calendar .= "<tr class='tablerow'>\n";
        }

        $calendar .= "<td bgcolor='$altbg1' width='25%' $calmouseover>\n";
        $calendar .= "<table width='100%' cellspacing='0' cellpadding='1'>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'><strong>$MonthNames[$i] $year</strong></td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "</table></td>\n";

        if ($DisplayMonth == 4) {
            $calendar .= "</tr>\n";
            $DisplayMonth = 1;
        } else {
            $DisplayMonth++;
        }
    }

    for ($month = $FirstMonth; $month <= $LastMonth; $month++) {
        $firstdate = gmmktime(0, 0, 0, $month, 1, $year) - $tmOffset;
        $lastdate  = gmmktime(23, 59, 59, $month, $dim, $year) - $tmOffset;

        $query = $db->query("SELECT COUNT(*) as Total FROM $table_members WHERE regdate >= '$firstdate' AND regdate <= '$lastdate'");
        while ($member = $db->fetch_array($query)) {
            $newmembers[$month] = $member['Total'];
        }
        $db->free_result($query);

        $query = $db->query("SELECT t.tid, min(p.pid), p.dateline FROM $table_threads t, $table_posts p WHERE t.tid = p.tid AND dateline >= '$firstdate' AND dateline <= '$lastdate' GROUP BY t.tid");
        while ($thread = $db->fetch_array($query)) {
            $newthreads[$month]++;
        }
        $db->free_result($query);

        $query = $db->query("SELECT COUNT(*) as Total FROM $table_posts WHERE dateline >= '$firstdate' AND dateline <= '$lastdate'");
        while ($post = $db->fetch_array($query)) {
            $newposts[$month] = $post['Total'];
        }
        $db->free_result($query);

        if ($DisplayMonth == 1) $calendar .= "<tr class='tablerow'>\n";

        if ($year == $CurrentYear && $month == $CurrentMonth)
            $calendar .= "<td bgcolor='$altbg2' width='25%' >\n";
        else
            $calendar .= "<td bgcolor='$altbg1' width='25%' $calmouseover >\n";

        $calendar .= "<table width='100%' cellspacing='0' cellpadding='1'>\n";
        $calendar .= "<tr class='tablerow'><td align='center' colspan='3'>\n";
        $calendar .= "<a href='statscal.php?month=$month&amp;year=$year'><strong>[$MonthNames[$month] $year]</strong></a>\n";
        $calendar .= "</td></tr>\n";
        $calendar .= "<tr class='tablerow'><td align='center' colspan='3'>&nbsp;</td></tr>\n";

        $memwidth  = ($newmembers[$month] * $mempx) . "px";
        $calendar .= "<tr class='tablerow'>";
        $calendar .= "<td align='left'>$lang[statscalmembers]</td><td align='right'>$newmembers[$month]</td>";
        $calendar .= "<td align='left' width='95%'>";
        $calendar .= "&nbsp;<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar.gif' width='$memwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
        $calendar .= "</td>";
        $calendar .= "</tr>";

        $threadwidth = ($newthreads[$month] * $threadpx) . "px";
        $calendar .= "<tr class='tablerow'>";
        $calendar .= "<td align='left'>$lang[statscalthreads]</td><td align='right'>$newthreads[$month]</td>";
        $calendar .= "<td align='left' width='95%'>";
        $calendar .= "&nbsp;<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar.gif' width='$threadwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
        $calendar .= "</td>";
        $calendar .= "</tr>";

        $postwidth = ($newposts[$month] * $postpx) . "px";
        $calendar .= "<tr class='tablerow'>";
        $calendar .= "<td align='left'>$lang[statscalposts]</td><td align='right'>$newposts[$month]</td>";
        $calendar .= "<td align='left' width='95%'>&nbsp;";
        $calendar .= "<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar.gif'   width='$postwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
        $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
        $calendar .= "</td>";
        $calendar .= "</tr>";

        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "</table>";
        $calendar .= "</td>\n";

        if ($DisplayMonth == 4) {
            $calendar .= "</tr>\n";
            $DisplayMonth = 1;
        } else {
            $DisplayMonth++;
        }
    }

    for ($i = $LastMonth + 1; $i <= 12; $i++) {
        if ($DisplayMonth == 1) $calendar .= "<tr class='tablerow'>\n";
        $calendar .= "<td bgcolor='$altbg1' width='25%' $calmouseover>\n";
        $calendar .= "<table width='100%' cellspacing='0' cellpadding='1'>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'><strong>$MonthNames[$i] $year</strong></td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "<tr class='ctrtablerow'><td colspan='3'>&nbsp;</td></tr>\n";
        $calendar .= "</table></td>\n";

        if ($DisplayMonth == 4) {
            $calendar .= "</tr>\n";
            $DisplayMonth = 1;
        } else
            $DisplayMonth++;
    }

    $calendar .= "</table>\n";
    $calendar .= " </td></tr></table><br />\n";
} else {
    $firstdate = gmmktime(0, 0, 0, $month, 1, $year) - $tmOffset;
    $lastdate  = gmmktime(23, 59, 59, $month, $dim, $year) - $tmOffset;

    $query = $db->query("SELECT regdate FROM $table_members WHERE regdate >= '$firstdate' and regdate <= '$lastdate'");
    while ($member = $db->fetch_array($query)) {
        $regdate = $member['regdate'] + ($timeoffset * 3600) + ($addtime * 3600);
        $regDay = gmdate("j", $regdate);
        $newmembers[$regDay]++;
    }
    $db->free_result($query);

    $query = $db->query("SELECT t.tid, min(p.pid), p.dateline FROM $table_threads t, $table_posts p WHERE t.tid = p.tid and dateline >= '$firstdate' and dateline <= '$lastdate' group by t.tid");
    while ($thread = $db->fetch_array($query)) {
        $dateline = $thread['dateline'] + ($timeoffset * 3600) + ($addtime * 3600);
        $threadDay = gmdate("j", $dateline);
        $newthreads[$threadDay]++;
    }
    $db->free_result($query);

    $query = $db->query("SELECT dateline FROM $table_posts WHERE dateline >= '$firstdate' AND dateline <= '$lastdate'");
    while ($post = $db->fetch_array($query)) {
        $dateline = $post['dateline'] + ($timeoffset * 3600) + ($addtime * 3600);
        $postDay  = gmdate("j", $dateline);
        $newposts[$postDay]++;
    }
    $db->free_result($query);

    $DisplayDay = 1;

    $calendar = "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
    $calendar .= "<tr><td bgcolor='$bordercolor'>\n";
    $calendar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'> \n";
    $calendar .= "<tr class='header'><td colspan='7' align='center'>$MonthNames[$month] $year</td></tr>\n";
    $calendar .= " <tr>\n";

    for ($i = 1; $i <= 7; $i++) {
        $calendar .= "<td class='category' width='14%'><font color='$cattext'><div align='center'><strong>$DayNames[$i]</strong></div></font></td>\n";
    }
    $calendar .= " </tr>\n";

    for ($i = 1; $i < $FirstDay; $i++) {
        if ($i == 1) $calendar .= "<tr>\n";
        $calendar .= "<td bgcolor='$altbg2'>&nbsp;</td>\n";
        $DisplayDay++;
    }

    $calmouseover = " onmouseover='this.style.backgroundColor=\"$altbg2\";' onmouseout='this.style.backgroundColor=\"$altbg1\";'";

    for ($i = 1; $i <= $dim; $i++) {
        if ($DisplayDay == 1) $calendar .= "<tr>\n";

        if ($year == $CurrentYear && $month == $CurrentMonth && $i == $CurrentDay)
            $calendar .= "<td bgcolor='$altbg2' class='tablerow' valign='top' >\n";
        else
            $calendar .= "<td bgcolor='$altbg1' class='tablerow' valign='top' $calmouseover >\n";

        $tempDate = gmmktime(0, 0, 0, $month, $i, $year) - $tmOffset;

        $calendar .= "<div align='right'><strong>".gmdate("j", $tempDate + ($timeoffset * 3600) + ($addtime * 3600))."</strong></div><br />\n";

        $testMinDate = gmmktime(23, 59, 59, $month, $i, $year) - $tmOffset;
        $testMaxDate = gmmktime(0, 0, 0, $month, $i, $year) - $tmOffset;
        $calendar .= "<table cellspacing='0' cellpadding='1'>";
        $memwidth = ($newmembers[$i] * $mempx) . "px";
        $calendar .= "<tr class='tablerow'>";
        if (!($testMaxDate > $CurrentDate || $testMinDate < $StartDate)) {
            $calendar .= "<td align='left'>$lang[statscalmembers]</td><td align='right'>$newmembers[$i]</td>";
            $calendar .= "<td align='left'>";
            $calendar .= "&nbsp;<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar.gif' width='$memwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
            $calendar .= "</td>";
        } else
        $calendar .= "<td>&nbsp;</td>\n";
        $calendar .= "</tr>";

        $threadwidth = ($newthreads[$i] * $threadpx) . "px";
        $calendar .= "<tr class='tablerow'>";
        if (!($testMaxDate > $CurrentDate || $testMinDate < $StartDate)) {
            $calendar .= "<td align='left'>$lang[statscalthreads]</td><td align='right'>$newthreads[$i]</td>";
            $calendar .= "<td align='left'>";
            $calendar .= "&nbsp;<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar.gif' width='$threadwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
            $calendar .= "</td>";
        } else
        $calendar .= "<td>&nbsp;</td>\n";
        $calendar .= "</tr>";

        $postwidth = ($newposts[$i] * $postpx) . "px";
        $calendar .= "<tr class='tablerow'>";
        if (!($testMaxDate > $CurrentDate || $testMinDate < $StartDate)) {
            $calendar .= "<td align='left'>$lang[statscalposts]</td><td align='right'>$newposts[$i]</td>";
            $calendar .= "<td align='left'>";
            $calendar .= "&nbsp;<img src='$imgdir/pollbar-s.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar.gif' width='$postwidth' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' />";
            $calendar .= "<img src='$imgdir/pollbar-e.gif' width='3px' height='10px' border='0' alt='$lang[altpollpercentage]' title='$lang[altpollpercentage]' /><br />";
            $calendar .= "</td>";
        } else
        $calendar .= "<td>&nbsp;</td>\n";
        $calendar .= "</tr>";
        $calendar .= "</table>";
        $calendar .= "</td>\n";

        if ($DisplayDay == 7) {
            $calendar .= "</tr>\n";
            $DisplayDay = 1;
        } else {
            $DisplayDay++;
        }
    }

    if ($DisplayDay > 1) {
        for ($i = $DisplayDay; $i <= 7; $i++) {
            $calendar .= "<td bgcolor='$altbg2'>&nbsp;</td>\n";
            if ($i == 7) $calendar .= "</tr>\n";
        }
    }

    $calendar .= " </tr>\n";
    $calendar .= "</table>\n";
    $calendar .= " </td></tr></table>\n";
}

if ($view == 'yearly') {
    $navbar  = "<form action='statscal.php?view=yearly' method='post'>\n";
    $navbar .= "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
    $navbar .= "<tr><td bgcolor='$bordercolor'>\n";
    $navbar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'> \n";
    $navbar .= "<tr class='category'><td align='center' colspan='3'>\n";
    $navbar .= "<font color='$cattext'><strong>$lang[statscalnavigation]</strong></font>\n";
    $navbar .= "</td></tr>\n";
    $navbar .= "<tr class='tablerow'>\n";

    $lastyear = 0;
    if ($year > $StartYear) {
        $lastyear  = $year - 1;
    }
    $navbar .= "<td class='nav' bgcolor='$altbg2' width='14%' align='center'>\n";

    if ($lastyear > 0)
        $navbar .= "&laquo&nbsp;<a href='statscal.php?view=yearly&amp;year=$lastyear'>$lastyear</a>\n";
    $navbar .= "&nbsp;</td>\n";
    $navbar .= "<td bgcolor='$altbg2' align='center'>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<select name='year' size='1'>\n";
    for ($i = $StartYear; $i <= $CurrentYear; $i++) {
        $navbar .= "<option value='$i'";
        if ($year == $i) $navbar .= " selected='selected' ";
        $navbar .= ">$i</option>\n";
    }
    $navbar .= "</select>\n";
    $navbar .= "&nbsp;";
    $navbar .= "<input class='submit' type='submit' name='submit' value='$lang[statscaldisplay]' />\n";
    $navbar .= "</td>\n";
    $nextyear  = 0;
    if ($year < $CurrentYear) {
        $nextyear  = $year + 1;
    }

    $navbar .= "<td class='nav' bgcolor='$altbg2' width='14%' align='center'>&nbsp;\n";

    if ($nextyear > 0)
        $navbar .= "<a href='statscal.php?view=yearly&amp;year=$nextyear'>$nextyear</a>&nbsp;&raquo;\n";
    $navbar .= "</td>\n";
    $navbar .= "</tr>\n";
    $navbar .= "</table>\n";
    $navbar .= "</td></tr></table>\n";
    $navbar .= "</form>\n";
} else {
    $navbar  = "<br /><form action='statscal.php' method='post'>\n";
    $navbar .= "<table cellspacing='0' cellpadding='0' border='0' width='$tablewidth' align='center'>\n";
    $navbar .= "<tr><td bgcolor='$bordercolor'>\n";
    $navbar .= "<table border='0' cellspacing='$borderwidth' cellpadding='$tablespace' width='100%' align='center'> \n";
    $navbar .= "<tr class='category'><td align='center' colspan='3'>\n";
    $navbar .= "<font color='$cattext'><strong>$lang[statscalnavigation]</strong></font>\n";
    $navbar .= "</td></tr>\n";
    $navbar .= "<tr class='tablerow'>\n";

    $lastmonth = $lastyear = 0;

    if ($month == 1) {
        $lastmonth = 12;
        $lastyear  = $year - 1;
    } else {
        $lastmonth = $month - 1;
        $lastyear  = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$altbg2' width='14%' align='center'>\n";

    $dim = gmdate("t", mktime(0, 0, 0, $lastmonth, 1, $lastyear));
    $testLastMonth = mktime(0, 0, 0, $lastmonth, $dim, $lastyear);
    if ($testLastMonth > $StartDate)
        $navbar .= "&laquo;&nbsp;<a href='statscal.php?month=$lastmonth&amp;year=$lastyear'>$MonthNames[$lastmonth] $lastyear</a>\n";

    $navbar .= "&nbsp;</td>\n";
    $navbar .= "<td bgcolor='$altbg2' align='center'>\n";
    $navbar .= "<select name='month' size='1'>\n";

    if ($StartYear == $CurrentYear) {
        for ($i = $StartMonth; $i <= $CurrentMonth; $i++) {

            $navbar .= "<option value='$i'";
            if ($month == $i) $navbar .= " selected='selected' ";
            $navbar .= ">$MonthNames[$i]</option>\n";
        }
    } else {
        for ($i = 1; $i <= 12; $i++) {
            $navbar .= "<option value='$i'";
            if ($month == $i) $navbar .= " selected='selected' ";
            $navbar .= ">$MonthNames[$i]</option>\n";
        }
    }
    $navbar .= "</select>\n";

    $navbar .= "&nbsp;";

    $navbar .= "<select name='year' size='1'>\n";
    for ($i = $StartYear; $i <= $CurrentYear; $i++) {
        $navbar .= "<option value='$i'";
        if ($year == $i) $navbar .= " selected='selected' ";
        $navbar .= ">$i</option>\n";
    }
    $navbar .= "</select>\n";

    $navbar .= "&nbsp;";
    $navbar .= "<input class='submit' type='submit' name='submit' value='$lang[statscaldisplay]' />\n";
    $navbar .= "&nbsp;&nbsp;<strong>[<a href='statscal.php?view=yearly&amp;year=$year'>$year $lang[statscalmonthtotal]</a>]</strong>";
    $navbar .= "</td>\n";

    $nextmonth = 0;
    $nextyear  = 0;
    if ($month == 12) {
        $nextmonth = 1;
        $nextyear  = $year + 1;
    } else {
        $nextmonth = $month + 1;
        $nextyear  = $year;
    }

    $navbar .= "<td class='nav' bgcolor='$altbg2' width='14%' align='center'>&nbsp;\n";

    $testNextMonth = mktime(0, 0, 0, $nextmonth, 1, $nextyear);
    if ($testNextMonth < $CurrentDate)
        $navbar .= "<a href='statscal.php?month=$nextmonth&amp;year=$nextyear'>$MonthNames[$nextmonth] $nextyear</a>&nbsp;&raquo;\n";
    $navbar .= "</td>\n";
    $navbar .= "</tr>\n";
    $navbar .= "</table>\n";
    $navbar .= "</td></tr></table>\n";
    $navbar .= "</form>\n";
}

echo $calendar;
echo $navbar = (isset($navbar)) ? $navbar : '';

end_time();
eval('echo ("'.template('footer').'");');
?>