<?php
/**
 * Topic Activity v1.3
 * Copyright (c) 2010 John Briggs. All rights reserved.
 * http://www.xmbmods.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

require_once('header.php');

loadtemplates(
'topic_activity',
'topic_activity_threads',
'topic_activity_none',
'topic_activity_dotfolders',
'topic_activity_multipage',
'misc_feature_notavailable'
);

eval('$css = "'.template('css').'";');

smcwcache();

nav($lang['topicactivity']);

eval('echo "'.template('header').'";');

if ($SETTINGS['todaysposts'] == 'off') {
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

$type = (isset($type) ? strtolower($type) : '');
$sort = (isset($sort) ? strtolower($sort) : '');
$order = (isset($order) ? strtolower($order) : '');
$days = (isset($days) ? (int) $days : 1);
$selHTML = 'selected="selected"';

$srchfrom = $onlinetime - (86400 * $days);

$srchtype = '';
switch ($type) {
    case 'unanswered':
        $srchtype = "t.replies = 0 AND";
        break;
    case 'hot':
        $srchtype = "t.replies >= '$SETTINGS[hottopic]' AND";
        break;
    case 'closed':
        $srchtype = "t.closed = 'yes' AND";
        break;
    case 'moved':
        $srchtype = "t.closed LIKE '%moved%' AND";
        break;
    case 'topped':
        $srchtype = "t.topped = 1 AND";
        break;
    case 'poll':
        $srchtype = "t.pollopts != '' AND";
        break;
    default:
        $srchtype = '';
        break;
}

$srchsort = '';
switch ($sort) {
    case 'subject':
        $srchsort = "t.subject";
        break;
    case 'author':
        $srchsort = "t.author";
        break;
    case 'forum':
        $srchsort = "f.name";
        break;
    case 'replies':
        $srchsort = "t.replies";
        break;
    case 'views':
        $srchsort = "t.views";
        break;
    case 'lastpost':
        $srchsort = "t.lastpost";
        break;
    default:
        $srchsort = "t.lastpost";
        break;
}

$srchorder = '';
switch ($order) {
    case 'asc':
        $srchorder = "ASC";
        break;
    default:
        $srchorder = "DESC";
        break;
}

$t_extension = get_extension($lang['toppedprefix']);
switch ($t_extension) {
    case 'gif':
    case 'jpg':
    case 'jpeg':
    case 'png':
        $lang['toppedprefix'] = '<img src="'.$THEME['imgdir'].'/'.$lang['toppedprefix'].'" alt="'.$lang['toppedprefix'].'" title="'.$lang['toppedprefix'].'" border="0" />';
        break;
}

$p_extension = get_extension($lang['pollprefix']);
switch ($p_extension) {
    case 'gif':
    case 'jpg':
    case 'jpeg':
    case 'png':
        $lang['pollprefix'] = '<img src="'.$THEME['imgdir'].'/'.$lang['pollprefix'].'" alt="'.$lang['pollprefix'].'" title="'.$lang['pollprefix'].'" border="0" />';
        break;
}

validateTpp();
validatePpp();

$page = (isset($page) && is_numeric($page)) ? ($page < 1 ? 1 : ((int) $page)) : 1;
$start_limit = ($page > 1) ? (($page-1) * $tpp) : 0;

$dotadd1 = $dotadd2 = '';
if ($SETTINGS['dotfolders'] == 'on' && X_MEMBER) {
    $dotadd1 = "DISTINCT p.author AS dotauthor, ";
    $dotadd2 = "LEFT JOIN $table_posts p ON (t.tid=p.tid AND p.author='$xmbuser')";
}

$threadcount = 0;
$threads = '';
$fidarray = array();
// Get a list of the list all the forums that we may be able to view that meet our search criteria
// Then ensure we can view them. The final list will be used to find the threads we want.
$query = $db->query("SELECT DISTINCT f.fid, f.password, f.private, f.userlist FROM ($table_threads t, $table_forums f) WHERE t.lastpost >= '$srchfrom' AND t.fid=f.fid ");
while ($forums = $db->fetch_array($query)) {
    $authorization = privfcheck($forums['private'], $forums['userlist']);
    if ($authorization == true || X_SADMIN) {
        $fidpw = isset($_COOKIE['fidpw'.$forums['fid']]) ? $_COOKIE['fidpw'.$forums['fid']] : '';
        if ((($forums['password'] == $fidpw) || $forums['password'] == '') || X_SADMIN) {
            array_push($fidarray, $forums['fid']);
        }
    }
}
$db->free_result($query);

$fidlist = "'".implode("', '", $fidarray)."'";
$query = $db->query("SELECT $dotadd1 t.*, f.name FROM ($table_threads t, $table_forums f) $dotadd2 WHERE $srchtype t.lastpost >= '$srchfrom' AND t.fid=f.fid AND f.fid IN ($fidlist) ORDER BY $srchsort $srchorder LIMIT $start_limit, $tpp");
while ($thread = $db->fetch_array($query)) {
    $forum['name'] = $thread['name'];
    $thread['subject'] = shortenString($thread['subject'], 100, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $thread['subject'] = checkOutput(censor($thread['subject']), 'no', '', true);
    $forum['name'] = $forum['name'];
    $tmOffset = ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600);

    if ($thread['author'] != $lang['textanonymous']) {
        $author = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($thread['author']).'">'.$thread['author'].'</a>';
    } else {
        $author = $lang['textanonymous'];
    }

    $lastpost = explode('|', $thread['lastpost']);
    $dalast = trim($lastpost[0]);
    $lastPid = isset($lastpost[2]) ? $lastpost[2] : 0;

    if ($lastpost[1] != $lang['textanonymous']) {
        $lastpostauthor = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($lastpost[1]).'">'.$lastpost[1].'</a>';
    } else {
        $lastpostauthor = $lang['textanonymous'];
    }

    $lastpostdate = gmdate($dateformat, $lastpost[0] + $tmOffset);
    $lastposttime = gmdate($timecode, $lastpost[0] + $tmOffset);
    $lastpost = $lang['lastreply1'].' '.$lastpostdate.' '.$lang['textat'].' '.$lastposttime.'<br />'.$lang['textby'].' '.$lastpostauthor;

    if ($thread['icon'] != '' && file_exists($THEME['smdir'].'/'.$thread['icon'])) {
        $posticon = '<img src="'.$THEME['smdir'].'/'.$thread['icon'].'" alt="'.$thread['icon'].'" title="'.$thread['icon'].'" border="0" />';
    } else {
        $posticon = '';
    }

    if ($thread['replies'] >= $SETTINGS['hottopic']) {
        $folder = 'hot_folder.gif';
    } else {
        $folder = 'folder.gif';
    }

    $oldtopics = isset($oldtopics) ? $oldtopics : '';
    if (($oT = strpos($oldtopics, '|'.$lastPid.'|')) === false && $thread['replies'] >= $SETTINGS['hottopic'] && $lastvisit < $dalast) {
        $folder = 'hot_red_folder.gif';
    } elseif ($lastvisit < $dalast && $oT === false) {
        $folder = 'red_folder.gif';
    } else {
        $folder = $folder;
    }

    if ($SETTINGS['dotfolders'] == 'on' && isset($thread['dotauthor']) == $xmbuser && X_MEMBER) {
        $folder = 'dot_'.$folder;
    }

    $folder = '<img src="'.$THEME['imgdir'].'/'.$folder.'" alt="'.$lang['altfolder'].'" title="'.$lang['altfolder'].'" border="0" />';

    if ($thread['closed'] == 'yes') {
        $folder = '<img src="'.$THEME['imgdir'].'/lock_folder.gif" alt="'.$lang['altclosedtopic'].'" title="'.$lang['altclosedtopic'].'" border="0" />';
    }

    $prefix = '';
    $moved = explode('|', $thread['closed']);
    if ($moved[0] == 'moved') {
        $prefix = $lang['moved'].' ';
        $thread['realtid'] = $thread['tid'];
        $thread['tid'] = $moved[1];
        $thread['replies'] = '-';
        $thread['views'] = '-';
        $folder = '<img src="'.$THEME['imgdir'].'/lock_folder.gif" alt="'.$lang['altclosedtopic'].'" title="'.$lang['altclosedtopic'].'" border="0px" />';
        $query = $db->query("SELECT COUNT(pid) FROM $table_posts WHERE tid='$thread[tid]'");
        $postnum = 0;
        if ($query !== false) {
            $postnum = $db->result($query, 0);
        }
    } else {
        $thread['realtid'] = $thread['tid'];
    }

    if ($thread['pollopts'] != '') {
        $prefix = $lang['pollprefix'].' ';
    }

    if ($thread['topped'] == 1) {
        $prefix = $lang['toppedprefix'].' ';
    }

    $postnum = $thread['replies']+1;
    if ($postnum > $ppp) {
        $pagelinks = multi($postnum, $ppp, 0, 'viewthread.php?tid='.$thread['tid']);
        $pages = '(<span class="smalltxt">'.$pagelinks.'</span>)';
    } else {
        $pagelinks = $pages = '';
    }
    eval('$threads .= "'.template('topic_activity_threads').'";');
    $threadcount++;
}
$db->free_result($query);

if ($threadcount == 0) {
    eval('$threads = "'.template('topic_activity_none').'";');
}

$type_unanswered = $type_hot = $type_closed = '';
$type_moved = $type_topped = $type_poll = $type_active = '';
switch ($type) {
    case 'unanswered':
        $type_unanswered = $selHTML;
        break;
    case 'hot':
        $type_hot = $selHTML;
        break;
    case 'closed':
        $type_closed = $selHTML;
        break;
    case 'moved':
        $type_moved = $selHTML;
        break;
    case 'topped':
        $type_topped = $selHTML;
        break;
    case 'poll':
        $type_poll = $selHTML;
        break;
    default:
        $type_active = $selHTML;
        break;
}

$sort_subject = $sort_author = $sort_forum = '';
$sort_replies = $sort_views = $sort_lastpost = '';
switch ($sort) {
    case 'subject':
        $sort_subject = $selHTML;
        break;
    case 'author':
        $sort_author = $selHTML;
        break;
    case 'forum':
        $sort_forum = $selHTML;
        break;
    case 'replies':
        $sort_replies = $selHTML;
        break;
    case 'views':
        $sort_views = $selHTML;
        break;
    case 'lastpost':
        $sort_lastpost = $selHTML;
        break;
    default:
        $sort_lastpost = $selHTML;
        break;
}

$order_asc = $order_desc = '';
switch ($order) {
    case 'asc':
        $order_asc = $selHTML;
        break;
    default:
        $order_desc = $selHTML;
        break;
}

$dotlegend = '';
if ($SETTINGS['dotfolders'] == 'on' && X_MEMBER) {
    eval('$dotlegend = "'.template('topic_activity_dotfolders').'";');
}

$totalquery = $db->query("SELECT $dotadd1 t.*, f.password, f.private, f.userlist, f.name FROM $table_threads t $dotadd2, $table_forums f WHERE $srchtype t.lastpost >= '$srchfrom' AND t.fid = f.fid AND f.fid IN ($fidlist)");
$total = $db->num_rows($totalquery);
$db->free_result($totalquery);

$mpurl = 'activity.php?type='.$type.'&amp;days='.$days.'&amp;sort='.$sort.'&amp;order='.$order;
$multipage = '';
if (($multipage = multi($total, $tpp, $page, $mpurl)) !== false) {
    eval('$multipage = "'.template('topic_activity_multipage').'";');
}

eval('echo stripslashes("'.template('topic_activity').'");');

end_time();
eval('echo "'.template('footer').'";');
?>