<?php
/*
    Posts Since Last Active v1.4
     2010 John Briggs. All rights reserved.
    http://www.xmbmods.com

    Designed For Use With XMB 1.9.5 SP1
     2001 - 2005 Aventure Media & The XMB Development Team
    http://www.aventure-media.co.uk
    http://www.xmbforum.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');

loadtemplates(
'today',
'today2',
'today_multipage',
'misc_feature_notavailable
');

smcwcache();

nav($lang['navnewposts']);

eval('$css = "'.template('css').'";');

eval('echo "'.template('header').'";');

if ($SETTINGS['todaysposts'] == 'off') {
    eval('echo "'.template('misc_feature_notavailable').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit;
}

$srchfrom = $xmblvb;

$self['username'] = isset($self['username']) ? $self['username'] : '';
$modXmbuser = str_replace(array('*', '.', '+'), array('\*', '\.', '\+'), $xmbuser);
$restrict = array("(password='')"); // prevents empty restrictions
switch ($self['status']) {
    case 'Member':
        $restrict[] = 'private = 1';
        $restrict[] = "(userlist = '' OR userlist REGEXP '(^|(,))( )*$modXmbuser( )*((,)|$)')";
        break;
    case 'Moderator':
    case 'Super Moderator':
        $restrict[] = '(private = 1 OR private = 3)';
        $restrict[] = "(if ((private=1 AND userlist != ''), if ((userlist REGEXP '(^|(,))( )*$modXmbuser( )*((,)|$)'), 1, 0), 1))";
        break;
    case 'Administrator':
        $restrict[] = '(private > 0 AND private < 4)';
        $restrict[] = "(if ((private=1 AND userlist != ''), if ((userlist REGEXP '(^|(,))( )*$modXmbuser( )*((,)|$)'), 1, 0), 1))";
        break;
    case 'Super Administrator':
        break;
    default:
        $restrict[] = '(private=1)';
        $restrict[] = "(userlist='')";
        break;
}
$restrict = implode(' AND ', $restrict);

$fids = array();
if (X_SADMIN) {
    $q = $db->query("SELECT fid FROM $table_forums WHERE status='on'");
    while ($f = $db->fetch_array($q)) {
        $fids[] = $f['fid'];
    }
    $db->free_result($q);
} else {
    $q = $db->query("SELECT fid FROM $table_forums WHERE status='on' AND $restrict");
    while ($f = $db->fetch_array($q)) {
        $fids[] = $f['fid'];
    }
    $db->free_result($q);
    if (X_MEMBER) {
        $r2 = array();
        foreach ($_COOKIE as $key => $val) {
            $val = addslashes($val);
            if (preg_match('#^fidpw([0-9]+)$#', $key, $fetch)) {
                $r2[] = "(fid='$fetch[1]' AND password='$val')";
            }
        }
        if (count($r2) > 0) {
            $r = implode(' OR ', $r2);
            $q = $db->query("SELECT fid FROM $table_forums WHERE $r");
            while ($f = $db->fetch_array($q)) {
                $fids[] = $f['fid'];
            }
            $db->free_result($q);
        }
    }
}

if (count($fids) == 0) {
    error($lang['nopoststoday'], false);
}

$fids = implode(', ', $fids);

$tids = array();
$query = $db->query("SELECT tid FROM $table_threads WHERE lastpost >= '$srchfrom' AND fid IN ($fids)");
$results = $db->num_rows($query);
while ($t = $db->fetch_array($query)) {
    $tids[] = $t['tid'];
}
$tids = implode(', ', $tids);
$db->free_result($query);

if ($results == 0) {
    error($lang['nonewposts'], false);
}

validateTpp();
validatePpp();

$page = (isset($page) && is_numeric($page)) ? ($page < 1 ? 1 : ((int) $page)) : 1;
$start_limit = ($page > 1) ? (($page-1) * $tpp) : 0;

$multipage = '';
$mpurl = 'newposts.php';
if (($multipage = multi($results, $tpp, $page, $mpurl)) !== false) {
    eval('$multipage = "'.template('today_multipage').'";');
}

$query = $db->query("SELECT t.replies+1 as posts, t.tid, t.subject, t.author, t.lastpost, t.icon, t.replies, t.views, t.closed, f.fid, f.name FROM $table_threads t LEFT JOIN $table_forums f ON (f.fid=t.fid) WHERE t.tid IN ($tids) ORDER BY t.lastpost DESC LIMIT $start_limit, $tpp");
$today2 = array();
$tmOffset = ($timeoffset * 3600) + ($SETTINGS['addtime'] * 3600);
while ($thread = $db->fetch_array($query)) {
    $thread['subject'] = shortenString(censor(stripslashes($thread['subject'])), 125, X_SHORTEN_SOFT|X_SHORTEN_HARD, '...');
    $forum['name'] = stripslashes($thread['name']);

    if ($thread['author'] == $lang['textanonymous']) {
        $authorlink = $thread['author'];
    } else {
        $authorlink = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($thread['author']).'">'.trim($thread['author']).'</a>';
    }

    $lastpost = explode('|', $thread['lastpost']);
    $dalast = $lastpost[0];
    $lastPid = isset($lastpost[2]) ? $lastpost[2] : 0;

    if ($lastpost[1] != $lang['textanonymous']) {
        $lastpost[1] = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($lastpost[1]).'">'.trim($lastpost[1]).'</a>';
    } else {
        $lastpost[1] = $lang['textanonymous'];
    }

    $lastreplydate = gmdate($dateformat, $lastpost[0] + $tmOffset);
    $lastreplytime = gmdate($timecode, $lastpost[0] + $tmOffset);
    $lastpost = $lang['lastreply1'].' '.$lastreplydate.' '.$lang['textat'].' '.$lastreplytime.'<br />'.$lang['textby'].' '.$lastpost[1];

    // not being used because xmb did not add it.
    if ($thread['icon'] != '' && file_exists($THEME['smdir'].'/'.$thread['icon'])) {
        $thread['icon'] = '<img src="'.$THEME['imgdir'].'/'.$thread['icon'].'" border="0" alt="'.$THEME['imgdir'].'/'.$thread['icon'].'" title="'.$THEME['imgdir'].'/'.$thread['icon'].'" />';
    } else {
        $thread['icon'] = '';
    }

    if ($thread['replies'] >= $SETTINGS['hottopic']) {
        $folder = '<img src="'.$THEME['imgdir'].'/hot_folder.gif" border="0" alt="'.$lang['althotfolder'].'" title="'.$lang['althotfolder'].'" />';
    } else {
        $folder = '<img src="'.$THEME['imgdir'].'/folder.gif" border="0" alt="'.$lang['altfolder'].'" title="'.$lang['altfolder'].'" />';
    }

    $oldtopics = isset($oldtopics) ? $oldtopics : '';
    if (($oT = strpos($oldtopics, '|'.$lastPid.'|')) === false && $thread['replies'] >= $SETTINGS['hottopic'] && $lastvisit < $dalast) {
        $folder = '<img src="'.$THEME['imgdir'].'/hot_red_folder.gif" border="0" alt="'.$lang['althotredfolder'].'" title="'.$lang['althotredfolder'].'" />';
    } elseif ($lastvisit < $dalast && $oT === false) {
        $folder = '<img src="'.$THEME['imgdir'].'/red_folder.gif" border="0" alt="'.$lang['altredfolder'].'" title="'.$lang['altredfolder'].'" />';
    }

    if ($thread['closed'] == 'yes') {
        $folder = '<img src="'.$THEME['imgdir'].'/lock_folder.gif" border="0" alt="'.$lang['altclosedtopic'].'" title="'.$lang['altclosedtopic'].'" />';
        $prefix = '';
    } else {
        $moved = explode('|', $thread['closed']);
        if ($moved[0] == 'moved') {
            continue;
        }
    }

    $pagelinks = $multipage2 = '';
    if ($thread['posts'] > $ppp) {
        $pagelinks = multi($thread['posts'], $ppp, 0, 'viewthread.php?tid='.$thread['tid']);
        $multipage2 = '(<span class="smalltxt">'.$pagelinks.'</span>)';
    }
    eval('$today2[] = "'.template('today2').'";');
}
$db->free_result($query);

$rows = implode("\n", $today2);

eval('echo stripslashes("'.template('today').'");');

end_time();
eval('echo "'.template('footer').'";');
?>