<?php
/* $Id: gallery_install.php,v 1.2 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!((bool) ini_get('safe_mode'))) {
    set_time_limit(1000);
}

require_once('header.php');

loadtemplates('');

if (!X_SADMIN) {
    eval('$css = "'.template('css').'";');
    error($lang['superadminonly']);
}

// BEGIN CONFIGURATION SETTINGS
$hackname = 'Photo Gallery v2.0'; // Hack Name
$fontstyle = 'Tahoma'; // Font Type
$fontsize = '10px'; // Font Size
$txtcolor = '#000000';  // Text Color
$bgcolor = '#EDF0F7';  // Background Color
$bordercolor = '#C4C8D4';  // Border Color
$altbg1 = '#EDF0F7';  // Alternate Color 1
$altbg2 = '#FFFFFF';  // Alternate Color 2
$tablewidth = '400';  // Table Width
$borderwidth = '1';  // Border Width
$tablespace = '5';  // Table Spacing
$usetemplatefile = 'yes';  // Does this hack use a template (.xmb) file?  yes or no
$templatefilename = 'img_templates.xmb';  // Template file name, if any is used
$checkfiles = array(
    'lang/English.gallery.php',
    'gallery.php',
    'gallery_admin.php',
    'gallery_comments.php',
    'include/gallery.functions.inc.php',
    'gallery_image.php',
    'gallery_misc.php',
    'gallery_search.php',
    'gallery_stats.php',
    'gallery_user_album.php',
    'gallery_view_album.php',
    'gallery_view_comments.php'
    );  // Files that need to be uploaded
// END CONFIGURATION SETTINGS
?>
<html>
<head>
<title><?php echo $hackname?> Installer</title>
<style type="text/css">
<!--
body { scrollbar-base-color: #EDF0F7; scrollbar-arrow-color: #FFFFFF }
a { color: #000000; text-decoration: none }
a:hover { text-decoration: underline }
.header { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: bold; background-color: #FFFFFF }
.tablerow { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: normal }
textarea, select, input, object { font-family: <?php echo $fontstyle?>; color: #000000; font-size: <?php echo $fontsize?>; font-weight: normal; background-color: #EDF0F7 }
//-->
</style>
</head>
<body text="<?php echo $txtcolor?>" bgcolor="<?php echo $bgcolor?>" link="<?php echo $bgcolor?>">
<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" align="center">
<tr><td align="center" valign="center">

<?php
if (!isset($_POST['confirmsubmit']) && !isset($_POST['licensesubmit']) && !isset($_POST['installsubmit']) && !isset($_POST['removesubmit'])) {
    $removebutton = '';
    if (file_exists("gallery.php")) {
        $removebutton = '<input type="submit" name="removesubmit" value="Uninstall" />';
    }
    ?>
    <form method="post" action="gallery_install.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong><?php echo $hackname?></strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    Thanks for choosing to install another hack by XMBMods.com!
    <br /><br /><br />
    This part of the installation will create all necessary database tables and templates, insert any necessary data, and configure any necessary settings.<br /><br /><br />
    Before continuing, be sure that you have completed the instructions provided in the hack installation text file.<br /><br /><br />
    <input type="submit" name="confirmsubmit" value="Install" /> <?php echo $removebutton?>
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['removesubmit'])) {
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcats");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimages");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgsettings");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgvotes");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcomments");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimagedata");
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgthumbnails");
    $db->query("DELETE FROM ".$tablepre."templates WHERE name LIKE 'img_%'");
    $db->query("DELETE FROM ".$tablepre."templates WHERE name=''");
    ?>
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>Uninstall</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    <strong><?php echo $hackname?></strong> has been successfully removed!<br /><br /><br />
    To complete the uninstall, please delete the file <strong>gallery_install.php</strong> and <strong>img_templates.xmb</strong>.
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    <?php
}

if (isset($_POST['confirmsubmit'])) {
    ?>
    <form method="post" action="gallery_install.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>Important!</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    As with any hack, we recommend backing up your current database, templates, and files.<br /><br /><br />
    This safety precaution can mean the difference between a successful installation or an evening full of headaches.<br /><br /><br />
    Did you make a backup of your database and templates?<br /><br /><br />
    <input type="submit" name="licensesubmit" value="Yes"> <input type="submit" name="cancelsubmit" value="No" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['licensesubmit'])) {
    ?>
    <form method="post" action="gallery_install.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong>License Agreement</strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    This hack and all code contained within are released under the GNU GPL license.<br /><br /><br />
    All copyright information, found within this hack, may not be removed for any reason and must remain visible at all times.<br /><br /><br />
    Do you agree to these terms?<br /><br /><br />
    <input type="submit" name="installsubmit" value="Agree"> <input type="submit" name="cancelsubmit" value="Disagree" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
}

if (isset($_POST['installsubmit'])) {
    ?>
    <form method="post" action="gallery_install.php">
    <table cellspacing="0" cellpadding="0" border="0" width="<?php echo $tablewidth?>" align="center">
    <tr>
    <td bgcolor="<?php echo $bordercolor?>">
    <table cellspacing="<?php echo $borderwidth?>" cellpadding="<?php echo $tablespace?>" border="0" width="100%" align="center">
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg1?>" align="center"><strong><?php echo $hackname?></strong></td>
    </tr>
    <tr>
    <td class="tablerow" bgcolor="<?php echo $altbg2?>" align="center">
    <?php
    for ($i = 0; $i < count($checkfiles); $i++) {
        if (!file_exists($checkfiles[$i])) {
            echo '<strong>Error!</strong> The installation has been halted.<br /><br /><br />';
            echo 'The file, <strong>'.$checkfiles[$i].'</strong>, does not exist.<br /><br /><br />';
            echo 'Please upload the file and click restart to continue.<br /><br /><br />';
            echo '<input type="submit" name="cancelsubmit" value="Restart" />';
            exit;
        }
    }
    ?>
    Now installing! Please be patient as this process may take a few minutes.<br /><br /><br />
    <?php
    // BEGIN
    echo "Creating table <strong>".$tablepre."imgcats</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcats");
    $db->query("CREATE TABLE ".$tablepre."imgcats (
      `cid` mediumint(8) NOT NULL auto_increment,
      `name` varchar(255) NOT NULL default '',
      `description` text NOT NULL default '',
      `status` varchar(15) NOT NULL default '',
      `displayorder` smallint(6) NOT NULL default '0',
      `images` int(100) NOT NULL default '0',
      `who_view` char(3) NOT NULL default '1',
      `views` int(100) NOT NULL default '0',
      `closed` varchar(15) default NULL,
      `author` varchar(32) NOT NULL default '',
      `lastpost` varchar(32) NOT NULL default '',
      `creator_only` char(3) NOT NULL default '',
      `who_add` char(3) NOT NULL default '1',
      `view_list` text NOT NULL default '',
      `password` varchar(32) NOT NULL default '',
      `sub` smallint(6) NOT NULL default '0',
      `add_list` text NOT NULL default '',
      PRIMARY KEY  (`cid`),
      KEY `author` (`author`),
      KEY `sub` (`sub`),
      KEY `name` (`name`),
      KEY `displayorder` (`displayorder`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgimages</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimages");
    $db->query("CREATE TABLE ".$tablepre."imgimages (
      `iid` mediumint(8) NOT NULL auto_increment,
      `cid` mediumint(8) NOT NULL default '0',
      `author` varchar(32) NOT NULL default '0',
      `name` varchar(255) NOT NULL default '',
      `description` text NOT NULL default '',
      `dateline` int(10) NOT NULL default '0',
      `thumb` varchar(255) NOT NULL default '',
      `url` varchar(255) NOT NULL default '',
      `upload` varchar(15) NOT NULL default '',
      `views` int(100) NOT NULL default '0',
      `rate` int(100) NOT NULL default '0',
      `votes` int(100) NOT NULL default '0',
      `comments` int(100) NOT NULL default '0',
      PRIMARY KEY  (`iid`),
      KEY `author` (`author`),
      KEY `cid` (`cid`),
      KEY `name` (`name`),
      KEY `dateline` (`dateline`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgsettings</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgsettings");
    $db->query("CREATE TABLE ".$tablepre."imgsettings (
      `title` varchar(50) NOT NULL default '',
      `max_thumb_width` int(100) NOT NULL default '0',
      `max_thumb_height` int(100) NOT NULL default '0',
      `max_image_width` int(100) NOT NULL default '0',
      `max_image_height` int(100) NOT NULL default '0',
      `max_image_size` int(100) NOT NULL default '0',
      `display_images` varchar(50) NOT NULL default '',
      `display_albums` varchar(50) NOT NULL default '',
      `thumbs_on_row` smallint(5) NOT NULL default '0',
      `upload` char(3) NOT NULL default '',
      `sid` mediumint(8) NOT NULL default '0',
      `who_upload` varchar(30) NOT NULL default '',
      `max_upl_mem` int(100) NOT NULL default '0',
      `max_cat_mem` int(100) NOT NULL default '0',
      `max_img_mem` int(100) NOT NULL default '0',
      `who_create` varchar(30) NOT NULL default '',
      `whoadd` varchar(30) NOT NULL default '',
      `album_order` varchar(50) NOT NULL default '',
      `hot_cat` smallint(5) NOT NULL default '0',
      `thumbs_on_page` smallint(5) NOT NULL default '0',
      `image_order` varchar(50) NOT NULL default '',
      `resize_thumb` char(3) NOT NULL default '',
      `who_view_gallery` varchar(30) NOT NULL default '',
      `rating` char(3) NOT NULL default '',
      `comments` char(3) NOT NULL default '',
      `allowhtml` char(3) NOT NULL default '',
      `allowsmilies` char(3) NOT NULL default '',
      `allowbbcode` char(3) NOT NULL default '',
      `allowimgcode` char(3) NOT NULL default '',
      `multi_upload` char(3) NOT NULL default '',
      `stats` char(3) NOT NULL default '',
      `creator_only` char(3) NOT NULL default '',
      `slideshow` varchar(15) NOT NULL default '',
      `pause` int(100) NOT NULL default '0',
      `printable` char(3) NOT NULL default '',
      `show_sub_albums` char(3) NOT NULL default '',
      `member_subalbums` char(3) NOT NULL default '',
      `search` char(3) NOT NULL default '',
      `rules` varchar(30) NOT NULL default '',
      `rule_left` text NOT NULL default '',
      `rule_right` text NOT NULL default '',
      `move` varchar(30) NOT NULL default '',
      PRIMARY KEY  (`title`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgvotes</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgvotes");
    $db->query("CREATE TABLE ".$tablepre."imgvotes (
      `iid` mediumint(8) NOT NULL default '0',
      `username` varchar(32) NOT NULL default '0'
    ) ");

    echo "Creating table <strong>".$tablepre."imgcomments</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgcomments");
    $db->query("CREATE TABLE ".$tablepre."imgcomments (
      `cid` smallint(6) NOT NULL default '0',
      `iid` smallint(6) NOT NULL default '0',
      `pid` int(10) NOT NULL auto_increment,
      `author` varchar(40) NOT NULL default '',
      `message` text NOT NULL default '',
      `subject` varchar(100) NOT NULL default '',
      `dateline` bigint(30) NOT NULL default '0',
      `icon` varchar(50) default NULL,
      `usesig` varchar(15) NOT NULL default '',
      `useip` varchar(40) NOT NULL default '',
      `bbcodeoff` varchar(15) NOT NULL default '',
      `smileyoff` varchar(15) NOT NULL default '',
      PRIMARY KEY  (`pid`),
      KEY `iid` (`iid`),
      KEY `dateline` (`dateline`),
      KEY `cid` (`cid`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgimagedata</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgimagedata");
    $db->query("CREATE TABLE ".$tablepre."imgimagedata (
      `iid` smallint(6) DEFAULT '0' NOT NULL,
      `cid` smallint(6) DEFAULT '0' NOT NULL,
      `height` int(3) DEFAULT '0' NOT NULL,
      `width` int(3) DEFAULT '0' NOT NULL,
      `filetype` VARCHAR(120) NOT NULL default '',
      `imagedata` LONGBLOB NOT NULL,
      PRIMARY KEY (`iid`)
    ) ");

    echo "Creating table <strong>".$tablepre."imgthumbnails</strong> and inserting any necessary data.<br /><br />";
    $db->query("DROP TABLE IF EXISTS ".$tablepre."imgthumbnails");
    $db->query("CREATE TABLE ".$tablepre."imgthumbnails (
      `iid` smallint(6) DEFAULT '0' NOT NULL,
      `cid` smallint(6) DEFAULT '0' NOT NULL,
      `height` int(3) DEFAULT '0' NOT NULL,
      `width` int(3) DEFAULT '0' NOT NULL,
      `filetype` VARCHAR(120) NOT NULL default '',
      `thumbnail` MEDIUMBLOB NOT NULL,
      PRIMARY KEY (`iid`)
    ) ");
    // END
    // BEGIN INSERTING
    echo "Inserting <strong>".$tablepre."imgsettings</strong> and any necessary data.<br /><br />";
    $db->query("INSERT INTO ".$tablepre."imgsettings VALUES ('Photo Gallery', 150, 100, 800, 600, 1000000, '2', '2', 3, 'off', 0, '3', 10, 10, 200, '1', '1', 'displayorder', 20, 20, 'dateline', 'off', '1', 'off', 'off', 'off', 'off', 'off', 'off', 'off', 'off', 'on', 'off', 3000, 'off', 'off', 'off', 'off', 'None', 'Please check back with the gallery as it will have updated pictures.', '[list][*]Max: 800 x 600[*]Max Image size is 1 MB[*]Max upload is 10 images[*]Max 2 albums per member[/list]', '2')");
    // END INSERTING
    // BEGIN ALTERING
    echo "Altering <strong>".$tablepre."settings</strong> and adding necessary data.<br /><br />";
    $db->query("ALTER TABLE ".$tablepre."settings ADD photogallerystatus char(3) default 'on' NOT NULL");
    // END ALTERING

    // BEGIN TEMPLATES
    if ($usetemplatefile == 'yes') {
        echo "Creating any necessary templates.<br /><br />";
        $db->query("DELETE FROM ".$tablepre."templates WHERE name LIKE 'img_%'");

        $filesize = @filesize($templatefilename);
        $fp = @fopen($templatefilename, 'r');
        $templatesfile = @fread($fp, $filesize);
        @fclose($fp);
        $templates = explode("|#*XMB TEMPLATE FILE*#|", $templatesfile);
        while (list($key,$val) = each($templates)) {
            $template = explode("|#*XMB TEMPLATE*#|", $val);
            if (isset($template[1])) {
                $template[1] = addslashes($template[1]);
                $db->query("INSERT INTO ".$tablepre."templates (id, name, template) VALUES ('', '".addslashes($template[0])."', '".addslashes($template[1])."')");
            }
        }
        $db->query("DELETE FROM ".$tablepre."templates WHERE name=''");
    }
    // END TEMPLATES
    ?>
    <br />
    The installation of <strong><?php echo $hackname?></strong> is now complete!<br /><br /><br />
    Please delete files <strong>gallery_install.php</strong> and <strong>img_templates.xmb</strong> and click finish to continue.<br /><br /><br />
    <input type="button" onclick="location.href='gallery.php'" value="Finish" />
    </td>
    </tr>
    </table>
    </td>
    </tr>
    </table>
    </form>
    <?php
    @unlink("img_templates.xmb");
    @unlink("gallery_install.php");
    @unlink("gallery_upgrade.php");
}
?>
<br />
<span class="tablerow"><strong><a href="http://www.xmbmods.com" target="_blank">XMBMods.com</a></strong> &copy; 2005 - 2006</span>
</td>
</tr>
</table>
</form>
</body>
</html>