<?php
/* $Id: gallery_comments.php,v 1.3 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

/**
* bbcodeinsert() - return $bbcode populated with bbcode JS functions
*
* Returns $bbcode populated with bbcode JS functions if the feature is on
*
* @return   the required bbcode or a blank string if $bbinsert setting is not "on"
*/
function bbcodeinsert() {
    global $imgdir, $bbinsert, $altbg1, $altbg2, $lang, $SETTINGS, $spelling_lang;

    $bbcode = '';
    if ($bbinsert == 'on') {
        eval('$bbcode = "'.template('functions_bbcodeinsert').'";');
    }
    return $bbcode;
}

loadtemplates(
'img_footer',
'functions_bbcodeinsert',
'functions_bbcode',
'post_loggedin',
'functions_smilieinsert_smilie',
'functions_smilieinsert',
'img_post_reply_review_post',
'img_post_reply',
'img_post_preview',
'img_comment_edit',
'img_post_reply_review_toolong',
'img_info',
'img_error'
);

eval('$css = "'.template('css').'";');
smcwcache();

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivgallery']);
}

//  Check to see if comments are enabled
if ($gsettings['comments'] != 'on') {
    eval('echo "'.template('header').'";');
    gallery_error($lang['fnasorry']);
}

$iid = (isset($iid) ? (int) $iid : 0);
$pid = (isset($pid) ? (int) $pid : 0);
$cid = (isset($cid) ? (int) $cid : 0);

if ($iid != 0) {
    $query = $db->query("SELECT * FROM $table_imgimages WHERE iid = '$iid'");
    if ($db->num_rows($query) == 1) {
        $image = $db->fetch_array($query);
        $imagename = stripslashes($image['name']);
        $cid = $image['cid'];
    } else {
        eval('echo "'.template('header').'";');
        gallery_error($lang['img_errornoimage']);
    }
    $db->free_result($query);
}

//  Retrieve the album settings, store them in an array
if ($cid != 0) {
    $query = $db->query("SELECT * FROM $table_imgcats WHERE cid = '$cid'");
    if ($db->num_rows($query) == 1) {
        $album = $db->fetch_array($query);
        $albumname = stripslashes($album['name']);
    } else {
        eval('echo "'.template('header').'";');
        gallery_error($lang['img_errornoalbum']);
    }
    $db->free_result($query);
} else {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errornoalbum']);
}

//  Check for permissions to view the album
$authorization = gallery_viewalbumperm($cid);
if (!$authorization) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivalbum']);
}

validatePpp();

if (X_GUEST) {
    eval('$loggedin = "'.template('post_notloggedin').'";');
} else {
    eval('$loggedin = "'.template('post_loggedin').'";');
}

if ($self['ban'] == 'posts' || $self['ban'] == 'both') {
    eval('echo "'.template('header').'";');
    gallery_error($lang['textbanfrompost']);
}

if ($self['status'] == 'Banned') {
    eval('echo "'.template('header').'";');
    gallery_error($lang['bannedmessage']);
}

$listed_icons = 0;
$icons = '<input type="radio" name="posticon" value="" /> <img src="'.$imgdir.'/default_icon.gif" alt="[*]" border="0" />';

if ($action != 'edit') {
    if (!X_STAFF) {
        $querysmilie = $db->query("SELECT url, code FROM $table_smilies WHERE type='picon' AND (url NOT LIKE '%rsvd%')");
        while ($smilie = $db->fetch_array($querysmilie)) {
            $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" /><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
            $listed_icons += 1;
            if ($listed_icons == 9) {
                $icons .= '<br />';
                $listed_icons = 0;
            }
        }
        $db->free_result($querysmilie);
    } else {
        $querysmilie = $db->query("SELECT url, code FROM $table_smilies WHERE type='picon'");
        while ($smilie = $db->fetch_array($querysmilie)) {
            $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" /><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
            $listed_icons += 1;
            if ($listed_icons == 9) {
                $icons .= '<br />';
                $listed_icons = 0;
            }
        }
        $db->free_result($querysmilie);
    }
}

eval('$bbcodescript = "'.template('functions_bbcode').'";');

if (!isset($usesig)) {
    $usesig = 'no';
}

if ($usesig != 'yes') {
    $usesig = 'no';
}

$chkInputHTML = 'no';
$chkInputTags = 'no';
if (isset($gsettings['allowhtml']) && $gsettings['allowhtml'] == 'on') {
    $chkInputHTML = 'yes';
    $chkInputTags = 'no';
}

$allowimgcode = (isset($gsettings['allowimgcode']) && $gsettings['allowimgcode'] == 'on') ? $lang['texton'] : $lang['textoff'];
$allowhtml = ($chkInputHTML == 'yes' )                                                 ? $lang['texton'] : $lang['textoff'];
$allowsmilies = (isset($gsettings['allowsmilies']) && $gsettings['allowsmilies'] == 'on') ? $lang['texton'] : $lang['textoff'];
$allowbbcode = (isset($gsettings['allowbbcode']) && $gsettings['allowbbcode'] == 'on')   ? $lang['texton'] : $lang['textoff'];

// add all checks in case of preview
if (isset($smileyoff) && $smileyoff == 'yes') {
    $smileoffcheck = 'checked="checked"';
} else {
    $smileoffcheck = '';
    $smileyoff = 'no';
}

if (isset($bbcodeoff) && $bbcodeoff == 'yes') {
    $codeoffcheck = 'checked="checked"';
} else {
    $codeoffcheck = '';
    $bbcodeoff = 'no';
}

if (isset($subaction) && $subaction == 'spellcheck' && (isset($spellchecksubmit) || isset($spellcheckersubmit))) {
    $sc = true;
} else {
    $sc = false;
}

if ((isset($previewpost) || $sc) && isset($usesig) && $usesig == 'on') {
    $usesigcheck = 'checked="checked"';
} elseif (isset($previewpost) || $sc) {
    $usesigcheck = '';
} elseif (!empty($self['sig'])) {
    $usesigcheck = 'checked="checked"';
} else {
    $usesigcheck = '';
}

$repquote = isset($repquote) ? (int) $repquote : 0;

gallery_pwverify($album['password'], 'gallery_comments.php?action='.$action.'&cid='.$cid.'&iid='.$iid.'&pid='.$pid.'&repquote='.$repquote,true);

nav('<a href="gallery.php">'.stripslashes($gsettings['title']).'</a>');
nav('<a href="gallery_view_album.php?cid='.$cid.'">'.$albumname.'</a>');
nav('<a href="gallery_image.php?action=view&amp;iid='.$iid.'#pictop">'.$imagename.'</a>');

if ($action == 'reply') {
    nav($lang['textreply']);
} elseif ($action == 'edit') {
    nav($lang['texteditpost']);
}

eval('echo "'.template('header').'";');

// Start temp-spellcheck //
if ($SETTINGS['spellcheck'] == 'on') {
    $spelling_submit1 = '<input type="hidden" name="subaction" value="spellcheck" /><input type="submit" class="submit" name="spellchecksubmit" value="'.$lang['checkspelling'].'" />';
    $spelling_lang = '<select name="language"><option value="en" selected="selected">English</option></select>';

    if (isset($subaction) && $subaction == 'spellcheck' && (isset($spellchecksubmit) ||
        isset($updates_submit))) {
        if (!$updates_submit) {
            $subject = checkInput($subject, $chkInputTags, $chkInputHTML, '', false);
            $message = checkInput($message, $chkInputTags, $chkInputHTML, '', true);
            require './include/spelling.inc.php';
            $spelling = new spelling($language);
            $problems = $spelling->check_text($message);
            if (count($problems) > 0) {
                foreach ($problems as $orig=>$new) {
                    $mistake = array();
                    foreach ($new as $suggestion) {
                        eval('$mistake[] = "'.template('spelling_suggestion_new').'";');
                    }
                    $mistake = implode('\n', $mistake);
                    eval('$suggest[] = "'.template('spelling_suggestion_row').'";');
                }
                $suggestions = implode('\n', $suggest);
                eval('$suggestions = "'.template('spelling_suggestion').'";');
                $spelling_submit2 = '<input type="submit" class="submit" name="updates_submit"
                    value="'.$lang['replace'].'" />';
            } else {
                eval('$suggestions = "'.template('spelling_suggestion_no').'";');
                $spelling_submit2 = '';
            }

        } else {
            foreach ($old_words as $word) {
                $message = str_replace($word, ${'replace_'.$word}, $message);
            }
            $spelling_submit2 = '';
        }
    } else {
        $suggestions = '';
    }
} else {
    $spelling_submit1 = $spelling_submit2 = $spelling_lang = $suggestions = '';
}
// End temp-spellcheck //

$bbcodeinsert = bbcodeinsert();
$smilieinsert = smilieinsert();

if (isset($previewpost)) {
    $currtime = $onlinetime;
    $date = gmdate($dateformat, $currtime + ($timeoffset * 3600) + ($addtime * 3600));
    $time = gmdate($timecode, $currtime + ($timeoffset * 3600) + ($addtime * 3600));
    $poston = $lang['textposton'].' '.$date.' '.$lang['textat'].' '.$time;

    $subject = checkInput($subject, $chkInputTags, $chkInputHTML, '', false);
    $message = checkInput($message, $chkInputTags, $chkInputHTML, '', true);
    $message1 = postify($message, $smileyoff, $bbcodeoff, $gsettings['allowsmilies'],
    $gsettings['allowhtml'], $gsettings['allowbbcode'], $gsettings['allowimgcode']);
    $dissubject = censor($subject);
    $thread['icon'] = '';
    eval('$preview = stripslashes("'.template('img_post_preview').'");');
} else {
    $preview = '';
    $subject = (isset($subject) ? $subject : '');
    $message = (isset($message) ? $message : '');
}

switch ($action) {
    case 'reply':
        if (!isset($_POST['replysubmit'])) {
            $posts = '';
            // Start Reply With Quote
            if (isset($repquote) && ($repquote = (int) $repquote)) {
                $query = $db->query("SELECT message, author FROM $table_imgcomments WHERE pid='$repquote'");
                $thaquote = $db->fetch_array($query);
                $message = "[quote][i]$lang[origpostedby] $thaquote[author][/i]\n$thaquote[message] [/quote]";
            }

            // Start Topic/Thread Review
            $querytop = $db->query("SELECT COUNT(pid) FROM $table_imgcomments WHERE iid='$iid'");
            $replynum = $db->result($querytop, 0);
            if ($replynum >= $ppp) {
                $threadlink = 'gallery_image.php?action=view&iid=$iid#pictop';
                eval($lang['evaltrevlt']);
                eval('$posts .= "'.template('img_post_reply_review_toolong').'";');
            } else {
                $thisbg = $altbg1;
                $query = $db->query("SELECT * FROM $table_imgcomments WHERE iid='$iid' ORDER BY dateline DESC");
                while ($post = $db->fetch_array($query)) {
                    $date = gmdate($dateformat, $post['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));
                    $time = gmdate($timecode, $post['dateline'] + ($timeoffset * 3600) + ($addtime * 3600));

                    $poston = $lang['textposton'].' '.$date.' '.$lang['textat'].' '.$time;
                    if (!empty($post['icon'])) {
                        $post['icon'] = '<img src="'.$smdir.'/'.$post['icon'].'" alt="'.$lang['altpostmood'].'" border="0" />';
                    } else {
                        $post['icon'] = '<img src="'.$imgdir.'/default_icon.gif" alt="[*]" border="0" />';
                    }

                    $post['message'] = postify($post['message'], $post['smileyoff'],
                    $post['bbcodeoff'], $gsettings['allowsmilies'], $gsettings['allowhtml'],
                    $gsettings['allowbbcode'], $gsettings['allowimgcode']);
                    eval('$posts .= "'.template('img_post_reply_review_post').'";');
                    if ($thisbg == $altbg2) {
                        $thisbg = $altbg1;
                    } else {
                        $thisbg = $altbg2;
                    }
                }
            }
            eval('echo stripslashes("'.template('img_post_reply').'");');
        } elseif ($_POST['replysubmit']) {
            if (!$subject && !$message) {
                gallery_error($lang['postnothing']);
            }

            if (X_MEMBER && empty($username) && empty($password)) {
                $username = $xmbuser;
                $password = $xmbpw;
            }

            if (!empty($username) && !empty($password)) {
                if (X_GUEST) {
                    $username = trim($username);
                    $password = md5(trim($password));
                }
                $q = $db->query("SELECT * FROM $table_members WHERE username='$username'");
                if ($db->num_rows($q) != 1) {
                    gallery_error($lang['badname']);
                } else {
                    $self = $db->fetch_array($q);
                    if ($password != $self['password']) {
                        gallery_error($lang['textpw1']);
                    }
                    $username = $self['username'];
                }

                if ($self['status'] == 'Banned') {
                    gallery_error($lang['bannedmessage']);
                }

                $currtime = $onlinetime + (86400*30);
                put_cookie('xmbuser', $username, $currtime, $cookiepath, $cookiedomain);
                put_cookie('xmbpw', $password, $currtime, $cookiepath, $cookiedomain);
                if ($self['ban'] == 'posts' || $self['ban'] == 'both') {
                    gallery_error($lang['textbanfrompost']);
                }
            } else {
                if (X_GUEST) {
                    gallery_error($lang['textnoguestposting']);
                }
            }

            if (isset($posticon) && !empty($posticon)) {
                $query = $db->query("SELECT id FROM $table_smilies WHERE type='picon' AND url='$posticon'");
                if (!$db->result($query, 0)) {
                    exit;
                }
            } else {
                $posticon = '';
            }
            $query = $db->query("SELECT lastpost FROM $table_imgcats WHERE cid='$cid'");
            $for = $db->fetch_array($query);
            $last = $for['lastpost'];

            if (!empty($last)) {
                $lastpost = explode('|', $last);
                $rightnow = $onlinetime - $floodctrl;
                if ($rightnow <= $lastpost[0] && $username == $lastpost[1]) {
                    $floodlink = '<a href="gallery_image.php?action=view&iid='.$iid.'#pictop">Click here</a>';
                    gallery_error($lang['floodprotect'].' '.$floodlink.' '.$lang['tocont']);
                }
            }

            if ($usesig != 'yes') {
                $usesig = 'no';
            }

            $subject = addslashes(trim($subject));
            $message = addslashes(trim($message));

            $thatime = $onlinetime;
            $subject = checkInput($subject, $chkInputTags, $chkInputHTML, '', false);
            $message = checkInput($message, $chkInputTags, $chkInputHTML, '', true);
            $db->query("INSERT INTO $table_imgcomments ( cid, iid, pid, author, message, subject, dateline, icon, usesig, useip, bbcodeoff, smileyoff ) VALUES ('$cid', '$iid', '', '$username', '$message', '$subject', '$thatime', '$posticon', '$usesig', '$onlineip', '$bbcodeoff', '$smileyoff')");
            $pid = $db->insert_id();

            $db->query("UPDATE $table_imgimages SET comments=comments+1 WHERE iid='$iid' AND cid='$cid'");

            $db->query("UPDATE $table_imgcats SET lastpost='$thatime|$username' WHERE cid='$cid'");

            $db->query("UPDATE $table_members SET postnum=postnum+1 WHERE username='$username'");

            $query = $db->query("SELECT COUNT(pid) FROM $table_imgcomments WHERE pid<=$pid AND iid='$iid'");
            $posts = $db->result($query,0);

            if ($posts > $ppp) {
                $topicpages = quickpage($posts, $ppp);
            } else {
                $topicpages = 1;
            }

            if (X_MEMBER) {
                $currtime = $onlinetime + (86400*30);
                put_cookie('xmbuser', $username, $currtime, $cookiepath, $cookiedomain);
                put_cookie('xmbpw', $password, $currtime, $cookiepath, $cookiedomain);
            }

            gallery_info($lang['replymsg'],'gallery_image.php?action=view&iid='.$iid.'&page='.$topicpages.'#pid'.$pid);
        }
        break;

    case 'edit':
        if (!isset($editsubmit)) {
            if (isset($previewpost) || (isset($subaction) && $subaction == 'spellcheck' && (isset($spellchecksubmit) || isset($updates_submit)))) {
                $postinfo = array('usesig'=>$usesig, 'bbcodeoff'=>$bbcodeoff, 'smileyoff'=>$smileyoff, 'message'=>$message, 'subject'=>$subject);
            } else {
                $query = $db->query("SELECT * FROM $table_imgcomments WHERE pid='$pid'");
                $postinfo = $db->fetch_array($query);
            }

            $postinfo['message'] = stripslashes($postinfo['message']);

            if ($postinfo['bbcodeoff'] == 'yes') {
                $offcheck1 = 'checked="checked"';
            } else {
                $offcheck1 = '';
            }

            if ($postinfo['smileyoff'] == 'yes') {
                $offcheck2 = 'checked="checked"';
            } else {
                $offcheck2 = '';
            }

            if ($postinfo['usesig'] == 'yes') {
                $offcheck3 = 'checked="checked"';
            } else {
                $offcheck3 = '';
            }

            if (!X_STAFF) {
                $querysmilie = $db->query("SELECT * FROM $table_smilies WHERE type='picon' AND (url NOT LIKE '%rsvd%')");
                while ($smilie = $db->fetch_array($querysmilie)) {
                    if ($postinfo['icon'] == $smilie['url']) {
                        $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" checked="checked"/><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
                    } else {
                        $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" /><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
                    }
                    $listed_icons += 1;
                    if ($listed_icons == 9) {
                        $icons .= '<br />';
                        $listed_icons = 0;
                    }
                }
            } else {
                $querysmilie = $db->query("SELECT * FROM $table_smilies WHERE type='picon'");
                while ($smilie = $db->fetch_array($querysmilie)) {
                    if ($postinfo['icon'] == $smilie['url']) {
                        $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" checked="checked"/><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
                    } else {
                        $icons .= ' <input type="radio" name="posticon" value="'.$smilie['url'].'" /><img src="'.$smdir.'/'.$smilie['url'].'" alt="'.$smilie['code'].'" border="0" />';
                    }
                    $listed_icons += 1;
                    if ($listed_icons == 9) {
                        $icons .= '<br />';
                        $listed_icons = 0;
                    }
                }
            }

            $postinfo['subject'] = stripslashes($postinfo['subject']);
            $postinfo['subject'] = str_replace('"', '&quot;', $postinfo['subject']);

            if (!X_SADMIN) {
                $postinfo['subject'] = censor($postinfo['subject']);
            }

            $message = $postinfo['message'];
            $subject = $postinfo['subject'];

            if (isset($previewpost)) {
                $message = censor($message);
            }

            eval('$edit = "'.template('img_comment_edit').'";');
            echo $edit;
        } else {
            if (X_GUEST) {
                $username = trim($username);
                $password = md5(trim($password));
            }
            $q = $db->query("SELECT * FROM $table_members WHERE username='$username'");
            if ($db->num_rows($q) != 1) {
                gallery_error($lang['badname']);
            }
            else {
                $self = $db->fetch_array($q);
                if ($password != $self['password']) {
                    gallery_error($lang['textpw1']);
                }
                $username = $self['username'];
            }
            if ($self['status'] == 'Banned') {
                gallery_error($lang['bannedmessage']);
            }
            $currtime = $onlinetime + (86400*30);
            put_cookie('xmbuser', $username, $currtime, $cookiepath, $cookiedomain);
            put_cookie('xmbpw', $password, $currtime, $cookiepath, $cookiedomain);
            if ($self['ban'] == 'posts' || $self['ban'] == 'both') {
                gallery_error($lang['textbanfrompost']);
            }

            $date = gmdate($dateformat);
            if ($SETTINGS['editedby'] == 'on') {
                $message .= "\n\n[".$lang['textediton'].' '.$date.' '.$lang['textby'].' '.$username.']';
            }

            $subject = addslashes(trim($subject));

            if (isset($posticon) && !empty($posticon)) {
                $query = $db->query("SELECT id FROM $table_smilies WHERE type='picon' AND url='$posticon'");
                if (!$db->result($query, 0)) {
                    exit;
                }
            } else {
                $posticon = '';
            }

            $subject = checkInput($subject, $chkInputTags, $chkInputHTML, '', false);
            $message = checkInput($message, $chkInputTags, $chkInputHTML, '', true);
            $posticon = htmlspecialchars($posticon);

            $query = $db->query("SELECT p.author as author, m.status as status FROM $table_imgcomments p LEFT JOIN $table_members m ON p.author=m.username WHERE pid='$pid' AND iid='$iid' AND cid='$cid'");
            $orig = $db->fetch_array($query);

            $message = addslashes(trim($message));

            if ((X_ADMIN) || ($username == $orig['author'])) {
                if ($SETTINGS['allowrankedit'] != 'off') {
                    switch($orig['status']) {
                        case 'Super Administrator':
                            if (!X_SADMIN && $xmbuser != $orig['author']) {
                                gallery_error($lang['noedit']);
                            }
                            break;
                        case 'Administrator':
                            if (!X_ADMIN && $xmbuser != $orig['author']) {
                                gallery_error($lang['noedit']);
                            }
                            break;
                    }
                }
                $db->query("UPDATE $table_imgcomments SET message='$message', usesig='$usesig', bbcodeoff='$bbcodeoff', smileyoff='$smileyoff', icon='$posticon', subject='$subject' WHERE pid='$pid'");

                if (isset($delete) && $delete == 'yes') {
                    $db->query("UPDATE $table_members SET postnum=postnum-1 WHERE username='$orig[author]'");
                    $db->query("DELETE FROM $table_imgcomments WHERE pid='$pid'");
                    $db->query("UPDATE $table_imgimages SET comments=comments-1 WHERE iid = '$iid'");
                }
            } else {
                gallery_error($lang['noedit']);
            }

            $query = $db->query("SELECT pid FROM $table_imgcomments WHERE iid='$iid'");
            $numrows = $db->num_rows($query);
            $db->free_result($query);

            if ($numrows != 0) {
                $query =$db->query("SELECT COUNT(pid) FROM $table_imgcomments WHERE pid<=$pid AND iid='$iid' AND cid='$cid'");
                $posts = $db->result($query,0);
                $topicpages = quickpage($posts, $ppp);
                gallery_info($lang['img_infocommentedit'],'gallery_image.php?action=view&iid='.$iid.'&page='.$topicpages.'#pid'.$pid);
            } else {
                gallery_info($lang['img_infocommentedit'],'gallery_image.php?action=view&iid='.$iid.'#pictop');
            }
        }
        break;
}

eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>