<?php
/* $Id: gallery_admin.php,v 1.2 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

loadtemplates(
'img_admin',
'img_admin_settings',
'img_admin_albums',
'img_admin_albums_settings',
'img_footer',
'img_error'
);

// make static var for select
$selHTML = 'selected="selected"';

//  Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

nav('<a href="./gallery.php">'.stripslashes($gsettings['title']).'</a>');
nav($lang['img_textadminpanel']);

eval('$css = "'.template('css').'";');
eval('echo "'.template('header').'";');

// Check to see if the user belongs here
if (!X_ADMIN) {
    eval('echo "'.template('error_nologinsession').'";');
    end_time();
    eval('echo "'.template('footer').'";');
    exit();
}

$auditaction = $_SERVER['REQUEST_URI'];
$aapos = strpos($auditaction, '?');
if ($aapos !== false) {
    $auditaction = substr($auditaction, $aapos + 1);
}

$auditaction = addslashes('$onlineip|#|$auditaction');
audit($xmbuser, $auditaction, 0, 0);

$adminpage = '';

// Settings
switch ($action) {
    case 'settings':
        if (!isset($submit) || !$submit) {
            //  This builds the settings page that displays the current gallery settings.

            $who_view_gallery_1 = $who_view_gallery_2 = $who_view_gallery_3 = '';
            switch ($gsettings['who_view_gallery']) {
                case '1':
                    $who_view_gallery_1 = $selHTML;
                    break;
                case '2':
                    $who_view_gallery_2 = $selHTML;
                    break;
                case '3':
                    $who_view_gallery_3 = $selHTML;
                    break;
            }

            $move_1 = $move_2 = $move_3 = '';
            switch ($gsettings['move']) {
                case '1':
                    $move_1 = $selHTML;
                    break;
                case '2':
                    $move_2 = $selHTML;
                    break;
                case '3':
                    $move_3 = $selHTML;
                    break;
            }

            $who_create_1 = $who_create_2 = $who_create_3 = '';
            switch ($gsettings['who_create']) {
                case '1':
                    $who_create_1 = $selHTML;
                    break;
                case '2':
                    $who_create_2 = $selHTML;
                    break;
                case '3':
                    $who_create_3 = $selHTML;
                    break;
            }

            $show_sub_albumsoff = $show_sub_albumson = '';
            switch ($gsettings['show_sub_albums']) {
                case 'on':
                    $show_sub_albumson = $selHTML;
                    break;
                default:
                    $show_sub_albumsoff = $selHTML;
                    break;
            }

            $whoadd_1 = $whoadd_2 = $whoadd_3 = '';
            switch ($gsettings['whoadd']) {
                case '1':
                    $whoadd_1 = $selHTML;
                    break;
                case '2':
                    $whoadd_2 = $selHTML;
                    break;
                case '3':
                    $whoadd_3 = $selHTML;
                    break;
            }

            $who_upload_1 = $who_upload_2 = $who_upload_3 = '';
            switch ($gsettings['who_upload']) {
                case '1':
                    $who_upload_1 = $selHTML;
                    break;
                case '2':
                    $who_upload_2 = $selHTML;
                    break;
                case '3':
                    $who_upload_3 = $selHTML;
                    break;
            }

            $album_order_1 = $album_order_2 = $album_order_3 = '';
            switch ($gsettings['album_order']) {
                case 'name':
                    $album_order_1 = $selHTML;
                    break;
                case 'cid':
                    $album_order_2 = $selHTML;
                    break;
                case 'displayorder':
                    $album_order_3 = $selHTML;
                    break;
            }

            $image_order_1 = $image_order_2 = '';
            switch ($gsettings['image_order']) {
                case 'name':
                    $image_order_1 = $selHTML;
                     break;
                case 'dateline':
                    $image_order_2 = $selHTML;
                     break;
            }

            $display_albums_1 = $display_albums_2 = $display_albums_3 = '';
            switch ($gsettings['display_albums']) {
                case '1':
                    $display_albums_1 = $selHTML;
                    break;
                case '2':
                    $display_albums_2 = $selHTML;
                    break;
                case '3':
                    $display_albums_3 = $selHTML;
                    break;
            }

            $display_images_2 = $display_images_3 = '';
            switch ($gsettings['display_images'] ) {
                case '2':
                    $display_images_2 = $selHTML;
                    break;
                case '3':
                    $display_images_3 = $selHTML;
                    break;
            }

            $rules_1 = $rules_2 = $rules_3 = $rules_4 = '';
            switch ($gsettings['rules']) {
                case $lang['img_textrules1']:
                    $rules_1 = $selHTML;
                    break;
                case $lang['img_textrules2']:
                    $rules_2 = $selHTML;
                    break;
                case $lang['img_textrules3']:
                    $rules_3 = $selHTML;
                    break;
                case $lang['img_textrules4']:
                    $rules_4 = $selHTML;
                    break;
            }

            $show_sub_albumsoff = $show_sub_albumson = '';
            switch ($gsettings['show_sub_albums']) {
                case 'on':
                    $show_sub_albumson = $selHTML;
                    break;
                default:
                    $show_sub_albumsoff = $selHTML;
                    break;
            }

            $resize_thumboff = $resize_thumbon = '';
            switch ($gsettings['resize_thumb']) {
                case 'on':
                    $resize_thumbon = $selHTML;
                    break;
                default:
                    $resize_thumboff = $selHTML;
                    break;
            }

            $member_subalbumsoff = $member_subalbumson = '';
            switch ($gsettings['member_subalbums']) {
                case 'on':
                    $member_subalbumson = $selHTML;
                    break;
                default:
                    $member_subalbumsoff = $selHTML;
                    break;
            }

            $creator_onlyoff = $creator_onlyon = '';
            switch ($gsettings['creator_only']) {
                case 'on':
                    $creator_onlyon = $selHTML;
                    break;
                default:
                    $creator_onlyoff = $selHTML;
                    break;
            }

            $printableoff = $printableon = '';
            switch ($gsettings['printable']) {
                case 'on':
                    $printableon = $selHTML;
                    break;
                default:
                    $printableoff = $selHTML;
                    break;
            }

            $uploadoff = $uploadon = '';
            switch ($gsettings['upload']) {
                case 'on':
                    $uploadon = $selHTML;
                    break;
                default:
                    $uploadoff = $selHTML;
                    break;
            }

            $multi_uploadoff = $multi_uploadon = '';
            switch ($gsettings['multi_upload']) {
                case 'on':
                    $multi_uploadon = $selHTML;
                    break;
                default:
                    $multi_uploadoff = $selHTML;
                    break;
            }

            $commentsoff = $commentson = '';
            switch ($gsettings['comments']) {
                case 'on':
                    $commentson = $selHTML;
                    break;
                default:
                    $commentsoff = $selHTML;
                    break;
            }

            $allowhtmloff = $allowhtmlon = '';
            switch ($gsettings['allowhtml']) {
                case 'on':
                    $allowhtmlon = $selHTML;
                    break;
                default:
                    $allowhtmloff = $selHTML;
                    break;
            }

            $allowsmiliesoff = $allowsmilieson = '';
            switch ($gsettings['allowsmilies']) {
                case 'on':
                    $allowsmilieson = $selHTML;
                    break;
                default:
                    $allowsmiliesoff = $selHTML;
                    break;
            }

            $allowbbcodeoff = $allowbbcodeon = '';
            switch ($gsettings['allowbbcode']) {
                case 'on':
                    $allowbbcodeon = $selHTML;
                    break;
                default:
                    $allowbbcodeoff = $selHTML;
                    break;
            }

            $allowimgcodeoff = $allowimgcodeon = '';
            switch ($gsettings['allowimgcode']) {
                case 'on':
                    $allowimgcodeon = $selHTML;
                    break;
                default:
                    $allowimgcodeoff = $selHTML;
                    break;
            }

            $ratingoff = $ratingon = '';
            switch ($gsettings['rating']) {
                case 'on':
                    $ratingon = $selHTML;
                    break;
                default:
                    $ratingoff = $selHTML;
                    break;
            }

            $statsoff = $statson = '';
            switch ($gsettings['stats']) {
                case 'on':
                    $statson = $selHTML;
                    break;
                default:
                    $statsoff = $selHTML;
                    break;
            }

            $searchoff = $searchon = '';
            switch ($gsettings['search']) {
                case 'on':
                    $searchon = $selHTML;
                    break;
                default:
                    $searchoff = $selHTML;
                    break;
            }

            $slideshowoff = $slideshowon = '';
            switch ($gsettings['slideshow']) {
                case 'on':
                    $slideshowon = $selHTML;
                    break;
                default:
                    $slideshowoff = $selHTML;
                    break;
            }

            $gsettings['title'] = stripslashes($gsettings['title']);
            $gsettings['rule_left'] = stripslashes($gsettings['rule_left']);
            $gsettings['rule_right'] = stripslashes($gsettings['rule_right']);
            eval('$adminpage = "'.template('img_admin_settings').'";');
        } else {
            //  Need to add default settings to switches...
            $show_sub_albums_new = ($show_sub_albums_new == 'on') ? 'on' : 'off';
            $resize_thumb_new = ($resize_thumb_new == 'off') ? 'off' : 'on';
            $member_subalbums_new = ($member_subalbums_new == 'on') ? 'on' : 'off';
            $creator_only_new = ($creator_only_new == 'on') ? 'on' : 'off';
            $printable_new = ($printable_new == 'on') ? 'on' : 'off';
            $upload_new = ($upload_new == 'off') ? 'off' : 'on';
            $multi_upload_new = ($multi_upload_new == 'on') ? 'on' : 'off';
            $comments_new = ($comments_new == 'on') ? 'on' : 'off';
            $allowhtml_new = ($allowhtml_new == 'on') ? 'on' : 'off';
            $allowsmilies_new = ($allowsmilies_new == 'off') ? 'off' : 'on';
            $allowbbcode_new = ($allowbbcode_new == 'off') ? 'off' : 'on';
            $allowimgcode_new = ($allowimgcode_new == 'off') ? 'off' : 'on';
            $rating_new = ($rating_new == 'on') ? 'on' : 'off';
            $stats_new = ($stats_new == 'on') ? 'on' : 'off';
            $slideshow_new = ($slideshow_new == 'on') ? 'on' : 'off';
            $search_new = ($search_new == 'on') ? 'on' : 'off';

            $title_new = addslashes(trim($title_new));
            $rule_right_new = addslashes(trim($rule_right_new));
            $rule_left_new = addslashes(trim($rule_left_new));

            //  This applies the changes to the settings and displays a confirmation message..
            $db->query("UPDATE $table_imgsettings SET title = '$title_new', max_thumb_width = '$max_thumb_width_new', max_thumb_height = '$max_thumb_height_new', max_image_width = '$max_image_width_new', max_image_height = '$max_image_height_new', max_image_size = '$max_image_size_new', display_images = '$display_images_new', display_albums = '$display_albums_new', thumbs_on_row = '$thumbs_on_row_new', upload = '$upload_new', who_upload = '$who_upload_new', max_upl_mem = '$max_upl_mem_new', max_cat_mem = '$max_cat_mem_new', max_img_mem = '$max_img_mem_new', who_create = '$who_create_new', whoadd = '$whoadd_new', album_order = '$album_order_new', hot_cat = '$hot_cat_new', thumbs_on_page = '$thumbs_on_page_new', image_order = '$image_order_new', resize_thumb = '$resize_thumb_new', who_view_gallery = '$who_view_gallery_new', rating = '$rating_new', comments = '$comments_new', allowhtml = '$allowhtml_new', allowsmilies = '$allowsmilies_new', allowbbcode = '$allowbbcode_new', allowimgcode = '$allowimgcode_new', multi_upload = '$multi_upload_new', stats = '$stats_new', creator_only = '$creator_only_new', slideshow = '$slideshow_new', pause = '$pause_new', printable = '$printable_new', show_sub_albums = '$show_sub_albums_new', member_subalbums = '$member_subalbums_new', search = '$search_new', rules = '$rules_new', rule_left = '$rule_left_new', rule_right = '$rule_right_new', move = '$move_new'");
            $adminpage = '<tr bgcolor='.$altbg1.' class=tablerow><td align=center>'.$lang['img_infosettingsupdate'].'</td></tr>';
        }
        break;

    case'albums':
        // Albums
        if (!isset($_POST['albumsubmit']) && !isset($adetails)) {
            $albums = array();
            $albumlist = array();
            $subalbums = array();
            $i = 0;
            $query = $db->query("SELECT cid, name, displayorder, status, sub FROM $table_imgcats ORDER BY sub ASC, cid ASC, displayorder ASC");
            while ($selalbums = $db->fetch_array($query)) {
                $selalbums['name'] = stripslashes($selalbums['name']);
                if ($selalbums['sub'] == 0) {
                    $albums[$i]['cid'] = $selalbums['cid'];
                    $albums[$i]['name'] = $selalbums['name'];
                    $albums[$i]['displayorder'] = $selalbums['displayorder'];
                    $albums[$i]['status'] = $selalbums['status'];
                    $albumlist[$i]['cid'] = $selalbums['cid'];
                    $albumlist[$i]['name'] = $selalbums['name'];
                } else {
                    $subalbums[$selalbums['sub']][$i]['cid'] = $selalbums['cid'];
                    $subalbums[$selalbums['sub']][$i]['name'] = $selalbums['name'];
                    $subalbums[$selalbums['sub']][$i]['displayorder'] = $selalbums['displayorder'];
                    $subalbums[$selalbums['sub']][$i]['status'] = $selalbums['status'];
                    $subalbums[$selalbums['sub']][$i]['sub'] = $selalbums['sub'];
                }
                $i++;
            }
            $db->free_result($query);
            //  This will loop through the existing albums and sub-albums, and build a
            //  line for each entry.
            $albumlines = '';
            foreach ($albums as $group) {
                $on = $off = '';
                switch ($group['status']) {
                    case 'on':
                        $on = $selHTML;
                        break;
                    default:
                        $off = $selHTML;
                        break;
                }

                $albumlines = $albumlines.'<tr bgcolor='.$altbg2.' class= tablerow align="left">';
                $albumlines = $albumlines.'<td class=smalltxt>';
                $albumlines = $albumlines.'<input type=checkbox name="delete'.$group['cid'].'" value="'.$group['cid'].'"/> &nbsp;';
                $albumlines = $albumlines.'<input type="text" name="name'.$group['cid'].'" value="'.$group['name'].'" READONLY /> &nbsp;'.$lang['textorder'];
                $albumlines = $albumlines.'<input type="text" name="displayorder'.$group['cid'].'" size="2" value="'.$group['displayorder'].'" /> &nbsp;';
                $albumlines = $albumlines.'<select name="status'.$group['cid'].'"><option value="on"'.$on.'>'.$lang['texton'].'</option><option value="off"'.$off.'>'.$lang['textoff'].'</option></select>';
                $albumlines = $albumlines.'<a href="gallery_admin.php?action=albums&amp;adetails='.$group['cid'].'">&nbsp;'.$lang['textmoreopts'].'</a>';
                $albumlines = $albumlines.'</td>';
                $albumlines = $albumlines.'</tr>';

                if (array_key_exists($group['cid'], $subalbums)) {
                    foreach ($subalbums[$group['cid']] as $subAlbum) {
                        $on = $off = '';
                        switch ($subAlbum['status']) {
                            case 'on':
                                $on = $selHTML;
                                break;
                            default:
                                $off = $selHTML;
                                break;
                        }
                        $albumlines = $albumlines.'<tr bgcolor='.$altbg2.' class= tablerow align="left">';
                        $albumlines = $albumlines.'<td class="smalltxt"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ';
                        $albumlines = $albumlines.'<input type="checkbox" name="delete'.$subAlbum['cid'].'" value="'.$subAlbum['cid'].'"/> &nbsp;';
                        $albumlines = $albumlines.'<input type="text" name="name'.$subAlbum['cid'].'" value="'.$subAlbum['name'].'" READONLY /> &nbsp;'.$lang['textorder'];
                        $albumlines = $albumlines.'<input type="text" name="displayorder'.$subAlbum['cid'].'" size="2" value="'.$subAlbum['displayorder'].'" /> &nbsp;';
                        $albumlines = $albumlines.'<select name="status'.$subAlbum['cid'].'"><option value="on"'.$on.'>'.$lang['texton'].'</option><option value="off"'.$off.'>'.$lang['textoff'].'</option></select>';
                        $albumlines = $albumlines.'<a href="gallery_admin.php?action=albums&amp;adetails='.$subAlbum['cid'].'">&nbsp;'.$lang['textmoreopts'].'</a>';
                        $albumlines = $albumlines.'</td>';
                        $albumlines = $albumlines.'</tr>';
                    }
                }
            }

            //  This will build the contents of the drop down to select the album when
            //  creating a new sub-album
            $selectalbum = '';
            foreach ($albumlist as $group) {
                $group['name'] = stripslashes($group['name']);
                $selectalbum = $selectalbum.'<option value="'.$group['cid'].'">'.$group['name'].'</option>';
            }
            eval('$adminpage = "'.template('img_admin_albums').'";');
        } elseif (isset($adetails) && !isset($_POST['albumsubmit'])) {
            //  this should paint the album details screen
            $aquery = $db->query("SELECT * FROM $table_imgcats WHERE cid='$adetails'");
            $asettings = $db->fetch_array($aquery);
            $db->free_result($aquery);

            $whoadd_1 = $whoadd_2 = $whoadd_3 = '';
            switch ($asettings['who_add']) {
                case '1':
                    $whoadd_1 = $selHTML;
                    break;
                case '2':
                    $whoadd_2 = $selHTML;
                    break;
                case '3':
                    $whoadd_3 = $selHTML;
                    break;
            }

            $whoview_1 = $whoview_2 = $whoview_3 = '';
            switch ($asettings['who_view']) {
                case '1':
                    $whoview_1 = $selHTML;
                    break;
                case '2':
                    $whoview_2 = $selHTML;
                    break;
                case '3':
                    $whoview_3 = $selHTML;
                    break;
            }

            $creator_onlyoff = $creator_onlyon = '';
            switch ($asettings['creator_only']) {
                case 'on':
                    $creator_onlyon = $selHTML;
                    break;
                default:
                    $creator_onlyoff = $selHTML;
                    break;
            }

            $asettings['name'] = stripslashes($asettings['name']);
            $asettings['description'] = stripslashes($asettings['description']);
            $asettings['view_list'] = stripslashes($asettings['view_list']);
            $asettings['add_list'] = stripslashes($asettings['add_list']);
            $asettings['author'] = stripslashes($asettings['author']);
            eval('$adminpage = "'.template('img_admin_albums_settings').'";');
        } elseif (isset($_POST['albumsubmit'])) {
            if (!isset($adetails)) {
                // Should be here when submit is pressed from the create album window
                $queryalbum = $db->query("SELECT cid, sub FROM $table_imgcats");
                while ($album = $db->fetch_array($queryalbum)) {
                    $displayorder = 'displayorder'.$album['cid'];
                    $displayorder = "${$displayorder}";
                    $name = 'name'.$album['cid'];
                    $name = "${$name}";
                    $self['status'] = 'status'.$album['cid'];
                    $self['status'] = "${$self['status']}";
                    $delete = 'delete'.$album['cid'];
                    $delete = isset(${$delete}) ? ${$delete} : '';

                    if (!empty($delete)) {
                        // Remove the album from the database
                        gallery_deletealbumdb($delete);
                    } else {
                        $name = addslashes(trim($name));
                        //  Name is not updated yet, need to consider file system...
                        $db->query("UPDATE $table_imgcats SET displayorder='$displayorder', status='$self[status]' WHERE cid='$album[cid]'");
                    }
                }
                $db->free_result($queryalbum);

                // This will add a new album
                if ($album_name_new != $lang['img_textnewalbum']) {
                    // This will validate the album name.
                    if (!strlen(trim($album_name_new)) > 0) {
                       gallery_error($lang['img_errornoalbumname']);
                    }

                    $album_name_new = addslashes(trim($album_name_new));
                    $db->query("INSERT INTO $table_imgcats( cid, name, status, displayorder, sub, author, creator_only ) VALUES ( '', '$album_name_new', '$album_status_new', '$album_displayorder_new', '0', '$self[username]', '$gsettings[creator_only]')");
                }
                // This will add a new sub album
                if ($subalbum_name_new != $lang['img_textnewsubalbum']) {
                    if (!strlen(trim($subalbum_name_new)) > 0) {
                        gallery_error($lang['img_errornoalbumname']);
                    }

                    $subalbum_name_new = addslashes(trim($subalbum_name_new));
                    $db->query("INSERT INTO $table_imgcats( cid, name, status, displayorder, sub, author, creator_only ) VALUES ( '', '$subalbum_name_new', '$subalbum_status_new', '$subalbum_displayorder_new', '$subalbum_album_new', '$self[username]', '$gsettings[creator_only]')");
                }
                $adminpage = '<tr bgcolor="'.$altbg1.'" class="ctrtablerow"><td>'.$lang['img_infoalbumsupdate'].'</td></tr>';
            } else {
                // Should come here when pressing submit from the album details window
                if (!strlen(trim($name_new)) > 0) {
                    gallery_error($lang['img_errornoalbumname']);
                }

                $name_new = addslashes(trim($name_new));
                $desc_new = addslashes(trim($desc_new));
                $view_list_new = addslashes(trim($view_list_new));
                $add_list_new = addslashes(trim($add_list_new));
                $createdby_new = addslashes(trim($createdby_new));
                $delete = isset($delete) ? '$delete' : '';
                $creator_only_new = ($creator_only_new == 'on') ? 'on' : 'off';

                if (!empty($delete)) {
                    // Remove the album from the database.
                    gallery_deletealbumdb($adetails);
                } else {
                    $db->query("UPDATE $table_imgcats SET name='$name_new', description = '$desc_new', author = '$createdby_new', who_view = '$whoview_new', view_list = '$view_list_new', who_add = '$whoadd_new', add_list = '$add_list_new', password = '$password_new', creator_only = '$creator_only_new' WHERE cid='$adetails'");
                }
                $adminpage = '<tr bgcolor="'.$altbg1.'" class="tablerow"><td align="center">'.$lang['img_infoalbumsupdate'].'</td></tr>';
            }
        }
        break;
}

//  This displays the page and the footer.
eval('echo "'.template('img_admin').'";');
eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>