<?php
/* $Id: gallery.php,v 1.3 2006/03/10 06:42:37 johnbriggs Exp $ */
/*
    Name: Photo Gallery v2.0
    Author: Steven Waters, John Briggs
    Contributors: Jack Faxon, Stalker, Spike, Bigdumredneck, Elmo
    Copyright  2006 XMBMods.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('header.php');
require_once(ROOT.'include/gallery.functions.inc.php');

loadtemplates(
'img_links',
'img_album_list',
'img_gallery',
'img_footer',
'img_album_icon',
'img_album_detail_begin',
'img_album_lastpost',
'index_forum_nolastpost',
'img_album_detail',
'img_textrules'
);

eval('$css = "'.template('css').'";');

// Retrieve the gallery settings, store them in an array
$query = $db->query("SELECT * FROM $table_imgsettings");
$gsettings = $db->fetch_array($query);
$db->free_result($query);

nav(stripslashes($gsettings['title']));

//  Check for permissions to view the gallery
$gallery_viewpermission = privfcheck($gsettings['who_view_gallery'],'');
if (!$gallery_viewpermission) {
    eval('echo "'.template('header').'";');
    gallery_error($lang['img_errorprivgallery']);
}

// If the install file is still here, try to remove it.
// If it can't be removed, get out.
if (file_exists('gallery_install.php') && !@unlink('gallery_install.php')) {
    exit('<h1>Error:</h1><br />The install file ("gallery_install.php") has been found on the server, but could not be removed. Please remove it as soon as possible.');
}

// If the upgrade file is still here, try to remove it.
// If it can't be removed, get out.
if (file_exists('gallery_upgrade.php') && !@unlink('gallery_upgrade.php')) {
    exit('<h1>Error:</h1><br />The upgrade file ("gallery_upgrade.php") has been found on the server, but could not be removed. Please remove it as soon as possible.');
}

$action = (isset($action) ? $action : '');
$iid = (isset($iid) ? (int) $iid : 0);
$cid = (isset($cid) ? (int) $cid : 0);
switch ($action) {
    case 'viewthumb':
        //  Sanity check for permissions to view the album
        if (!gallery_viewalbumperm($cid)) {
            exit;
        }

        $query = $db->query("SELECT * FROM $table_imgthumbnails WHERE iid='$iid'");
        $file = $db->fetch_array($query);
        $type = $file['filetype'];
        // Generate $type, $name and $size vars

        // Put out headers for mime-type, description and no-cache.
        header("Content-type: $type");
        header("Content-Description: Image Thumbnail");
        header("Cache-Control: public; max-age=604800"); // http 1.1
        header("Expires: 604800"); // http 1.0

        // Start file download
        echo $file['thumbnail'];

        // End download
        exit;
    case 'viewimage':
        //  Sanity check for permissions to view the album
        if (!gallery_viewalbumperm($cid)) {
            exit;
        }

        $query = $db->query("SELECT * FROM $table_imgimagedata WHERE iid='$iid'");
        $file = $db->fetch_array($query);
        $type = $file['filetype'];
        // Generate $type, $name and $size vars

        // Put out headers for mime-type, description and no-cache.
        header("Content-type: $type");
        header("Content-Description: Image Thumbnail");
        header("Cache-Control: public; max-age=604800"); // http 1.1
        header("Expires: 604800"); // http 1.0

        // Start file download
        echo $file['imagedata'];

        // End download
        exit;
    default:
        // get a list of albums and subalbums the user should have rights to.
        $albumlist = gallery_albums();

        // Build the gallery display
        $albumrows = '';
        $foundalbum = false;

        switch ($gsettings['display_albums']) {
            case '1':
                //  If the display settings is 'list'.
                $tab1 = '<td bgcolor="'.$altbg2.'" align="center"><table width="90%">';

                for ($i=0; $i< count($albumlist); $i++) {
                    if ($albumlist[$i]['sub'] == 0) {
                        $cid = $albumlist[$i]['cid'];
                        $query = $db->query("SELECT description, closed, images FROM $table_imgcats WHERE cid='$cid'");
                        $album = $db->fetch_array($query);
                        $db->free_result($query);
                        $albums['images'] = $album['images'];
                        $albums['cid'] = $albumlist[$i]['cid'];
                        $albums['name'] = $albumlist[$i]['name'];
                        $albums['description'] = stripslashes($album['description']);
                        $albums['closed'] = ($album['closed'] == 'yes') ? 'yes' : 'no';
                        $foundalbum = true;
                        switch ($album['closed']) {
                            case 'closed':
                                $folder = '<img src="'.$imgdir.'/lock_folder.gif" alt="'.$lang['altclosedtopic'].'" title="'.$lang['altclosedtopic'].'" border="0" />';
                                break;
                            default:
                                if ($album['images'] >= $gsettings['hot_cat']) {
                                    $folder = '<img src="'.$imgdir.'/hot_folder.gif" alt="'.$lang['hot_folder'].'" title="'.$lang['hot_folder'].'" border="0" />';
                                } else {
                                    $folder = '<img src="'.$imgdir.'/folder.gif" alt="'.$lang['altfolder'].'" title="'.$lang['altfolder'].'" border="0" />';
                                }
                                break;
                        }
                        eval('$albumrows .= "'.template('img_album_list').'";');
                    }
                }

                if (!$foundalbum) {
                    $albumrows = '<tr><td><span class="smalltxt">'.$lang['img_textnoalbum'].'</span></td></tr>';
                }

                $tab2 = '</table></td>';
                break;

            case '2':
                //  If the display settings is 'icons'.
                $j = 0;
                $tab1 = '<td bgcolor="'.$altbg2.'" align="center"><table width="90%"><tr>';
                for ($i=0; $i< count($albumlist); $i++) {
                    if ($albumlist[$i]['sub'] == 0) {
                        $break = '';
                        $j = $j+1;

                        $albums['cid'] = $albumlist[$i]['cid'];
                        $name = $albumlist[$i]['name'];
                        $link = 'gallery_view_album.php?cid='.$albums['cid'];
                        $foundalbum = true;
                        $image = $db->query("SELECT i.url as url, i.thumb as thumb, t.height as height, t.width as width
                                    FROM $table_imgimages i LEFT JOIN $table_imgthumbnails t ON i.iid=t.iid WHERE i.cid=$albums[cid] ORDER BY i.dateline ASC LIMIT 1");
                        $url = $db->fetch_array($image);
                        $db->free_result($image);
                        if (empty($url['thumb']) && empty($url['url'])) {
                            $thumb = '<a href="'.$link.'"><img src="'.$imgdir.'/noimg.gif" alt="'.$lang['img_textnoimages'].'" title="'.$lang['img_textnoimages'].'" border="0" /></a>';
                        } else {
                            $resize = '';
                            if ($url['thumb'] != 'resize') {
                                $url = $url['thumb'];
                                $resize = gallery_resize($url,'thumb',$url['height'],$url['width']);
                            } else {
                                $url = $url['url'];
                                $resize = gallery_resize($url,'thumb');
                            }
                            $url = stripslashes($url);
                            $thumb = '<a href="'.$link.'"><img src="'.$url.'" alt="'.$name.'" title="'.$name.'" border="0" '.$resize.' /></a>';
                        }

                        if ($j == $gsettings['thumbs_on_row']) {
                            $j = 0;
                            $break = '</tr><tr>';
                        }
                        eval('$albumrows .= "'.template('img_album_icon').'";');
                    }
                }

                if (!$foundalbum) {
                    $albumrows = '<td><span class="smalltxt">'.$lang['img_textnoalbum'].'</span></td>';
                }

                $tab2 = '</tr></table></td>';
                break;

            case '3':
                //  If the display settings is 'details'.
                $j = 0;
                $tab1 = '';
                eval('$tab1 .= "'.template('img_album_detail_begin').'";');
                for($i=0; $i< count($albumlist); $i++) {
                    if ($albumlist[$i]['sub'] == 0) {
                        $cid = $albumlist[$i]['cid'];
                        $query = $db->query("SELECT description, closed, images, views, lastpost FROM $table_imgcats WHERE cid='$cid'");
                        $album = $db->fetch_array($query);
                        $db->free_result($query);

                        $name = $albumlist[$i]['name'];
                        $description = stripslashes($album['description']);
                        $images = $album['images'];
                        $views = $album['views'];
                        $album['closed'] = ($album['closed'] == 'yes') ? 'yes' : 'no';
                        $foundalbum = true;

                        switch ($album['closed']) {
                            case 'closed':
                                $folder = '<img src="'.$imgdir.'/lock_folder.gif" alt="'.$lang['altclosedtopic'].'" title="'.$lang['altclosedtopic'].'" border="0" />';
                                break;
                            default;
                                if ($album['images'] >= $gsettings['hot_cat']) {
                                    $folder = '<img src="'.$imgdir.'/hot_folder.gif" alt="'.$lang['hot_folder'].'" title="'.$lang['hot_folder'].'" border="0" />';
                                } else {
                                    $folder = '<img src="'.$imgdir.'/folder.gif" alt="'.$lang['altfolder'].'" title="'.$lang['altfolder'].'" border="0" />';
                                }
                                break;
                        }
                        $subcats = '';

                        if (!empty($album['lastpost'])) {
                            $lastpost = explode('|', $album['lastpost']);
                            $dalast = $lastpost[0];
                            if ($lastpost[1] != 'Anonymous' && $lastpost[1] != '') {
                                $lastpost[1] = '<a href="member.php?action=viewpro&amp;member='.rawurlencode($lastpost[1]).'">'.$lastpost[1].'</a>';
                            } else {
                                $lastpost[1] = $lang['textanonymous'];
                            }
                            $lastimage = $db->query("SELECT iid FROM $table_imgimages WHERE cid=$cid ORDER BY dateline DESC LIMIT 1");
                            if ($db->num_rows($lastimage) == 0) {
                                $dalast = 0;
                                $lastpost = $lang['textnever'];
                                eval('$lastpostrow = "'.template('index_forum_nolastpost').'";');
                            } else {
                                $iid = $db->result($lastimage, 0);
                                $db->free_result($lastimage);

                                $lastpostdate = gmdate($dateformat, $lastpost[0] + ($timeoffset * 3600) + ($addtime * 3600));
                                $lastposttime = gmdate($timecode, $lastpost[0] + ($timeoffset * 3600) + ($addtime * 3600));
                                $lastpost = $lastpostdate.' '.$lang['textat'].' '.$lastposttime.'<br />'.$lang['textby'].' '.$lastpost[1];
                                eval('$lastpostrow = "'.template('img_album_lastpost').'";');
                            }
                        } else {
                            $dalast = 0;
                            $lastpost = $lang['textnever'];
                            eval('$lastpostrow = "'.template('index_forum_nolastpost').'";');
                        }

                        // If show sub albums is on, find the name of the subalbums and display them under
                        // the album name
                        // Get the subalbum info for this album
                        if ($gsettings['show_sub_albums'] == 'on') {
                            for ($i++; $i < count($albumlist); $i++) {
                                //  Need to decrement $i, it will be re-incremented after
                                if ($albumlist[$i]['sub'] != $cid) {
                                    $i--;
                                    break;
                                }
                                $subname = $albumlist[$i]['name'];
                                $subcid =  $albumlist[$i]['cid'];
                                $subalbum = $db->result($db->query("SELECT images FROM $table_imgcats WHERE cid='$subcid'"),0);
                                $subcats = ($subcats == '') ? '<br />' : $subcats;
                                $subcats .= '&nbsp; &raquo; <a href="gallery_view_album.php?cid='.$subcid.'"><font class="smalltxt"><strong>'.$subname.' ('.$subalbum.')</strong></font></a> ';
                            }
                        }
                        eval('$albumrows .= "'.template('img_album_detail').'";');
                    }
                }

                if (!$foundalbum) {
                    $albumrows = '<tr><td bgcolor="'.$altbg1.'" colspan="5"><span class="smalltxt">'.$lang['img_textnoalbum'].'</div></td></tr>';
                }
                $tab2 = '';
                break;
    }
        break;
}



//rules
$rules = '';
if ($gsettings['rules'] == 'All' || $gsettings['rules'] == 'Gallery') {
    $rule_left = postify($gsettings['rule_left'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    $rule_right = postify($gsettings['rule_right'], 'no', 'no', 'yes', 'no', 'yes', 'no', true, 'yes');
    eval('$rules = "'.template('img_textrules').'";');
}

//  Display the gallery
eval('echo "'.template('header').'";');
eval('echo "'.template('img_gallery').'";');

// Build the links
$displaylinks = array();

if (X_ADMIN) {
    $displaylinks[] = '<a href="gallery_admin.php">'.$lang['img_textadmin'].'</a>';
}

if ($gsettings['stats'] == 'on') {
    $displaylinks[] = '<a href="gallery_stats.php">'.$lang['textstats'].'</a>';
}

if ($gsettings['search'] == 'on') {
    $displaylinks[] = '<a href="gallery_search.php">'.$lang['textsearch'].'</a>';
}

//  Check for permissions to album create link
if (gallery_createpermission()){
    $displaylinks[] = '<a href="gallery_user_album.php?action=createalbum">'.$lang['img_textnewalbum'].'</a>';
}

$displaylinks = implode(' | ', $displaylinks);

eval('echo "'.template('img_links').'";');
eval('echo "'.template('img_footer').'";');
end_time();
eval('echo "'.template('footer').'";');
?>